/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.connectors.csv.impl;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.connectors.csv.impl.CsvParser;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.util.control.NonFatal$;

@InternalApi
public class CsvParsingStage
extends GraphStage<FlowShape<ByteString, List<ByteString>>> {
    public final byte org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$delimiter;
    public final byte org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$quoteChar;
    public final byte org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$escapeChar;
    public final int org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$maximumLineLength;
    public final Inlet<ByteString> org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$in;
    public final Outlet<List<ByteString>> org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$out;
    private final FlowShape shape;

    public CsvParsingStage(byte delimiter, byte quoteChar, byte escapeChar, int maximumLineLength) {
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$delimiter = delimiter;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$quoteChar = quoteChar;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$escapeChar = escapeChar;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$maximumLineLength = maximumLineLength;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$in = Inlet$.MODULE$.apply(new StringBuilder(3).append(Logging$.MODULE$.simpleName(this)).append(".in").toString());
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$out = Outlet$.MODULE$.apply(new StringBuilder(4).append(Logging$.MODULE$.simpleName(this)).append(".out").toString());
        this.shape = FlowShape$.MODULE$.apply(this.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$in, this.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$out);
    }

    @Override
    public FlowShape<ByteString, List<ByteString>> shape() {
        return this.shape;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("CsvParsing");
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private final CsvParser buffer;
            private final /* synthetic */ CsvParsingStage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.buffer = new CsvParser($outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$delimiter, $outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$quoteChar, $outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$escapeChar, $outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$maximumLineLength);
                this.setHandlers($outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$in, $outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$out, this);
            }

            public void onPush() {
                this.buffer.offer(this.grab(this.$outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$in));
                this.tryPollBuffer();
            }

            public void onPull() {
                this.tryPollBuffer();
            }

            public void onUpstreamFinish() {
                this.emitRemaining();
                this.completeStage();
            }

            private void tryPollBuffer() {
                try {
                    Option<List<ByteString>> option = this.buffer.poll(true);
                    if (option instanceof Some) {
                        List csvLine = (List)((Some)option).value();
                        this.push(this.$outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$out, csvLine);
                    } else if (this.isClosed(this.$outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$in)) {
                        this.emitRemaining();
                        this.completeStage();
                    } else {
                        this.pull(this.$outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$in);
                    }
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = option.get();
                        this.failStage(ex);
                    }
                    throw throwable;
                }
            }

            private void emitRemaining() {
                Option<List<ByteString>> option;
                while ((option = this.buffer.poll(false)) instanceof Some) {
                    List csvLine = (List)((Some)option).value();
                    this.emit(this.$outer.org$apache$pekko$stream$connectors$csv$impl$CsvParsingStage$$out, csvLine);
                }
            }
        };
    }
}

