/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.connectors.csv.impl;

import java.nio.charset.UnsupportedCharsetException;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.connectors.csv.MalformedCsvException;
import org.apache.pekko.stream.connectors.csv.impl.CsvParser$;
import org.apache.pekko.stream.connectors.csv.scaladsl.ByteOrderMark$;
import org.apache.pekko.util.ByteIterator;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class CsvParser {
    private final byte delimiter;
    private final byte quoteChar;
    private final byte escapeChar;
    private final int maximumLineLength;
    public ByteString org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer;
    private boolean firstData;
    public int org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
    private int lineBytesDropped;
    public int org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart;
    private long currentLineNo;
    private final ListBuffer<ByteString> columns;
    private int state;
    private final FieldBuilder fieldBuilder;
    private ByteIterator current;

    public CsvParser(byte delimiter, byte quoteChar, byte escapeChar, int maximumLineLength) {
        this.delimiter = delimiter;
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
        this.maximumLineLength = maximumLineLength;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer = ByteString$.MODULE$.empty();
        this.firstData = true;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos = 0;
        this.lineBytesDropped = 0;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = 0;
        this.currentLineNo = 1L;
        this.columns = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new ByteString[0]));
        this.state = 0;
        this.fieldBuilder = new FieldBuilder();
        this.current = ByteString$.MODULE$.empty().iterator();
    }

    private int lineLength() {
        return this.lineBytesDropped + this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
    }

    public void offer(ByteString next) {
        if (next.nonEmpty()) {
            Predef$.MODULE$.require(this.current.isEmpty(), CsvParser::offer$$anonfun$1);
            this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer.$plus$plus(next);
            this.current = next.iterator();
            return;
        }
    }

    public Option<List<ByteString>> poll(boolean requireLineEnd) {
        Option<List<ByteString>> line;
        if (this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer.nonEmpty()) {
            this.parseLine();
        }
        if ((line = this.maybeExtractLine(requireLineEnd)).nonEmpty()) {
            ++this.currentLineNo;
            if (this.state == 4 || !requireLineEnd) {
                this.state = 0;
            }
            this.resetLine();
            this.columns.clear();
        }
        return line;
    }

    private void advance(int n) {
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos += n;
        this.current.drop(n);
    }

    private int advance$default$1() {
        return 1;
    }

    private void resetLine() {
        this.dropReadBuffer();
        this.lineBytesDropped = 0;
    }

    private void dropReadBuffer() {
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer.drop(this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos);
        this.lineBytesDropped += this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos = 0;
        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = 0;
    }

    private Nothing$ noCharEscaped() {
        throw new MalformedCsvException(this.currentLineNo, this.lineLength(), new StringBuilder(46).append("wrong escaping at ").append(this.currentLineNo).append(":").append(this.lineLength()).append(", no character after escape").toString());
    }

    private void checkForByteOrderMark() {
        if (this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer.length() >= 2) {
            ByteString byteString = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer;
            if (byteString.startsWith((IterableOnce)ByteOrderMark$.MODULE$.UTF_8(), byteString.startsWith$default$2())) {
                this.advance(3);
                this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = 3;
                return;
            }
            ByteString byteString2 = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer;
            if (byteString2.startsWith((IterableOnce)ByteOrderMark$.MODULE$.UTF_16_LE(), byteString2.startsWith$default$2())) {
                throw new UnsupportedCharsetException("UTF-16 LE and UTF-32 LE");
            }
            ByteString byteString3 = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer;
            if (byteString3.startsWith((IterableOnce)ByteOrderMark$.MODULE$.UTF_16_BE(), byteString3.startsWith$default$2())) {
                throw new UnsupportedCharsetException("UTF-16 BE");
            }
            ByteString byteString4 = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer;
            if (byteString4.startsWith((IterableOnce)ByteOrderMark$.MODULE$.UTF_32_BE(), byteString4.startsWith$default$2())) {
                throw new UnsupportedCharsetException("UTF-32 BE");
            }
            return;
        }
    }

    private void parseLine() {
        if (this.firstData) {
            this.checkForByteOrderMark();
            this.firstData = false;
        }
        this.churn();
    }

    private void churn() {
        block11: while (this.state != 4 && this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos < this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer.length()) {
            if (this.lineLength() >= this.maximumLineLength) {
                throw new MalformedCsvException(this.currentLineNo, this.lineLength(), new StringBuilder(46).append("no line end encountered within ").append(this.maximumLineLength).append(" bytes on line ").append(this.currentLineNo).toString());
            }
            byte by = this.current.head();
            int n = this.state;
            switch (n) {
                case 0: {
                    byte by2 = by;
                    if (this.quoteChar == by2) {
                        this.state = 5;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    if (this.escapeChar == by2) {
                        this.fieldBuilder.init();
                        this.state = 2;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    if (this.delimiter == by2) {
                        this.columns.$plus$eq(ByteString$.MODULE$.empty());
                        this.state = 3;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    if (CsvParser$.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$$LF == by2) {
                        this.columns.$plus$eq(ByteString$.MODULE$.empty());
                        this.state = 4;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    if (CsvParser$.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$$CR == by2) {
                        this.columns.$plus$eq(ByteString$.MODULE$.empty());
                        this.state = 9;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    byte b = by2;
                    this.fieldBuilder.add(b);
                    this.state = 1;
                    this.advance(this.advance$default$1());
                    continue block11;
                }
                case 3: {
                    byte by3 = by;
                    if (this.quoteChar == by3) {
                        this.state = 5;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    if (this.escapeChar == by3) {
                        this.fieldBuilder.init();
                        this.state = 2;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    if (this.delimiter == by3) {
                        this.columns.$plus$eq(ByteString$.MODULE$.empty());
                        this.state = 3;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    if (CsvParser$.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$$LF == by3) {
                        this.columns.$plus$eq(ByteString$.MODULE$.empty());
                        this.state = 4;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    if (CsvParser$.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$$CR == by3) {
                        this.columns.$plus$eq(ByteString$.MODULE$.empty());
                        this.state = 9;
                        this.advance(this.advance$default$1());
                        this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart = this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos;
                        continue block11;
                    }
                    byte b = by3;
                    this.fieldBuilder.add(b);
                    this.state = 1;
                    this.advance(this.advance$default$1());
                    continue block11;
                }
                case 1: {
                    byte by4 = by;
                    if (this.escapeChar == by4) {
                        this.fieldBuilder.init();
                        this.state = 2;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    if (this.delimiter == by4) {
                        this.columns.$plus$eq(this.fieldBuilder.result(this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos));
                        this.state = 3;
                        this.advance(this.advance$default$1());
                        this.dropReadBuffer();
                        continue block11;
                    }
                    if (CsvParser$.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$$LF == by4) {
                        this.columns.$plus$eq(this.fieldBuilder.result(this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos));
                        this.state = 4;
                        this.advance(this.advance$default$1());
                        this.dropReadBuffer();
                        continue block11;
                    }
                    if (CsvParser$.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$$CR == by4) {
                        this.columns.$plus$eq(this.fieldBuilder.result(this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos));
                        this.state = 9;
                        this.advance(this.advance$default$1());
                        this.dropReadBuffer();
                        continue block11;
                    }
                    byte b = by4;
                    this.fieldBuilder.add(b);
                    this.state = 1;
                    this.advance(this.advance$default$1());
                    continue block11;
                }
                case 2: {
                    byte by5 = by;
                    if (this.escapeChar == by5 || this.delimiter == by5) {
                        this.fieldBuilder.add(by);
                        this.state = 1;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    if (this.quoteChar == by5) {
                        throw new MalformedCsvException(this.currentLineNo, this.lineLength(), new StringBuilder(41).append("wrong escaping at ").append(this.currentLineNo).append(":").append(this.lineLength()).append(", quote is escaped as ").append((char)this.quoteChar).append((char)this.quoteChar).toString());
                    }
                    byte b = by5;
                    this.fieldBuilder.add(this.escapeChar);
                    this.state = 1;
                    continue block11;
                }
                case 5: {
                    byte by6 = by;
                    if (this.escapeChar == by6 && this.escapeChar != this.quoteChar) {
                        this.fieldBuilder.init();
                        this.state = 7;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    if (this.quoteChar == by6) {
                        this.fieldBuilder.init();
                        this.state = 8;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    byte b = by6;
                    this.fieldBuilder.add(b);
                    this.state = 6;
                    this.advance(this.advance$default$1());
                    continue block11;
                }
                case 6: {
                    byte by7 = by;
                    if (this.escapeChar == by7 && this.escapeChar != this.quoteChar) {
                        this.fieldBuilder.init();
                        this.state = 7;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    if (this.quoteChar == by7) {
                        this.fieldBuilder.init();
                        this.state = 8;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    byte b = by7;
                    this.fieldBuilder.add(b);
                    this.state = 6;
                    this.advance(this.advance$default$1());
                    continue block11;
                }
                case 7: {
                    byte by8 = by;
                    if (this.escapeChar == by8 || this.quoteChar == by8) {
                        this.fieldBuilder.add(by);
                        this.state = 6;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    byte b = by8;
                    this.fieldBuilder.add(this.escapeChar);
                    this.state = 6;
                    continue block11;
                }
                case 8: {
                    byte by9 = by;
                    if (this.quoteChar == by9) {
                        this.fieldBuilder.add(by);
                        this.state = 6;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    byte b = by9;
                    this.state = 1;
                    continue block11;
                }
                case 9: {
                    byte by10 = by;
                    if (CsvParser$.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$$CR == by10) {
                        this.state = 9;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    if (CsvParser$.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$$LF == by10) {
                        this.state = 4;
                        this.advance(this.advance$default$1());
                        continue block11;
                    }
                    this.state = 4;
                    continue block11;
                }
            }
            throw new MatchError(BoxesRunTime.boxToInteger(n));
        }
    }

    private Option<List<ByteString>> maybeExtractLine(boolean requireLineEnd) {
        if (requireLineEnd) {
            int n = this.state;
            if (4 == n) {
                return Some$.MODULE$.apply(this.columns.toList());
            }
            return None$.MODULE$;
        }
        int n = this.state;
        switch (n) {
            case 3: {
                this.columns.$plus$eq(ByteString$.MODULE$.empty());
                return Some$.MODULE$.apply(this.columns.toList());
            }
            case 6: {
                throw new MalformedCsvException(this.currentLineNo, this.lineLength(), new StringBuilder(57).append("unclosed quote at end of input ").append(this.currentLineNo).append(":").append(this.lineLength()).append(", no matching quote found").toString());
            }
            case 1: {
                this.columns.$plus$eq(this.fieldBuilder.result(this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos));
                return Some$.MODULE$.apply(this.columns.toList());
            }
            case 8: {
                this.columns.$plus$eq(this.fieldBuilder.result(this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos - 1));
                return Some$.MODULE$.apply(this.columns.toList());
            }
            case 2: 
            case 7: {
                throw this.noCharEscaped();
            }
        }
        if (this.columns.nonEmpty()) {
            return Some$.MODULE$.apply(this.columns.toList());
        }
        return None$.MODULE$;
    }

    private static final Object offer$$anonfun$1() {
        return "offer(ByteString) may not be called before all buffered input is parsed.";
    }

    public final class FieldBuilder {
        private boolean useBuilder;
        private ByteStringBuilder builder;

        public FieldBuilder() {
            if (CsvParser.this == null) {
                throw new NullPointerException();
            }
            this.useBuilder = false;
        }

        public void init() {
            if (!this.useBuilder) {
                this.builder = ByteString$.MODULE$.newBuilder().$plus$plus$eq(CsvParser.this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer.slice(CsvParser.this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart, CsvParser.this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$pos));
                this.useBuilder = true;
                return;
            }
        }

        public void add(byte x) {
            if (this.useBuilder) {
                this.builder.$plus$eq(BoxesRunTime.boxToByte(x));
                return;
            }
        }

        public ByteString result(int pos) {
            if (this.useBuilder) {
                this.useBuilder = false;
                return this.builder.result();
            }
            return CsvParser.this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$buffer.slice(CsvParser.this.org$apache$pekko$stream$connectors$csv$impl$CsvParser$$fieldStart, pos);
        }

        public final /* synthetic */ CsvParser org$apache$pekko$stream$connectors$csv$impl$CsvParser$FieldBuilder$$$outer() {
            return CsvParser.this;
        }
    }
}

