/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.connectors.csv.impl;

import java.nio.charset.Charset;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.connectors.csv.impl.CsvFormatter$;
import org.apache.pekko.stream.connectors.csv.scaladsl.CsvQuotingStyle;
import org.apache.pekko.stream.connectors.csv.scaladsl.CsvQuotingStyle$Always$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple2$mcZI$sp;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InternalApi
public class CsvFormatter {
    private final char delimiter;
    private final char quoteChar;
    private final char escapeChar;
    private final CsvQuotingStyle quotingStyle;
    private final String charsetName;
    private final ByteString delimiterBs;
    private final ByteString quoteBs;
    private final ByteString duplicatedQuote;
    private final ByteString duplicatedEscape;
    private final ByteString endOfLineBs;

    public static Charset $lessinit$greater$default$6() {
        return CsvFormatter$.MODULE$.$lessinit$greater$default$6();
    }

    public CsvFormatter(char delimiter, char quoteChar, char escapeChar, String endOfLine, CsvQuotingStyle quotingStyle, Charset charset) {
        this.delimiter = delimiter;
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
        this.quotingStyle = quotingStyle;
        this.charsetName = charset.name();
        this.delimiterBs = ByteString$.MODULE$.apply(String.valueOf(delimiter), this.charsetName);
        this.quoteBs = ByteString$.MODULE$.apply(String.valueOf(quoteChar), this.charsetName);
        this.duplicatedQuote = ByteString$.MODULE$.apply(String.valueOf(new char[]{quoteChar, quoteChar}), this.charsetName);
        this.duplicatedEscape = ByteString$.MODULE$.apply(String.valueOf(new char[]{escapeChar, escapeChar}), this.charsetName);
        this.endOfLineBs = ByteString$.MODULE$.apply(endOfLine, this.charsetName);
    }

    public ByteString toCsv(Iterable<Object> fields) {
        if (fields.nonEmpty()) {
            return this.nonEmptyToCsv(fields);
        }
        return this.endOfLineBs;
    }

    private ByteString nonEmptyToCsv(Iterable<Object> fields) {
        ByteStringBuilder builder = ByteString$.MODULE$.createBuilder();
        Iterator iterator = fields.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            Object next = iterator.next();
            if (next != null) {
                this.append$1(builder, next.toString());
            }
            if (!(hasNext = iterator.hasNext())) continue;
            builder.$plus$plus$eq(this.delimiterBs);
        }
        builder.$plus$plus$eq(this.endOfLineBs);
        return builder.result();
    }

    private Tuple2<Object, Object> requiresQuotesOrSplit(String field2) {
        boolean quotes = CsvQuotingStyle$Always$.MODULE$.equals(this.quotingStyle);
        int split = -1;
        for (int index = 0; !(index >= field2.length() || quotes && split != -1); ++index) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field2), index);
            if (c == this.quoteChar || c == this.escapeChar) {
                quotes = true;
                split = index;
                continue;
            }
            if (c != '\r' && c != '\n' && c != this.delimiter) continue;
            quotes = true;
        }
        return Tuple2$.MODULE$.apply(BoxesRunTime.boxToBoolean(quotes), BoxesRunTime.boxToInteger(split));
    }

    private final int indexOfQuoteOrEscape$1(String field$1, int lastIndex) {
        int found = -1;
        for (int index = lastIndex; index < field$1.length() && found == -1; ++index) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field$1), index);
            if (c != this.quoteChar && c != this.escapeChar) continue;
            found = index;
        }
        return found;
    }

    private final void splitAndDuplicateQuotesAndEscapes$1(ByteStringBuilder builder$1, String field2, int splitAt) {
        int lastIndex = 0;
        int index = splitAt;
        while (index > -1) {
            builder$1.$plus$plus$eq(ByteString$.MODULE$.apply(field2.substring(lastIndex, index), this.charsetName));
            char c = field2.charAt(index);
            ByteStringBuilder byteStringBuilder = c == this.quoteChar ? builder$1.$plus$plus$eq(this.duplicatedQuote) : builder$1.$plus$plus$eq(this.duplicatedEscape);
            lastIndex = index + 1;
            index = this.indexOfQuoteOrEscape$1(field2, lastIndex);
        }
        if (lastIndex < field2.length()) {
            builder$1.$plus$plus$eq(ByteString$.MODULE$.apply(field2.substring(lastIndex), this.charsetName));
            return;
        }
    }

    private final ByteStringBuilder append$1(ByteStringBuilder builder$2, String field2) {
        block7: {
            Object object;
            int splitAt;
            block6: {
                Tuple2<Object, Object> tuple2 = this.requiresQuotesOrSplit(field2);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean quoteIt = tuple2._1$mcZ$sp();
                int splitAt2 = tuple2._2$mcI$sp();
                Tuple2$mcZI$sp tuple2$mcZI$sp = new Tuple2$mcZI$sp(quoteIt, splitAt2);
                boolean quoteIt2 = ((Tuple2)tuple2$mcZI$sp)._1$mcZ$sp();
                splitAt = ((Tuple2)tuple2$mcZI$sp)._2$mcI$sp();
                if (quoteIt2) break block6;
                CsvQuotingStyle csvQuotingStyle = this.quotingStyle;
                CsvQuotingStyle$Always$ csvQuotingStyle$Always$ = CsvQuotingStyle$Always$.MODULE$;
                if (csvQuotingStyle != null ? !csvQuotingStyle.equals(csvQuotingStyle$Always$) : csvQuotingStyle$Always$ != null) break block7;
            }
            builder$2.$plus$plus$eq(this.quoteBs);
            if (splitAt != -1) {
                this.splitAndDuplicateQuotesAndEscapes$1(builder$2, field2, splitAt);
                object = BoxedUnit.UNIT;
            } else {
                object = builder$2.$plus$plus$eq(ByteString$.MODULE$.apply(field2, this.charsetName));
            }
            return builder$2.$plus$plus$eq(this.quoteBs);
        }
        return builder$2.$plus$plus$eq(ByteString$.MODULE$.apply(field2, this.charsetName));
    }
}

