/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.stream.ActorMaterializerSettings;
import org.apache.pekko.stream.ActorMaterializerSettings$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.SystemMaterializer$;
import org.apache.pekko.stream.impl.MaterializerGuardian;
import org.apache.pekko.stream.impl.MaterializerGuardian$;
import org.apache.pekko.stream.impl.MaterializerGuardian$LegacyStartMaterializer$;
import org.apache.pekko.stream.impl.MaterializerGuardian$StartMaterializer$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;

public final class SystemMaterializer
implements Extension {
    @InternalApi
    private final ActorMaterializerSettings materializerSettings;
    private final Timeout materializerTimeout;
    @InternalApi
    private final ActorRef materializerGuardian;
    private final Materializer materializer;

    public static Extension apply(ActorSystem actorSystem) {
        return SystemMaterializer$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return SystemMaterializer$.MODULE$.apply(classicActorSystemProvider);
    }

    public static SystemMaterializer createExtension(ExtendedActorSystem extendedActorSystem) {
        return SystemMaterializer$.MODULE$.createExtension(extendedActorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return SystemMaterializer$.MODULE$.get(actorSystem);
    }

    public static SystemMaterializer get(ActorSystem actorSystem) {
        return SystemMaterializer$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return SystemMaterializer$.MODULE$.get(classicActorSystemProvider);
    }

    public static SystemMaterializer get(ClassicActorSystemProvider classicActorSystemProvider) {
        return SystemMaterializer$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return SystemMaterializer$.MODULE$.lookup();
    }

    public SystemMaterializer(ExtendedActorSystem system) {
        Promise<Materializer> systemMaterializerPromise = Promise$.MODULE$.apply();
        this.materializerSettings = ActorMaterializerSettings$.MODULE$.apply(system);
        this.materializerTimeout = Timeout$.MODULE$.durationToTimeout(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(system.settings().config().getDuration("pekko.stream.materializer.creation-timeout"))));
        this.materializerGuardian = system.systemActorOf(MaterializerGuardian$.MODULE$.props(systemMaterializerPromise, this.materializerSettings()).withDispatcher("pekko.actor.internal-dispatcher").withDeploy(Deploy$.MODULE$.local()), "Materializers");
        this.materializer = Await$.MODULE$.result(systemMaterializerPromise.future(), this.materializerTimeout.duration());
    }

    public ActorMaterializerSettings materializerSettings() {
        return this.materializerSettings;
    }

    @InternalApi
    public Materializer createAdditionalSystemMaterializer() {
        ActorRef actorRef = package$.MODULE$.ask(this.materializerGuardian);
        MaterializerGuardian$StartMaterializer$ materializerGuardian$StartMaterializer$ = MaterializerGuardian$StartMaterializer$.MODULE$;
        Future started = AskableActorRef$.MODULE$.$qmark$extension(actorRef, materializerGuardian$StartMaterializer$, this.materializerTimeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, materializerGuardian$StartMaterializer$)).mapTo(ClassTag$.MODULE$.apply(MaterializerGuardian.MaterializerStarted.class));
        return ((MaterializerGuardian.MaterializerStarted)Await$.MODULE$.result(started, this.materializerTimeout.duration())).materializer();
    }

    @InternalApi
    public Materializer createAdditionalLegacySystemMaterializer(String namePrefix, ActorMaterializerSettings settings) {
        ActorRef actorRef = package$.MODULE$.ask(this.materializerGuardian);
        MaterializerGuardian.LegacyStartMaterializer legacyStartMaterializer = MaterializerGuardian$LegacyStartMaterializer$.MODULE$.apply(namePrefix, settings);
        Future started = AskableActorRef$.MODULE$.$qmark$extension(actorRef, legacyStartMaterializer, this.materializerTimeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, legacyStartMaterializer)).mapTo(ClassTag$.MODULE$.apply(MaterializerGuardian.MaterializerStarted.class));
        return ((MaterializerGuardian.MaterializerStarted)Await$.MODULE$.result(started, this.materializerTimeout.duration())).materializer();
    }

    public Materializer materializer() {
        return this.materializer;
    }
}

