/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream;

import java.time.Duration;
import java.util.function.Predicate;
import org.apache.pekko.stream.RestartSettings$;
import org.apache.pekko.stream.RestartSettings$LogSettings$;
import org.apache.pekko.util.FunctionConverters$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import scala.Function1;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.FunctionWrappers$RichPredicateAsFunction1$;

public final class RestartSettings {
    private final FiniteDuration minBackoff;
    private final FiniteDuration maxBackoff;
    private final double randomFactor;
    private final int maxRestarts;
    private final FiniteDuration maxRestartsWithin;
    private final LogSettings logSettings;
    private final Function1 restartOn;

    public static RestartSettings apply(FiniteDuration finiteDuration, FiniteDuration finiteDuration2, double d) {
        return RestartSettings$.MODULE$.apply(finiteDuration, finiteDuration2, d);
    }

    public static RestartSettings create(Duration duration, Duration duration2, double d) {
        return RestartSettings$.MODULE$.create(duration, duration2, d);
    }

    public static LogSettings createLogSettings(int n) {
        return RestartSettings$.MODULE$.createLogSettings(n);
    }

    public RestartSettings(FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, int maxRestarts, FiniteDuration maxRestartsWithin, LogSettings logSettings, Function1<Throwable, Object> restartOn) {
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.randomFactor = randomFactor;
        this.maxRestarts = maxRestarts;
        this.maxRestartsWithin = maxRestartsWithin;
        this.logSettings = logSettings;
        this.restartOn = restartOn;
    }

    public FiniteDuration minBackoff() {
        return this.minBackoff;
    }

    public FiniteDuration maxBackoff() {
        return this.maxBackoff;
    }

    public double randomFactor() {
        return this.randomFactor;
    }

    public int maxRestarts() {
        return this.maxRestarts;
    }

    public FiniteDuration maxRestartsWithin() {
        return this.maxRestartsWithin;
    }

    public LogSettings logSettings() {
        return this.logSettings;
    }

    public Function1<Throwable, Object> restartOn() {
        return this.restartOn;
    }

    public RestartSettings withMinBackoff(FiniteDuration value) {
        return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public RestartSettings withMinBackoff(Duration value) {
        return this.copy(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(value)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public RestartSettings withMaxBackoff(FiniteDuration value) {
        return this.copy(this.copy$default$1(), value, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public RestartSettings withMaxBackoff(Duration value) {
        FiniteDuration finiteDuration = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(value));
        FiniteDuration finiteDuration2 = this.copy$default$1();
        double d = this.copy$default$3();
        int n = this.copy$default$4();
        FiniteDuration finiteDuration3 = this.copy$default$5();
        LogSettings logSettings = this.copy$default$6();
        Function1<Throwable, Object> function1 = this.copy$default$7();
        return this.copy(finiteDuration2, finiteDuration, d, n, finiteDuration3, logSettings, function1);
    }

    public RestartSettings withRandomFactor(double value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), value, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public RestartSettings withMaxRestarts(int count, FiniteDuration within) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), count, within, this.copy$default$6(), this.copy$default$7());
    }

    public RestartSettings withMaxRestarts(int count, Duration within) {
        FiniteDuration finiteDuration = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(within));
        FiniteDuration finiteDuration2 = this.copy$default$1();
        FiniteDuration finiteDuration3 = this.copy$default$2();
        double d = this.copy$default$3();
        LogSettings logSettings = this.copy$default$6();
        Function1<Throwable, Object> function1 = this.copy$default$7();
        return this.copy(finiteDuration2, finiteDuration3, d, count, finiteDuration, logSettings, function1);
    }

    public RestartSettings withRestartOn(Predicate<Throwable> restartOn) {
        Predicate predicate = FunctionConverters$.MODULE$.enrichAsScalaFromPredicate((Predicate)restartOn);
        Function1<Throwable, Object> function1 = FunctionWrappers$RichPredicateAsFunction1$.MODULE$.asScala$extension(predicate);
        FiniteDuration finiteDuration = this.copy$default$1();
        FiniteDuration finiteDuration2 = this.copy$default$2();
        double d = this.copy$default$3();
        int n = this.copy$default$4();
        FiniteDuration finiteDuration3 = this.copy$default$5();
        LogSettings logSettings = this.copy$default$6();
        return this.copy(finiteDuration, finiteDuration2, d, n, finiteDuration3, logSettings, function1);
    }

    public RestartSettings withLogSettings(LogSettings newLogSettings) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), newLogSettings, this.copy$default$7());
    }

    public String toString() {
        return new StringBuilder(16).append("RestartSettings(").append(new StringBuilder(12).append("minBackoff=").append(this.minBackoff()).append(",").toString()).append(new StringBuilder(12).append("maxBackoff=").append(this.maxBackoff()).append(",").toString()).append(new StringBuilder(14).append("randomFactor=").append(this.randomFactor()).append(",").toString()).append(new StringBuilder(13).append("maxRestarts=").append(this.maxRestarts()).append(",").toString()).append(new StringBuilder(19).append("maxRestartsWithin=").append(this.maxRestartsWithin()).append(")").toString()).toString();
    }

    private RestartSettings copy(FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, int maxRestarts, FiniteDuration maxRestartsWithin, LogSettings logSettings, Function1<Throwable, Object> restartOn) {
        return new RestartSettings(minBackoff, maxBackoff, randomFactor, maxRestarts, maxRestartsWithin, logSettings, restartOn);
    }

    private FiniteDuration copy$default$1() {
        return this.minBackoff();
    }

    private FiniteDuration copy$default$2() {
        return this.maxBackoff();
    }

    private double copy$default$3() {
        return this.randomFactor();
    }

    private int copy$default$4() {
        return this.maxRestarts();
    }

    private FiniteDuration copy$default$5() {
        return this.maxRestartsWithin();
    }

    private LogSettings copy$default$6() {
        return this.logSettings();
    }

    private Function1<Throwable, Object> copy$default$7() {
        return this.restartOn();
    }

    public static final class LogSettings {
        private final int logLevel;
        private final int criticalLogLevel;
        private final int criticalLogLevelAfter;

        public static LogSettings apply(int n) {
            return RestartSettings$LogSettings$.MODULE$.apply(n);
        }

        public static LogSettings defaultSettings() {
            return RestartSettings$LogSettings$.MODULE$.defaultSettings();
        }

        public LogSettings(int logLevel, int criticalLogLevel, int criticalLogLevelAfter) {
            this.logLevel = logLevel;
            this.criticalLogLevel = criticalLogLevel;
            this.criticalLogLevelAfter = criticalLogLevelAfter;
        }

        public int logLevel() {
            return this.logLevel;
        }

        public int criticalLogLevel() {
            return this.criticalLogLevel;
        }

        public int criticalLogLevelAfter() {
            return this.criticalLogLevelAfter;
        }

        public LogSettings withLogLevel(int level) {
            return this.org$apache$pekko$stream$RestartSettings$LogSettings$$copy(level, this.org$apache$pekko$stream$RestartSettings$LogSettings$$copy$default$2(), this.org$apache$pekko$stream$RestartSettings$LogSettings$$copy$default$3());
        }

        public LogSettings withCriticalLogLevel(int criticalLevel, int afterErrors) {
            return this.org$apache$pekko$stream$RestartSettings$LogSettings$$copy(this.copy$default$1(), criticalLevel, afterErrors);
        }

        public LogSettings org$apache$pekko$stream$RestartSettings$LogSettings$$copy(int logLevel, int criticalLogLevel, int criticalLogLevelAfter) {
            return new LogSettings(logLevel, criticalLogLevel, criticalLogLevelAfter);
        }

        private int copy$default$1() {
            return this.logLevel();
        }

        public int org$apache$pekko$stream$RestartSettings$LogSettings$$copy$default$2() {
            return this.criticalLogLevel();
        }

        public int org$apache$pekko$stream$RestartSettings$LogSettings$$copy$default$3() {
            return this.criticalLogLevelAfter();
        }
    }
}

