/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.MapAsyncPartitioned$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.Supervision;
import org.apache.pekko.stream.Supervision$Stop$;
import org.apache.pekko.stream.impl.ContextPropagation;
import org.apache.pekko.stream.impl.ContextPropagation$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public final class MapAsyncPartitioned<In, Out, Partition>
extends GraphStage<FlowShape<In, Out>> {
    public final int org$apache$pekko$stream$MapAsyncPartitioned$$parallelism;
    public final boolean org$apache$pekko$stream$MapAsyncPartitioned$$orderedOutput;
    public final Function1<In, Partition> org$apache$pekko$stream$MapAsyncPartitioned$$partitioner;
    public final Function2<In, Partition, Future<Out>> org$apache$pekko$stream$MapAsyncPartitioned$$f;
    public final Inlet<In> org$apache$pekko$stream$MapAsyncPartitioned$$in;
    public final Outlet<Out> org$apache$pekko$stream$MapAsyncPartitioned$$out;
    private final FlowShape shape;

    public MapAsyncPartitioned(int parallelism, boolean orderedOutput, Function1<In, Partition> partitioner, Function2<In, Partition, Future<Out>> f) {
        this.org$apache$pekko$stream$MapAsyncPartitioned$$parallelism = parallelism;
        this.org$apache$pekko$stream$MapAsyncPartitioned$$orderedOutput = orderedOutput;
        this.org$apache$pekko$stream$MapAsyncPartitioned$$partitioner = partitioner;
        this.org$apache$pekko$stream$MapAsyncPartitioned$$f = f;
        Predef$.MODULE$.require(parallelism >= 1, MapAsyncPartitioned::$init$$$anonfun$1);
        Predef$.MODULE$.require(partitioner != null, MapAsyncPartitioned::$init$$$anonfun$2);
        Predef$.MODULE$.require(f != null, MapAsyncPartitioned::$init$$$anonfun$3);
        this.org$apache$pekko$stream$MapAsyncPartitioned$$in = Inlet$.MODULE$.apply("MapAsyncPartitioned.in");
        this.org$apache$pekko$stream$MapAsyncPartitioned$$out = Outlet$.MODULE$.apply("MapAsyncPartitioned.out");
        this.shape = FlowShape$.MODULE$.apply(this.org$apache$pekko$stream$MapAsyncPartitioned$$in, this.org$apache$pekko$stream$MapAsyncPartitioned$$out);
    }

    @Override
    public FlowShape<In, Out> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(inheritedAttributes, this){
            private final Attributes inheritedAttributes$1;
            public static final long OFFSET$0;
            public final ContextPropagation org$apache$pekko$stream$MapAsyncPartitioned$$anon$1$$contextPropagation;
            private volatile Object decider$lzy1;
            private Set partitionsInProgress;
            private Queue buffer;
            private final AsyncCallback futureCB;
            private final Function0 pushNextIfPossible;
            private final /* synthetic */ MapAsyncPartitioned $outer;
            {
                this.inheritedAttributes$1 = inheritedAttributes$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.org$apache$pekko$stream$MapAsyncPartitioned$$anon$1$$contextPropagation = ContextPropagation$.MODULE$.apply();
                this.futureCB = this.getAsyncCallback(holder -> {
                    Try<Out> try_ = holder.out();
                    if (try_ instanceof Success) {
                        this.pushNextIfPossible.apply$mcV$sp();
                        return;
                    }
                    if (try_ instanceof Failure) {
                        Throwable ex = ((Failure)try_).exception();
                        Supervision.Directive directive = holder.supervisionDirectiveFor(this.decider(), ex);
                        if (Supervision$Stop$.MODULE$.equals(directive)) {
                            this.failStage(ex);
                            return;
                        }
                        this.pushNextIfPossible.apply$mcV$sp();
                        return;
                    }
                    throw new MatchError(try_);
                });
                this.pushNextIfPossible = $outer.org$apache$pekko$stream$MapAsyncPartitioned$$orderedOutput ? () -> this.pushNextIfPossibleOrdered() : () -> this.pushNextIfPossibleUnordered();
                this.setHandlers($outer.org$apache$pekko$stream$MapAsyncPartitioned$$in, $outer.org$apache$pekko$stream$MapAsyncPartitioned$$out, this);
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("decider$lzy1"));
            }

            private Function1 decider() {
                Object object = this.decider$lzy1;
                if (object instanceof Function1) {
                    return (Function1)object;
                }
                if (object == LazyVals$NullValue$.MODULE$) {
                    return null;
                }
                return (Function1)this.decider$lzyINIT1();
            }

            private Object decider$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.decider$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            Function1<Throwable, Supervision.Directive> function1 = null;
                            try {
                                function1 = ((ActorAttributes.SupervisionStrategy)this.inheritedAttributes$1.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.SupervisionStrategy.class))).decider();
                                object2 = function1 == null ? LazyVals$NullValue$.MODULE$ : function1;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.decider$lzy1;
                                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return function1;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals$Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public void preStart() {
                this.partitionsInProgress = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[0]));
                this.buffer = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
            }

            public void onPull() {
                this.pushNextIfPossible.apply$mcV$sp();
            }

            public void onPush() {
                try {
                    In element = this.grab(this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$in);
                    Partition partition = this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$partitioner.apply(element);
                    $anon$1$Contextual<T> wrappedInput = new $anon$1$Contextual<T>(this, this.org$apache$pekko$stream$MapAsyncPartitioned$$anon$1$$contextPropagation.currentContext(), new Holder<In, Nothing$>(element, MapAsyncPartitioned$.org$apache$pekko$stream$MapAsyncPartitioned$$$NotYetThere, this.futureCB));
                    Partition Partition2 = Predef$.MODULE$.ArrowAssoc(partition);
                    this.buffer.enqueue(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Partition2, wrappedInput));
                    if (this.canStartNextElement(partition)) {
                        this.processElement(partition, wrappedInput);
                    } else {
                        wrappedInput.suspend();
                    }
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = option.get();
                        R r = this.decider().apply(ex);
                        Supervision$Stop$ supervision$Stop$ = Supervision$Stop$.MODULE$;
                        if (!(r != null ? !r.equals(supervision$Stop$) : supervision$Stop$ != null)) {
                            this.failStage(ex);
                        }
                    }
                    throw throwable;
                }
                this.pullIfNeeded();
            }

            public void onUpstreamFinish() {
                if (this.idle()) {
                    this.completeStage();
                    return;
                }
            }

            private void processElement(Object partition, $anon$1$Contextual wrappedInput) {
                Future<Out> future = this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$f.apply(((Holder)wrappedInput.element()).in(), partition);
                this.partitionsInProgress.$plus$eq(partition);
                Option<Try<Out>> option = future.value();
                if (None$.MODULE$.equals(option)) {
                    future.onComplete((Function1)wrappedInput.element(), ExecutionContexts$.MODULE$.parasitic());
                    return;
                }
                if (option instanceof Some) {
                    Try v = (Try)((Some)option).value();
                    ((Holder)wrappedInput.element()).setOut(v);
                    Try try_ = v;
                    if (try_ instanceof Failure) {
                        Throwable ex = ((Failure)try_).exception();
                        Supervision.Directive directive = ((Holder)wrappedInput.element()).supervisionDirectiveFor(this.decider(), ex);
                        Supervision$Stop$ supervision$Stop$ = Supervision$Stop$.MODULE$;
                        if (!(directive != null ? !directive.equals(supervision$Stop$) : supervision$Stop$ != null)) {
                            this.failStage(ex);
                            return;
                        }
                    }
                    this.pushNextIfPossible.apply$mcV$sp();
                    return;
                }
                throw new MatchError(option);
            }

            private void pushNextIfPossibleOrdered() {
                if (this.partitionsInProgress.isEmpty()) {
                    this.drainQueue();
                    this.pullIfNeeded();
                    return;
                }
                while (this.buffer.nonEmpty() && ((Holder)(($anon$1$Contextual)((Tuple2)this.buffer.front())._2()).element()).out() != MapAsyncPartitioned$.org$apache$pekko$stream$MapAsyncPartitioned$$$NotYetThere && this.isAvailable(this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$out)) {
                    Tuple2 tuple2 = (Tuple2)this.buffer.dequeue();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    T1 partition = tuple2._1();
                    $anon$1$Contextual wrappedInput = ($anon$1$Contextual)tuple2._2();
                    Tuple2<T1, $anon$1$Contextual> tuple22 = Tuple2$.MODULE$.apply(partition, wrappedInput);
                    T1 partition2 = tuple22._1();
                    $anon$1$Contextual wrappedInput2 = tuple22._2();
                    this.partitionsInProgress.$minus$eq(partition2);
                    Try<Out> try_ = ((Holder)wrappedInput2.element()).out();
                    if (try_ instanceof Success) {
                        T elem = ((Success)try_).value();
                        if (elem != null) {
                            this.push(this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$out, elem);
                            this.pullIfNeeded();
                            continue;
                        }
                        this.pullIfNeeded();
                        continue;
                    }
                    if (try_ instanceof Failure) {
                        Option<Throwable> option;
                        Throwable throwable = ((Failure)try_).exception();
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = option.get();
                            Supervision.Directive directive = ((Holder)wrappedInput2.element()).supervisionDirectiveFor(this.decider(), ex);
                            if (!Supervision$Stop$.MODULE$.equals(directive)) continue;
                            this.failStage(ex);
                            continue;
                        }
                        Throwable ex = throwable;
                        throw ex;
                    }
                    throw new MatchError(try_);
                }
                this.drainQueue();
            }

            private void pushNextIfPossibleUnordered() {
                if (this.partitionsInProgress.isEmpty()) {
                    this.drainQueue();
                    this.pullIfNeeded();
                    return;
                }
                this.buffer = (Queue)this.buffer.filter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) throw new MatchError(tuple2);
                    T1 partition = tuple2._1();
                    $anon$1$Contextual wrappedInput = ($anon$1$Contextual)tuple2._2();
                    if (((Holder)wrappedInput.element()).out() == MapAsyncPartitioned$.org$apache$pekko$stream$MapAsyncPartitioned$$$NotYetThere || !this.isAvailable(this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$out)) {
                        return true;
                    }
                    this.partitionsInProgress.$minus$eq(partition);
                    Try<Out> try_ = ((Holder)wrappedInput.element()).out();
                    if (try_ instanceof Success) {
                        T elem = ((Success)try_).value();
                        if (elem == null) return false;
                        this.push(this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$out, elem);
                        return false;
                    } else {
                        Option<Throwable> option;
                        if (!(try_ instanceof Failure)) throw new MatchError(try_);
                        Throwable throwable = ((Failure)try_).exception();
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = option.get();
                            Supervision.Directive directive = ((Holder)wrappedInput.element()).supervisionDirectiveFor(this.decider(), ex);
                            if (!Supervision$Stop$.MODULE$.equals(directive)) return false;
                            this.failStage(ex);
                            return false;
                        } else {
                            Throwable ex = throwable;
                            throw ex;
                        }
                    }
                });
                this.pullIfNeeded();
                this.drainQueue();
            }

            private void drainQueue() {
                if (this.buffer.nonEmpty()) {
                    this.buffer.foreach(x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            T1 partition = tuple2._1();
                            $anon$1$Contextual wrappedInput = ($anon$1$Contextual)tuple2._2();
                            if (this.canStartNextElement(partition)) {
                                wrappedInput.resume();
                                this.processElement(partition, wrappedInput);
                                return;
                            }
                            return;
                        }
                        throw new MatchError(tuple2);
                    });
                    return;
                }
            }

            private void pullIfNeeded() {
                if (this.isClosed(this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$in) && this.idle()) {
                    this.completeStage();
                    return;
                }
                if (this.buffer.size() < this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$parallelism && !this.hasBeenPulled(this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$in)) {
                    this.tryPull(this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$in);
                    return;
                }
            }

            private boolean idle() {
                return this.buffer.isEmpty();
            }

            private boolean canStartNextElement(Object partition) {
                return !this.partitionsInProgress.contains(partition) && this.partitionsInProgress.size() < this.$outer.org$apache$pekko$stream$MapAsyncPartitioned$$parallelism;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$4(org.apache.pekko.stream.MapAsyncPartitioned$Holder ), $init$$$anonfun$5(), $init$$$anonfun$6(), pushNextIfPossibleUnordered$$anonfun$1(scala.Tuple2 ), drainQueue$$anonfun$1(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    private static final Object $init$$$anonfun$1() {
        return "parallelism must be at least 1";
    }

    private static final Object $init$$$anonfun$2() {
        return "partitioner function should not be null";
    }

    private static final Object $init$$$anonfun$3() {
        return "f function should not be null.";
    }

    public static final class Holder<In, Out>
    implements Function1<Try<Out>, BoxedUnit> {
        private final Object in;
        private Try out;
        private final AsyncCallback cb;
        private Supervision.Directive cachedSupervisionDirective;

        public Holder(In in, Try<Out> out, AsyncCallback<Holder<In, Out>> cb) {
            this.in = in;
            this.out = out;
            this.cb = cb;
            OptionVal$.MODULE$.None();
            this.cachedSupervisionDirective = null;
        }

        public In in() {
            return (In)this.in;
        }

        public Try<Out> out() {
            return this.out;
        }

        public void out_$eq(Try<Out> x$1) {
            this.out = x$1;
        }

        public AsyncCallback<Holder<In, Out>> cb() {
            return this.cb;
        }

        public Supervision.Directive supervisionDirectiveFor(Function1<Throwable, Supervision.Directive> decider, Throwable ex) {
            Supervision.Directive directive = this.cachedSupervisionDirective;
            Supervision.Directive directive2 = (Supervision.Directive)OptionVal$Some$.MODULE$.unapply(directive);
            if (!OptionVal$.MODULE$.isEmpty$extension(directive2)) {
                Supervision.Directive directive3;
                Supervision.Directive d = directive3 = (Supervision.Directive)OptionVal$.MODULE$.get$extension(directive2);
                return d;
            }
            Supervision.Directive d = decider.apply(ex);
            this.cachedSupervisionDirective = (Supervision.Directive)OptionVal$Some$.MODULE$.apply(d);
            return d;
        }

        public void setOut(Try<Out> t) {
            this.out_$eq(t);
        }

        @Override
        public void apply(Try<Out> t) {
            this.setOut(t);
            this.cb().invoke(this);
        }

        @Override
        public String toString() {
            return new StringBuilder(10).append("Holder(").append(this.in()).append(", ").append(this.out()).append(")").toString();
        }
    }
}

