/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.stream.IOSettings$;

public final class IOSettings {
    private final int tcpWriteBufferSize;
    private final int coalesceWrites;

    public static IOSettings apply(ActorSystem actorSystem) {
        return IOSettings$.MODULE$.apply(actorSystem);
    }

    public static IOSettings apply(Config config) {
        return IOSettings$.MODULE$.apply(config);
    }

    public static IOSettings apply(int n) {
        return IOSettings$.MODULE$.apply(n);
    }

    public static IOSettings create(ActorSystem actorSystem) {
        return IOSettings$.MODULE$.create(actorSystem);
    }

    public static IOSettings create(Config config) {
        return IOSettings$.MODULE$.create(config);
    }

    public static IOSettings create(int n) {
        return IOSettings$.MODULE$.create(n);
    }

    public IOSettings(int tcpWriteBufferSize, int coalesceWrites) {
        this.tcpWriteBufferSize = tcpWriteBufferSize;
        this.coalesceWrites = coalesceWrites;
    }

    public int tcpWriteBufferSize() {
        return this.tcpWriteBufferSize;
    }

    public int coalesceWrites() {
        return this.coalesceWrites;
    }

    public IOSettings(int tcpWriteBufferSize) {
        this(tcpWriteBufferSize, 10);
    }

    public IOSettings withTcpWriteBufferSize(int value) {
        return this.copy(value, this.copy$default$2());
    }

    public IOSettings withCoalesceWrites(int value) {
        return this.copy(this.copy$default$1(), value);
    }

    private IOSettings copy(int tcpWriteBufferSize, int coalesceWrites) {
        return new IOSettings(tcpWriteBufferSize, coalesceWrites);
    }

    private int copy$default$1() {
        return this.tcpWriteBufferSize();
    }

    private int copy$default$2() {
        return this.coalesceWrites();
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof IOSettings) {
            IOSettings s2 = (IOSettings)object;
            return s2.tcpWriteBufferSize() == this.tcpWriteBufferSize() && s2.coalesceWrites() == this.coalesceWrites();
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.tcpWriteBufferSize() + this.coalesceWrites();
    }

    public String toString() {
        return new StringBuilder(13).append("IoSettings(").append(this.tcpWriteBufferSize()).append(",").append(this.coalesceWrites()).append(")").toString();
    }
}

