/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.ActorAttributes$;
import org.apache.pekko.stream.ActorAttributes$DebugLogging$;
import org.apache.pekko.stream.ActorAttributes$Dispatcher$;
import org.apache.pekko.stream.ActorAttributes$FuzzingMode$;
import org.apache.pekko.stream.ActorAttributes$MaxFixedBufferSize$;
import org.apache.pekko.stream.ActorAttributes$OutputBurstLimit$;
import org.apache.pekko.stream.ActorAttributes$StreamSubscriptionTimeout$;
import org.apache.pekko.stream.ActorAttributes$SupervisionStrategy$;
import org.apache.pekko.stream.ActorAttributes$SyncProcessingLimit$;
import org.apache.pekko.stream.ActorMaterializerSettings$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Attributes$CancellationStrategy$;
import org.apache.pekko.stream.Attributes$InputBuffer$;
import org.apache.pekko.stream.Attributes$NestedMaterializationCancellationPolicy$;
import org.apache.pekko.stream.IOSettings;
import org.apache.pekko.stream.IOSettings$;
import org.apache.pekko.stream.StreamRefSettings;
import org.apache.pekko.stream.StreamRefSettings$;
import org.apache.pekko.stream.StreamSubscriptionTimeoutSettings;
import org.apache.pekko.stream.Supervision;
import org.apache.pekko.stream.Supervision$;
import scala.Function1;
import scala.Predef$;
import scala.package$;

public final class ActorMaterializerSettings {
    private final int initialInputBufferSize;
    private final int maxInputBufferSize;
    private final String dispatcher;
    private final Function1 supervisionDecider;
    private final StreamSubscriptionTimeoutSettings subscriptionTimeoutSettings;
    private final boolean debugLogging;
    private final int outputBurstLimit;
    private final boolean fuzzingMode;
    private final boolean autoFusing;
    private final int maxFixedBufferSize;
    private final int syncProcessingLimit;
    private final IOSettings ioSettings;
    private final StreamRefSettings streamRefSettings;
    private final String blockingIoDispatcher;

    public static ActorMaterializerSettings apply(ActorSystem actorSystem) {
        return ActorMaterializerSettings$.MODULE$.apply(actorSystem);
    }

    public static ActorMaterializerSettings apply(Config config) {
        return ActorMaterializerSettings$.MODULE$.apply(config);
    }

    public static ActorMaterializerSettings apply(int n, int n2, String string2, Function1<Throwable, Supervision.Directive> function1, StreamSubscriptionTimeoutSettings streamSubscriptionTimeoutSettings, boolean bl, int n3, boolean bl2, boolean bl3, int n4) {
        return ActorMaterializerSettings$.MODULE$.apply(n, n2, string2, function1, streamSubscriptionTimeoutSettings, bl, n3, bl2, bl3, n4);
    }

    public static ActorMaterializerSettings create(ActorSystem actorSystem) {
        return ActorMaterializerSettings$.MODULE$.create(actorSystem);
    }

    public static ActorMaterializerSettings create(Config config) {
        return ActorMaterializerSettings$.MODULE$.create(config);
    }

    public static ActorMaterializerSettings create(int n, int n2, String string2, Function1<Throwable, Supervision.Directive> function1, StreamSubscriptionTimeoutSettings streamSubscriptionTimeoutSettings, boolean bl, int n3, boolean bl2, boolean bl3, int n4) {
        return ActorMaterializerSettings$.MODULE$.create(n, n2, string2, function1, streamSubscriptionTimeoutSettings, bl, n3, bl2, bl3, n4);
    }

    @InternalApi
    public ActorMaterializerSettings(int initialInputBufferSize, int maxInputBufferSize, String dispatcher, Function1<Throwable, Supervision.Directive> supervisionDecider, StreamSubscriptionTimeoutSettings subscriptionTimeoutSettings, boolean debugLogging, int outputBurstLimit, boolean fuzzingMode, boolean autoFusing, int maxFixedBufferSize, int syncProcessingLimit, IOSettings ioSettings, StreamRefSettings streamRefSettings, String blockingIoDispatcher) {
        this.initialInputBufferSize = initialInputBufferSize;
        this.maxInputBufferSize = maxInputBufferSize;
        this.dispatcher = dispatcher;
        this.supervisionDecider = supervisionDecider;
        this.subscriptionTimeoutSettings = subscriptionTimeoutSettings;
        this.debugLogging = debugLogging;
        this.outputBurstLimit = outputBurstLimit;
        this.fuzzingMode = fuzzingMode;
        this.autoFusing = autoFusing;
        this.maxFixedBufferSize = maxFixedBufferSize;
        this.syncProcessingLimit = syncProcessingLimit;
        this.ioSettings = ioSettings;
        this.streamRefSettings = streamRefSettings;
        this.blockingIoDispatcher = blockingIoDispatcher;
        Predef$.MODULE$.require(initialInputBufferSize > 0, ActorMaterializerSettings::$init$$$anonfun$1);
        Predef$.MODULE$.require(syncProcessingLimit > 0, ActorMaterializerSettings::$init$$$anonfun$2);
        this.requirePowerOfTwo(Predef$.MODULE$.int2Integer(maxInputBufferSize), "maxInputBufferSize");
        Predef$.MODULE$.require(initialInputBufferSize <= maxInputBufferSize, () -> ActorMaterializerSettings.$init$$$anonfun$3(initialInputBufferSize, maxInputBufferSize));
    }

    public int initialInputBufferSize() {
        return this.initialInputBufferSize;
    }

    public int maxInputBufferSize() {
        return this.maxInputBufferSize;
    }

    public String dispatcher() {
        return this.dispatcher;
    }

    public Function1<Throwable, Supervision.Directive> supervisionDecider() {
        return this.supervisionDecider;
    }

    public StreamSubscriptionTimeoutSettings subscriptionTimeoutSettings() {
        return this.subscriptionTimeoutSettings;
    }

    public boolean debugLogging() {
        return this.debugLogging;
    }

    public int outputBurstLimit() {
        return this.outputBurstLimit;
    }

    public boolean fuzzingMode() {
        return this.fuzzingMode;
    }

    public boolean autoFusing() {
        return this.autoFusing;
    }

    public int maxFixedBufferSize() {
        return this.maxFixedBufferSize;
    }

    public int syncProcessingLimit() {
        return this.syncProcessingLimit;
    }

    public IOSettings ioSettings() {
        return this.ioSettings;
    }

    public StreamRefSettings streamRefSettings() {
        return this.streamRefSettings;
    }

    public String blockingIoDispatcher() {
        return this.blockingIoDispatcher;
    }

    public ActorMaterializerSettings(int initialInputBufferSize, int maxInputBufferSize, String dispatcher, Function1<Throwable, Supervision.Directive> supervisionDecider, StreamSubscriptionTimeoutSettings subscriptionTimeoutSettings, boolean debugLogging, int outputBurstLimit, boolean fuzzingMode, boolean autoFusing, int maxFixedBufferSize, int syncProcessingLimit, IOSettings ioSettings) {
        this(initialInputBufferSize, maxInputBufferSize, dispatcher, supervisionDecider, subscriptionTimeoutSettings, debugLogging, outputBurstLimit, fuzzingMode, autoFusing, maxFixedBufferSize, syncProcessingLimit, ioSettings, StreamRefSettings$.MODULE$.apply(ConfigFactory.defaultReference().getConfig("pekko.stream.materializer.stream-ref")), ConfigFactory.defaultReference().getString(ActorAttributes$.MODULE$.IODispatcher().dispatcher()));
    }

    public ActorMaterializerSettings(int initialInputBufferSize, int maxInputBufferSize, String dispatcher, Function1<Throwable, Supervision.Directive> supervisionDecider, StreamSubscriptionTimeoutSettings subscriptionTimeoutSettings, boolean debugLogging, int outputBurstLimit, boolean fuzzingMode, boolean autoFusing, int maxFixedBufferSize, int syncProcessingLimit) {
        this(initialInputBufferSize, maxInputBufferSize, dispatcher, supervisionDecider, subscriptionTimeoutSettings, debugLogging, outputBurstLimit, fuzzingMode, autoFusing, maxFixedBufferSize, syncProcessingLimit, IOSettings$.MODULE$.apply(16384), StreamRefSettings$.MODULE$.apply(ConfigFactory.defaultReference().getConfig("pekko.stream.materializer.stream-ref")), ConfigFactory.defaultReference().getString(ActorAttributes$.MODULE$.IODispatcher().dispatcher()));
    }

    public ActorMaterializerSettings(int initialInputBufferSize, int maxInputBufferSize, String dispatcher, Function1<Throwable, Supervision.Directive> supervisionDecider, StreamSubscriptionTimeoutSettings subscriptionTimeoutSettings, boolean debugLogging, int outputBurstLimit, boolean fuzzingMode, boolean autoFusing, int maxFixedBufferSize) {
        this(initialInputBufferSize, maxInputBufferSize, dispatcher, supervisionDecider, subscriptionTimeoutSettings, debugLogging, outputBurstLimit, fuzzingMode, autoFusing, maxFixedBufferSize, 1000, IOSettings$.MODULE$.apply(16384), StreamRefSettings$.MODULE$.apply(ConfigFactory.defaultReference().getConfig("pekko.stream.materializer.stream-ref")), ConfigFactory.defaultReference().getString(ActorAttributes$.MODULE$.IODispatcher().dispatcher()));
    }

    private ActorMaterializerSettings copy(int initialInputBufferSize, int maxInputBufferSize, String dispatcher, Function1<Throwable, Supervision.Directive> supervisionDecider, StreamSubscriptionTimeoutSettings subscriptionTimeoutSettings, boolean debugLogging, int outputBurstLimit, boolean fuzzingMode, boolean autoFusing, int maxFixedBufferSize, int syncProcessingLimit, IOSettings ioSettings, StreamRefSettings streamRefSettings, String blockingIoDispatcher) {
        return new ActorMaterializerSettings(initialInputBufferSize, maxInputBufferSize, dispatcher, supervisionDecider, subscriptionTimeoutSettings, debugLogging, outputBurstLimit, fuzzingMode, autoFusing, maxFixedBufferSize, syncProcessingLimit, ioSettings, streamRefSettings, blockingIoDispatcher);
    }

    private int copy$default$1() {
        return this.initialInputBufferSize();
    }

    private int copy$default$2() {
        return this.maxInputBufferSize();
    }

    private String copy$default$3() {
        return this.dispatcher();
    }

    private Function1<Throwable, Supervision.Directive> copy$default$4() {
        return this.supervisionDecider();
    }

    private StreamSubscriptionTimeoutSettings copy$default$5() {
        return this.subscriptionTimeoutSettings();
    }

    private boolean copy$default$6() {
        return this.debugLogging();
    }

    private int copy$default$7() {
        return this.outputBurstLimit();
    }

    private boolean copy$default$8() {
        return this.fuzzingMode();
    }

    private boolean copy$default$9() {
        return this.autoFusing();
    }

    private int copy$default$10() {
        return this.maxFixedBufferSize();
    }

    private int copy$default$11() {
        return this.syncProcessingLimit();
    }

    private IOSettings copy$default$12() {
        return this.ioSettings();
    }

    private StreamRefSettings copy$default$13() {
        return this.streamRefSettings();
    }

    private String copy$default$14() {
        return this.blockingIoDispatcher();
    }

    public ActorMaterializerSettings withInputBuffer(int initialSize, int maxSize) {
        if (initialSize == this.initialInputBufferSize() && maxSize == this.maxInputBufferSize()) {
            return this;
        }
        return this.copy(initialSize, maxSize, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withDispatcher(String dispatcher) {
        String string2 = this.dispatcher();
        String string3 = dispatcher;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), dispatcher, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withSupervisionStrategy(Function1<Throwable, Supervision.Directive> decider) {
        if (decider == this.supervisionDecider()) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), decider, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withSupervisionStrategy(Function<Throwable, Supervision.Directive> decider) {
        Function1<Throwable, Supervision.Directive> & Serializable intersect;
        Function<Throwable, Supervision.Directive> function = decider;
        Function<Throwable, Supervision.Directive> function2 = Supervision$.MODULE$.resumingDecider();
        Function<Throwable, Supervision.Directive> function3 = function;
        if (!(function2 != null ? !function2.equals(function3) : function3 != null)) {
            intersect = (Function1<Throwable, Supervision.Directive> & Serializable)Supervision$.MODULE$.resumingDecider();
        } else {
            Function<Throwable, Supervision.Directive> function4 = Supervision$.MODULE$.restartingDecider();
            Function<Throwable, Supervision.Directive> function5 = function;
            if (!(function4 != null ? !function4.equals(function5) : function5 != null)) {
                intersect = (Function1)((Object)Supervision$.MODULE$.restartingDecider());
            } else {
                Function<Throwable, Supervision.Directive> function6 = Supervision$.MODULE$.stoppingDecider();
                Function<Throwable, Supervision.Directive> function7 = function;
                if (!(function6 != null ? !function6.equals(function7) : function7 != null)) {
                    intersect = (Function1)((Object)Supervision$.MODULE$.stoppingDecider());
                } else {
                    Function<Throwable, Supervision.Directive> other = function;
                    intersect = (Function1<Throwable, Supervision.Directive> & Serializable)param2 -> (Supervision.Directive)other.apply((Throwable)param2);
                }
            }
        }
        Function1<Throwable, Supervision.Directive> & Serializable intersect2 = intersect;
        int n = this.copy$default$1();
        int n2 = this.copy$default$2();
        String string2 = this.copy$default$3();
        StreamSubscriptionTimeoutSettings streamSubscriptionTimeoutSettings = this.copy$default$5();
        boolean bl = this.copy$default$6();
        int n3 = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        boolean bl3 = this.copy$default$9();
        int n4 = this.copy$default$10();
        int n5 = this.copy$default$11();
        IOSettings iOSettings = this.copy$default$12();
        StreamRefSettings streamRefSettings = this.copy$default$13();
        String string3 = this.copy$default$14();
        return this.copy(n, n2, string2, intersect2, streamSubscriptionTimeoutSettings, bl, n3, bl2, bl3, n4, n5, iOSettings, streamRefSettings, string3);
    }

    public ActorMaterializerSettings withFuzzing(boolean enable) {
        if (enable == this.fuzzingMode()) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), enable, this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withOutputBurstLimit(int limit) {
        if (limit == this.outputBurstLimit()) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), limit, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withSyncProcessingLimit(int limit) {
        if (limit == this.syncProcessingLimit()) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), limit, this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withDebugLogging(boolean enable) {
        if (enable == this.debugLogging()) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), enable, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withMaxFixedBufferSize(int size) {
        if (size == this.maxFixedBufferSize()) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), size, this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withSubscriptionTimeoutSettings(StreamSubscriptionTimeoutSettings settings) {
        StreamSubscriptionTimeoutSettings streamSubscriptionTimeoutSettings = settings;
        StreamSubscriptionTimeoutSettings streamSubscriptionTimeoutSettings2 = this.subscriptionTimeoutSettings();
        if (!(streamSubscriptionTimeoutSettings != null ? !((Object)streamSubscriptionTimeoutSettings).equals(streamSubscriptionTimeoutSettings2) : streamSubscriptionTimeoutSettings2 != null)) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), settings, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withIOSettings(IOSettings ioSettings) {
        IOSettings iOSettings = ioSettings;
        IOSettings iOSettings2 = this.ioSettings();
        if (!(iOSettings != null ? !((Object)iOSettings).equals(iOSettings2) : iOSettings2 != null)) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), ioSettings, this.copy$default$13(), this.copy$default$14());
    }

    public ActorMaterializerSettings withStreamRefSettings(StreamRefSettings streamRefSettings) {
        StreamRefSettings streamRefSettings2 = streamRefSettings;
        StreamRefSettings streamRefSettings3 = this.streamRefSettings();
        if (!(streamRefSettings2 != null ? !streamRefSettings2.equals(streamRefSettings3) : streamRefSettings3 != null)) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), streamRefSettings, this.copy$default$14());
    }

    public ActorMaterializerSettings withBlockingIoDispatcher(String newBlockingIoDispatcher) {
        String string2 = newBlockingIoDispatcher;
        String string3 = this.blockingIoDispatcher();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), newBlockingIoDispatcher);
    }

    private void requirePowerOfTwo(Integer n, String name) {
        Predef$.MODULE$.require(Predef$.MODULE$.Integer2int(n) > 0, () -> ActorMaterializerSettings.requirePowerOfTwo$$anonfun$1(name));
        Predef$.MODULE$.require((Predef$.MODULE$.Integer2int(n) & Predef$.MODULE$.Integer2int(n) - 1) == 0, () -> ActorMaterializerSettings.requirePowerOfTwo$$anonfun$2(name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof ActorMaterializerSettings)) return false;
        ActorMaterializerSettings s2 = (ActorMaterializerSettings)object;
        if (s2.initialInputBufferSize() != this.initialInputBufferSize()) return false;
        if (s2.maxInputBufferSize() != this.maxInputBufferSize()) return false;
        String string2 = s2.dispatcher();
        String string3 = this.dispatcher();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        Function1<Throwable, Supervision.Directive> function1 = s2.supervisionDecider();
        Function1<Throwable, Supervision.Directive> function12 = this.supervisionDecider();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        StreamSubscriptionTimeoutSettings streamSubscriptionTimeoutSettings = s2.subscriptionTimeoutSettings();
        StreamSubscriptionTimeoutSettings streamSubscriptionTimeoutSettings2 = this.subscriptionTimeoutSettings();
        if (streamSubscriptionTimeoutSettings == null) {
            if (streamSubscriptionTimeoutSettings2 != null) {
                return false;
            }
        } else if (!((Object)streamSubscriptionTimeoutSettings).equals(streamSubscriptionTimeoutSettings2)) return false;
        if (s2.debugLogging() != this.debugLogging()) return false;
        if (s2.outputBurstLimit() != this.outputBurstLimit()) return false;
        if (s2.syncProcessingLimit() != this.syncProcessingLimit()) return false;
        if (s2.fuzzingMode() != this.fuzzingMode()) return false;
        if (s2.autoFusing() != this.autoFusing()) return false;
        IOSettings iOSettings = s2.ioSettings();
        IOSettings iOSettings2 = this.ioSettings();
        if (iOSettings == null) {
            if (iOSettings2 != null) {
                return false;
            }
        } else if (!((Object)iOSettings).equals(iOSettings2)) return false;
        String string4 = s2.blockingIoDispatcher();
        String string5 = this.blockingIoDispatcher();
        if (string4 == null) {
            if (string5 == null) return true;
            return false;
        } else {
            if (!string4.equals(string5)) return false;
            return true;
        }
    }

    @InternalApi
    public Attributes toAttributes() {
        Attributes.InputBuffer inputBuffer = Attributes$InputBuffer$.MODULE$.apply(this.initialInputBufferSize(), this.maxInputBufferSize());
        Attributes.CancellationStrategy cancellationStrategy = Attributes$CancellationStrategy$.MODULE$.Default();
        Attributes.NestedMaterializationCancellationPolicy nestedMaterializationCancellationPolicy = Attributes$NestedMaterializationCancellationPolicy$.MODULE$.Default();
        ActorAttributes.Dispatcher dispatcher = ActorAttributes$Dispatcher$.MODULE$.apply(this.dispatcher());
        ActorAttributes.SupervisionStrategy supervisionStrategy = ActorAttributes$SupervisionStrategy$.MODULE$.apply(this.supervisionDecider());
        ActorAttributes.DebugLogging debugLogging = ActorAttributes$DebugLogging$.MODULE$.apply(this.debugLogging());
        ActorAttributes.StreamSubscriptionTimeout streamSubscriptionTimeout = ActorAttributes$StreamSubscriptionTimeout$.MODULE$.apply(this.subscriptionTimeoutSettings().timeout(), this.subscriptionTimeoutSettings().mode());
        ActorAttributes.OutputBurstLimit outputBurstLimit = ActorAttributes$OutputBurstLimit$.MODULE$.apply(this.outputBurstLimit());
        ActorAttributes.FuzzingMode fuzzingMode = ActorAttributes$FuzzingMode$.MODULE$.apply(this.fuzzingMode());
        ActorAttributes.MaxFixedBufferSize maxFixedBufferSize = ActorAttributes$MaxFixedBufferSize$.MODULE$.apply(this.maxFixedBufferSize());
        ActorAttributes.SyncProcessingLimit syncProcessingLimit = ActorAttributes$SyncProcessingLimit$.MODULE$.apply(this.syncProcessingLimit());
        return Attributes$.MODULE$.apply(package$.MODULE$.Nil().$colon$colon(syncProcessingLimit).$colon$colon(maxFixedBufferSize).$colon$colon(fuzzingMode).$colon$colon(outputBurstLimit).$colon$colon(streamSubscriptionTimeout).$colon$colon(debugLogging).$colon$colon(supervisionStrategy).$colon$colon(dispatcher).$colon$colon(nestedMaterializationCancellationPolicy).$colon$colon(cancellationStrategy).$colon$colon(inputBuffer));
    }

    public String toString() {
        return new StringBuilder(28).append("ActorMaterializerSettings(").append(this.initialInputBufferSize()).append(",").append(this.maxInputBufferSize()).append(",").append(new StringBuilder(5).append(this.dispatcher()).append(",").append(this.supervisionDecider()).append(",").append(this.subscriptionTimeoutSettings()).append(",").append(this.debugLogging()).append(",").append(this.outputBurstLimit()).append(",").toString()).append(new StringBuilder(4).append(this.syncProcessingLimit()).append(",").append(this.fuzzingMode()).append(",").append(this.autoFusing()).append(",").append(this.ioSettings()).append(")").toString()).toString();
    }

    private static final Object $init$$$anonfun$1() {
        return "initialInputBufferSize must be > 0";
    }

    private static final Object $init$$$anonfun$2() {
        return "syncProcessingLimit must be > 0";
    }

    private static final Object $init$$$anonfun$3(int initialInputBufferSize$2, int maxInputBufferSize$2) {
        return new StringBuilder(56).append("initialInputBufferSize(").append(initialInputBufferSize$2).append(") must be <= maxInputBufferSize(").append(maxInputBufferSize$2).append(")").toString();
    }

    private static final Object requirePowerOfTwo$$anonfun$1(String name$1) {
        return new StringBuilder(12).append(name$1).append(" must be > 0").toString();
    }

    private static final Object requirePowerOfTwo$$anonfun$2(String name$2) {
        return new StringBuilder(23).append(name$2).append(" must be a power of two").toString();
    }
}

