/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.JavaSerializer;
import org.apache.pekko.serialization.NullSerializer$;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.Serialization$Information$;
import org.apache.pekko.serialization.SerializationSetup;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerDetails;
import org.apache.pekko.serialization.SerializerDetails$;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.DynamicVariable;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<scala.collection.immutable.Map<String, Option<Class<?>>>> manifestCache;
    private final scala.collection.immutable.Map<String, Serializer> serializers;
    private final Seq bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final scala.collection.immutable.Map serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static DynamicVariable<Information> currentTransportInformation() {
        return Serialization$.MODULE$.currentTransportInformation();
    }

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public Serialization(ExtendedActorSystem system) {
        Seq<SerializerDetails> seq;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Object>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            seq = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            SerializationSetup setting = (SerializationSetup)((Some)option).value();
            seq = setting.createSerializers().apply(system);
        } else {
            throw new MatchError(option);
        }
        Seq serializerDetails = (Seq)seq.collect(new Serializable(this){
            private final /* synthetic */ Serialization $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(SerializerDetails x) {
                SerializerDetails det;
                SerializerDetails serializerDetails = x;
                if (serializerDetails != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer((det = serializerDetails).serializer())) {
                    return true;
                }
                SerializerDetails det2 = serializerDetails;
                return true;
            }

            public final Object applyOrElse(SerializerDetails x, Function1 function1) {
                SerializerDetails det;
                SerializerDetails serializerDetails = x;
                if (serializerDetails != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer((det = serializerDetails).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
                    return SerializerDetails$.MODULE$.apply(det.alias(), new DisabledJavaSerializer(this.$outer.system()), det.useFor());
                }
                SerializerDetails det2 = serializerDetails;
                return det2;
            }
        });
        scala.collection.immutable.Map fromConfig = (scala.collection.immutable.Map)this.settings().Serializers().withFilter((Function1<Tuple2<String, String>, Object>)(Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                if (string2 != null) {
                    String k = string2;
                    if (string3 != null) {
                        String v = string3;
                        return true;
                    }
                }
            }
            return false;
        }).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                if (string2 != null) {
                    String k = string2;
                    if (string3 != null) {
                        String v = string3;
                        String string4 = Predef$.MODULE$.ArrowAssoc(k);
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, this.serializerOf(k, v).get());
                    }
                }
            }
            throw new MatchError(tuple2);
        });
        scala.collection.immutable.Map result = (scala.collection.immutable.Map)fromConfig.$plus$plus((IterableOnce)serializerDetails.map((Function1<SerializerDetails, Tuple2> & Serializable)d -> {
            String string2 = Predef$.MODULE$.ArrowAssoc(d.alias());
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, d.serializer());
        }));
        this.ensureOnlyAllowedSerializers(result.iterator().map((Function1<Tuple2, Serializer> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Serializer ser = (Serializer)tuple2._2();
                return ser;
            }
            throw new MatchError(tuple2);
        }));
        this.serializers = result;
        scala.collection.immutable.Map fromConfig2 = (scala.collection.immutable.Map)((MapOps.WithFilter)this.settings().SerializationBindings().withFilter((Function1<Tuple2<String, String>, Object>)(Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                if (string2 != null) {
                    String className = string2;
                    if (string3 != null) {
                        String alias = string3;
                        return true;
                    }
                }
            }
            return false;
        }).withFilter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                if (string2 != null) {
                    String className = string2;
                    if (string3 != null) {
                        String alias;
                        String string4 = alias = string3;
                        String string5 = "none";
                        return (string4 == null ? string5 != null : !string4.equals(string5)) && this.checkGoogleProtobuf(className);
                    }
                }
            }
            throw new MatchError(tuple2);
        })).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                if (string2 != null) {
                    String className = string2;
                    if (string3 != null) {
                        String alias = string3;
                        return Tuple2$.MODULE$.apply(system.dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).get(), this.serializers.apply(alias));
                    }
                }
            }
            throw new MatchError(tuple2);
        });
        Seq fromSettings = (Seq)serializerDetails.flatMap((Function1<SerializerDetails, IterableOnce> & Serializable)detail -> (IterableOnce)detail.useFor().map((Function1<Class, Tuple2> & Serializable)clazz -> {
            Class clazz2 = Predef$.MODULE$.ArrowAssoc(clazz);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz2, detail.serializer());
        }));
        Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus(fromSettings));
        this.ensureOnlyAllowedSerializers(result2.iterator().map((Function1<Tuple2, Serializer> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Serializer ser = (Serializer)tuple2._2();
                return ser;
            }
            throw new MatchError(tuple2);
        }));
        result2.foreach((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Class clazz = (Class)tuple2._1();
                Serializer ser = (Serializer)tuple2._2();
                return this.warnUnexpectedNonPekkoSerializer(clazz, ser);
            }
            throw new MatchError(tuple2);
        });
        this.bindings = result2;
        this.serializerMap = this.bindings().foldLeft(new ConcurrentHashMap(), (Function2<ConcurrentHashMap, Tuple2, ConcurrentHashMap> & Serializable)(x$1, x$2) -> {
            Tuple2<ConcurrentHashMap, Tuple2> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = tuple2._2();
                ConcurrentHashMap map = tuple2._1();
                if (tuple22 != null) {
                    Class c = (Class)tuple22._1();
                    Serializer s2 = (Serializer)tuple22._2();
                    map.put(c, s2);
                    return map;
                }
            }
            throw new MatchError(tuple2);
        });
        Tuple2[] tuple2Array = new Tuple2[1];
        Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(NullSerializer$.MODULE$.identifier()));
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, NullSerializer$.MODULE$);
        scala.collection.immutable.Map zero = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        this.serializerByIdentity = this.serializers.foldLeft(zero, (Function2<scala.collection.immutable.Map, Tuple2, scala.collection.immutable.Map> & Serializable)(x$1, x$2) -> {
            Tuple2<scala.collection.immutable.Map, Tuple2> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = tuple2._2();
                scala.collection.immutable.Map acc = tuple2._1();
                if (tuple22 != null) {
                    Serializer ser = (Serializer)tuple22._2();
                    int id = ser.identifier();
                    Option option = acc.get(BoxesRunTime.boxToInteger(id));
                    if (option instanceof Some) {
                        Serializer existing;
                        Serializer serializer = existing = (Serializer)((Some)option).value();
                        Serializer serializer2 = ser;
                        if (serializer == null ? serializer2 != null : !serializer.equals(serializer2)) {
                            throw new IllegalArgumentException(new StringBuilder(31).append("Serializer identifier [").append(id).append("] of [").append(ser.getClass().getName()).append("] ").append(new StringBuilder(37).append("is not unique. It is also used by [").append(acc.apply(BoxesRunTime.boxToInteger(id)).getClass().getName()).append("].").toString()).toString());
                        }
                    }
                    return (scala.collection.immutable.Map)acc.updated(BoxesRunTime.boxToInteger(id), ser);
                }
            }
            throw new MatchError(tuple2);
        });
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int id = BoxesRunTime.unboxToInt(tuple2._1());
                Serializer ser = (Serializer)tuple2._2();
                if (0 <= id && id < size) {
                    table$1[id] = ser;
                    return;
                }
                return;
            }
            throw new MatchError(tuple2);
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("pekko.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("pekko.actor.warn-on-no-serialization-verification");
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        T t;
        Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq(this.serializationInformation());
            }
            t = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
        }
        return t;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0<Try> & Serializable)() -> Try$.MODULE$.apply(() -> this.serialize$$anonfun$1$$anonfun$1(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply(() -> this.deserialize$$anonfun$1(serializerId, clazz, bytes));
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply(() -> this.deserialize$$anonfun$2(serializerId, manifest, bytes));
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0<Object> & Serializable)() -> {
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest s2 = (SerializerWithStringManifest)serializer;
                return s2.fromBinary(bytes, manifest);
            }
            Serializer s1 = serializer;
            String string2 = manifest;
            String string3 = "";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return s1.fromBinary(bytes, None$.MODULE$);
            }
            scala.collection.immutable.Map<String, Option<Class<?>>> cache = this.manifestCache.get();
            Option option = cache.get(manifest);
            if (option instanceof Some) {
                Option cachedClassManifest = (Option)((Some)option).value();
                return s1.fromBinary(bytes, cachedClassManifest);
            }
            if (None$.MODULE$.equals(option)) {
                Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.apply(Object.class));
                if (try_ instanceof Success) {
                    Class classManifest = (Class)((Success)try_).value();
                    Some<Class<?>> classManifestOption = Some$.MODULE$.apply(classManifest);
                    this.updateCache$1(cache, manifest, classManifestOption);
                    return s1.fromBinary(bytes, classManifestOption);
                }
                if (try_ instanceof Failure) {
                    throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                }
                throw new MatchError(try_);
            }
            throw new MatchError(option);
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(170).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq(this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                ByteBufferSerializer ser = (ByteBufferSerializer)((Object)serializer3);
                object = ser.fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object = this.deserializeByteArray(bytes, serializer2, manifest);
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0<Try> & Serializable)() -> Try$.MODULE$.apply(() -> this.deserialize$$anonfun$3$$anonfun$1(clazz, bytes)));
    }

    public Serializer findSerializerFor(Object o) {
        if (o == null) {
            return NullSerializer$.MODULE$;
        }
        return this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer = this.serializerMap.get(clazz);
        if (serializer == null) {
            Serializer serializer2;
            SeqOps seqOps;
            Seq seq = (Seq)this.bindings().filter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Class c = (Class)tuple2._1();
                    return c.isAssignableFrom(clazz);
                }
                throw new MatchError(tuple2);
            });
            if (seq != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq(seq), 0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            Seq possibilities = seq;
            if (Serialization.unique$1(possibilities)) {
                serializer2 = (Serializer)((Tuple2)possibilities.head())._2();
            } else {
                Seq possibilitiesWithoutJavaSerializer = (Seq)possibilities.filter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Serializer serializer = (Serializer)tuple2._2();
                        if (serializer instanceof JavaSerializer) {
                            return false;
                        }
                        if (serializer instanceof DisabledJavaSerializer) {
                            return false;
                        }
                    }
                    return true;
                });
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((IterableOnceOps)possibilitiesWithoutJavaSerializer.map((Function1<Tuple2, String> & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Serializer s2 = (Serializer)tuple2._2();
                            return s2.getClass().getName();
                        }
                        throw new MatchError(tuple2);
                    })).mkString(", "));
                }
                serializer2 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer2;
            Serializer serializer3 = this.serializerMap.putIfAbsent(clazz, ser);
            if (serializer3 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'pekko.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonPekkoSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                return ser;
            }
            Serializer some = serializer3;
            return some;
        }
        Serializer ser = serializer;
        return ser;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.serializerOf("", serializerFQN);
    }

    /*
     * Unable to fully structure code
     */
    private Try<Serializer> serializerOf(String bindingName, String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var4_3 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        var5_5 = Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class);
        return this.system().dynamicAccess().createInstanceFor(fqn, (Seq)((Object)new $colon$colon<Nothing$>((Nothing$)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(var5_5, this.system()), Nil$.MODULE$)), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith(new Serializable(fqn, bindingName, this){
            public final String org$apache$pekko$serialization$Serialization$$anon$2$$fqn$1;
            public final String org$apache$pekko$serialization$Serialization$$anon$2$$bindingName$1;
            private final /* synthetic */ Serialization $outer;
            {
                this.org$apache$pekko$serialization$Serialization$$anon$2$$fqn$1 = fqn$2;
                this.org$apache$pekko$serialization$Serialization$$anon$2$$bindingName$1 = bindingName$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchMethodException) {
                    return this.$outer.system().dynamicAccess().createInstanceFor(this.org$apache$pekko$serialization$Serialization$$anon$2$$fqn$1, package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith(new Serializable(this){
                        private final /* synthetic */ $anon$2 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            if (throwable instanceof NoSuchMethodException) {
                                NoSuchMethodException e = (NoSuchMethodException)throwable;
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable = x;
                            if (throwable instanceof NoSuchMethodException) {
                                NoSuchMethodException e = (NoSuchMethodException)throwable;
                                String string2 = this.$outer.org$apache$pekko$serialization$Serialization$$anon$2$$bindingName$1;
                                String string3 = "";
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    throw e;
                                }
                                Class<ExtendedActorSystem> clazz = Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class);
                                Class<String> clazz2 = Predef$.MODULE$.ArrowAssoc(String.class);
                                return this.$outer.org$apache$pekko$serialization$Serialization$_$$anon$$$outer().system().dynamicAccess().createInstanceFor(this.$outer.org$apache$pekko$serialization$Serialization$$anon$2$$fqn$1, (Seq)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz, this.$outer.org$apache$pekko$serialization$Serialization$_$$anon$$$outer().system())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz2, this.$outer.org$apache$pekko$serialization$Serialization$$anon$2$$bindingName$1)), Nil$.MODULE$))), ClassTag$.MODULE$.apply(Serializer.class));
                            }
                            return function1.apply(x);
                        }
                    });
                }
                return function1.apply(x);
            }

            public final /* synthetic */ Serialization org$apache$pekko$serialization$Serialization$_$$anon$$$outer() {
                return this.$outer;
            }
        });
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        if (!this.system().settings().AllowJavaSerialization()) {
            Predef$.MODULE$.require(iter.forall((Function1<Serializer, boolean> & Serializable)_$3 -> !this.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer((Serializer)_$3)), Serialization::ensureOnlyAllowedSerializers$$anonfun$2);
            return;
        }
    }

    private boolean warnUnexpectedNonPekkoSerializer(Class<?> clazz, Serializer ser) {
        if (clazz.getName().startsWith("org.apache.pekko.") && !ser.getClass().getName().startsWith("org.apache.pekko.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Apache Pekko. It's not recommended to replace serializers for messages provided by Apache Pekko.", (Object)ser.getClass().getName(), (Object)clazz.getName());
            return true;
        }
        return false;
    }

    private boolean checkGoogleProtobuf(String className) {
        return this.checkClass("com.google.protobuf", className);
    }

    private boolean checkClass(String prefix, String className) {
        return !className.startsWith(prefix) || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return ((IterableOnceOps)in.foldLeft(new ArrayBuffer(in.size()), (Function2<ArrayBuffer, Tuple2, ArrayBuffer> & Serializable)(buf, ca) -> {
            Object object;
            int n = buf.indexWhere((Function1<Tuple2, boolean> & Serializable)_$4 -> ((Class)_$4._1()).isAssignableFrom((Class)ca._1()));
            if (-1 == n) {
                object = buf.append(ca);
            } else {
                int x = n;
                buf.insert(x, ca);
                object = BoxedUnit.UNIT;
            }
            return buf;
        })).to(IterableFactory$.MODULE$.toFactory(Seq$.MODULE$));
    }

    public scala.collection.immutable.Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        if (0 <= id && id < this.quickSerializerByIdentity.length) {
            Serializer serializer = this.quickSerializerByIdentity[id];
            if (serializer == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            Serializer ser = serializer;
            return ser;
        }
        return (Serializer)this.serializerByIdentity().apply(BoxesRunTime.boxToInteger(id));
    }

    public boolean org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("org.apache.pekko.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final byte[] serialize$$anonfun$1$$anonfun$1(Object o$2) {
        return this.findSerializerFor(o$2).toBinary(o$2);
    }

    private static final String $anonfun$9() {
        return "";
    }

    private final Object deserialize$$anonfun$1(int serializerId$1, Option clazz$1, byte[] bytes$1) {
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId$1);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId$1).append("]").append(clazz$1.map((Function1<Class, String> & Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse(Serialization::$anonfun$9)).append(". ").append("The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        return this.withTransportInformation((Function0<Object> & Serializable)() -> serializer2.fromBinary(bytes$1, clazz$1));
    }

    private final Object deserialize$$anonfun$2(int serializerId$2, String manifest$1, byte[] bytes$3) {
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId$2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId$2).append("] (manifest [").append(manifest$1).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        return this.deserializeByteArray(bytes$3, serializer2, manifest$1);
    }

    private final boolean updateCache$1(scala.collection.immutable.Map cache, String key2, Option value) {
        while (!this.manifestCache.compareAndSet(cache, (scala.collection.immutable.Map<String, Option<Class<?>>>)cache.updated(key2, value))) {
            cache = this.manifestCache.get();
        }
        return true;
    }

    private final Object deserialize$$anonfun$3$$anonfun$1(Class clazz$4, byte[] bytes$6) {
        return this.serializerFor(clazz$4).fromBinary(bytes$6, Some$.MODULE$.apply(clazz$4));
    }

    private static final boolean unique$1(Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1<Tuple2, boolean> & Serializable)_$1 -> ((Class)_$1._1()).isAssignableFrom((Class)((Tuple2)possibilities.apply(false))._1())) || possibilities.forall((Function1<Tuple2, boolean> & Serializable)_$2 -> BoxesRunTime.equals(_$2._2(), ((Tuple2)possibilities.apply(false))._2()));
    }

    private static final Object ensureOnlyAllowedSerializers$$anonfun$2() {
        return "Disallowed JavaSerializer binding.";
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public static final class Information
    implements Product,
    Serializable {
        private final Address address;
        private final ActorSystem system;

        public static Information apply(Address address, ActorSystem actorSystem) {
            return Serialization$Information$.MODULE$.apply(address, actorSystem);
        }

        public static Information fromProduct(Product product) {
            return Serialization$Information$.MODULE$.fromProduct(product);
        }

        public static Information unapply(Information information) {
            return Serialization$Information$.MODULE$.unapply(information);
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Information)) return false;
            Information information = (Information)object;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Information;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Information";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            if (1 == n2) {
                return "system";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public Address _1() {
            return this.address();
        }

        public ActorSystem _2() {
            return this.system();
        }
    }

    public static class Settings {
        private final Config config;
        private final scala.collection.immutable.Map Serializers;
        private final scala.collection.immutable.Map SerializationBindings;

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("pekko.actor.serializers"));
            Config bindings = config.getConfig("pekko.actor.serialization-bindings");
            this.SerializationBindings = this.configToMap(bindings);
        }

        public Config config() {
            return this.config;
        }

        public scala.collection.immutable.Map<String, String> Serializers() {
            return this.Serializers;
        }

        public scala.collection.immutable.Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final scala.collection.immutable.Map<String, String> configToMap(Config cfg) {
            return (scala.collection.immutable.Map)package$JavaConverters$.MODULE$.MapHasAsScala((Map)cfg.root().unwrapped()).asScala().toMap($less$colon$less$.MODULE$.refl()).map(Serialization$::org$apache$pekko$serialization$Serialization$Settings$$_$configToMap$$anonfun$1);
        }
    }
}

