/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import java.nio.ByteBuffer;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.Serializer;
import scala.Option;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class LongSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    public LongSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-long", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        buf.putLong(BoxesRunTime.unboxToLong(o));
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        return BoxesRunTime.boxToLong(buf.getLong());
    }

    @Override
    public byte[] toBinary(Object o) {
        byte[] result = new byte[8];
        int i = 0;
        for (long j = BoxesRunTime.unboxToLong(o); j != 0L; j >>>= 8) {
            result[i] = (byte)(j & 0xFFL);
            ++i;
        }
        return result;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        long result = 0L;
        for (int i = 7; i >= 0; --i) {
            result <<= 8;
            result |= (long)bytes[i] & 0xFFL;
        }
        return BoxesRunTime.boxToLong(result);
    }
}

