/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.JavaSerializer$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.util.ClassLoaderObjectInputStream;
import scala.Function0;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.DynamicVariable;

public class JavaSerializer
implements Serializer,
BaseSerializer {
    private int identifier;
    private final ExtendedActorSystem system;

    public static CurrentSystem currentSystem() {
        return JavaSerializer$.MODULE$.currentSystem();
    }

    public JavaSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$(this);
        if (!system.settings().AllowJavaSerialization()) {
            throw new DisabledJavaSerializer.JavaSerializationException("Attempted creation of `JavaSerializer` while `pekko.actor.allow-java-serialization = off` was set!");
        }
        Statics.releaseFence();
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public byte[] toBinary(Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        JavaSerializer$.MODULE$.currentSystem().withValue(this.system(), (Function0<Object> & Serializable)() -> {
            JavaSerializer.toBinary$$anonfun$1(out, o);
            return BoxedUnit.UNIT;
        });
        out.close();
        return bos.toByteArray();
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) throws NotSerializableException {
        ClassLoaderObjectInputStream in = new ClassLoaderObjectInputStream(this.system().dynamicAccess().classLoader(), new ByteArrayInputStream(bytes));
        Object obj = JavaSerializer$.MODULE$.currentSystem().withValue(this.system(), () -> JavaSerializer.$anonfun$1(in));
        in.close();
        return obj;
    }

    private static final void toBinary$$anonfun$1(ObjectOutputStream out$1, Object o$1) {
        out$1.writeObject(o$1);
    }

    private static final Object $anonfun$1(ClassLoaderObjectInputStream in$1) {
        return in$1.readObject();
    }

    public static final class CurrentSystem
    extends DynamicVariable<ExtendedActorSystem> {
        public CurrentSystem() {
            super(null);
        }

        @Override
        public <S> S withValue(ExtendedActorSystem value, Callable<S> callable) {
            return super.withValue(value, () -> JavaSerializer$.org$apache$pekko$serialization$JavaSerializer$CurrentSystem$$_$withValue$$anonfun$1(callable));
        }
    }
}

