/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import java.nio.ByteBuffer;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.Serializer;
import scala.Option;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class BooleanSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final byte FalseB;
    private final byte TrueB;
    private final int identifier;

    public BooleanSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.FalseB = (byte)0;
        this.TrueB = (byte)1;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-boolean", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        byte by;
        Object object = o;
        if (BoxesRunTime.equals(Boolean.TRUE, object)) {
            by = this.TrueB;
        } else if (BoxesRunTime.equals(Boolean.FALSE, object)) {
            by = this.FalseB;
        } else {
            Object b = object;
            throw new IllegalArgumentException(new StringBuilder(18).append("Non boolean flag: ").append(b).toString());
        }
        byte flag = by;
        buf.put(flag);
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        byte by = buf.get();
        if (this.TrueB == by) {
            return Boolean.TRUE;
        }
        if (this.FalseB == by) {
            return Boolean.FALSE;
        }
        byte b = by;
        throw new IllegalArgumentException(new StringBuilder(23).append("Non boolean flag byte: ").append(b).toString());
    }

    @Override
    public byte[] toBinary(Object o) {
        byte by;
        Object object = o;
        if (BoxesRunTime.equals(Boolean.TRUE, object)) {
            by = this.TrueB;
        } else if (BoxesRunTime.equals(Boolean.FALSE, object)) {
            by = this.FalseB;
        } else {
            Object b = object;
            throw new IllegalArgumentException(new StringBuilder(18).append("Non boolean flag: ").append(b).toString());
        }
        byte flag = by;
        byte[] result = new byte[]{flag};
        return result;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        byte by = bytes[0];
        if (this.TrueB == by) {
            return Boolean.TRUE;
        }
        if (this.FalseB == by) {
            return Boolean.FALSE;
        }
        byte b = by;
        throw new IllegalArgumentException(new StringBuilder(23).append("Non boolean flag byte: ").append(b).toString());
    }
}

