/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.AskableActorSelection$;
import org.apache.pekko.pattern.PipeToSupport;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.ActorSelectionRoutee;
import org.apache.pekko.routing.ActorSelectionRoutee$;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.TailChoppingRoutees$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.BuildFrom$;
import scala.collection.immutable.IndexedSeq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;
import scala.util.Try;

public final class TailChoppingRoutees
implements Routee,
Product,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Scheduler scheduler;
    private final IndexedSeq routees;
    private final FiniteDuration within;
    private final FiniteDuration interval;
    private final ExecutionContext ec;

    public static TailChoppingRoutees apply(Scheduler scheduler, IndexedSeq<Routee> indexedSeq, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, ExecutionContext executionContext) {
        return TailChoppingRoutees$.MODULE$.apply(scheduler, indexedSeq, finiteDuration, finiteDuration2, executionContext);
    }

    public static TailChoppingRoutees unapply(TailChoppingRoutees tailChoppingRoutees) {
        return TailChoppingRoutees$.MODULE$.unapply(tailChoppingRoutees);
    }

    public TailChoppingRoutees(Scheduler scheduler, IndexedSeq<Routee> routees, FiniteDuration within, FiniteDuration interval, ExecutionContext ec) {
        this.scheduler = scheduler;
        this.routees = routees;
        this.within = within;
        this.interval = interval;
        this.ec = ec;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TailChoppingRoutees)) return false;
        TailChoppingRoutees tailChoppingRoutees = (TailChoppingRoutees)object;
        Scheduler scheduler = this.scheduler();
        Scheduler scheduler2 = tailChoppingRoutees.scheduler();
        if (scheduler == null) {
            if (scheduler2 != null) {
                return false;
            }
        } else if (!scheduler.equals(scheduler2)) return false;
        IndexedSeq<Routee> indexedSeq = this.routees();
        IndexedSeq<Routee> indexedSeq2 = tailChoppingRoutees.routees();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        FiniteDuration finiteDuration = this.within();
        FiniteDuration finiteDuration2 = tailChoppingRoutees.within();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
        FiniteDuration finiteDuration3 = this.interval();
        FiniteDuration finiteDuration4 = tailChoppingRoutees.interval();
        if (finiteDuration3 == null) {
            if (finiteDuration4 == null) return true;
            return false;
        } else {
            if (!((Object)finiteDuration3).equals(finiteDuration4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof TailChoppingRoutees;
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public String productPrefix() {
        return "TailChoppingRoutees";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "scheduler";
            }
            case 1: {
                return "routees";
            }
            case 2: {
                return "within";
            }
            case 3: {
                return "interval";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public IndexedSeq<Routee> routees() {
        return this.routees;
    }

    public FiniteDuration within() {
        return this.within;
    }

    public FiniteDuration interval() {
        return this.interval;
    }

    @Override
    public void send(Object message, ActorRef sender) {
        Timeout timeout = Timeout$.MODULE$.apply(this.within());
        Promise promise = Promise$.MODULE$.apply();
        IndexedSeq shuffled = (IndexedSeq)Random$.MODULE$.shuffle(this.routees(), BuildFrom$.MODULE$.buildFromIterableOps());
        AtomicInteger aIdx = new AtomicInteger();
        int size = shuffled.length();
        Cancellable tryWithNext = this.scheduler().scheduleWithFixedDelay(Duration$.MODULE$.Zero(), this.interval(), () -> {
            int idx = aIdx.getAndIncrement();
            if (idx < size) {
                Routee routee = (Routee)shuffled.apply(idx);
                if (routee instanceof ActorRefRoutee) {
                    ActorRef actorRef;
                    ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee);
                    ActorRef ref = actorRef = actorRefRoutee._1();
                    ActorRef actorRef2 = package$.MODULE$.ask(ref);
                    promise.completeWith(AskableActorRef$.MODULE$.ask$extension(actorRef2, message, timeout, AskableActorRef$.MODULE$.ask$default$3$extension(actorRef2, message)));
                    return;
                }
                if (routee instanceof ActorSelectionRoutee) {
                    ActorSelection actorSelection;
                    ActorSelectionRoutee actorSelectionRoutee = ActorSelectionRoutee$.MODULE$.unapply((ActorSelectionRoutee)routee);
                    ActorSelection sel = actorSelection = actorSelectionRoutee._1();
                    ActorSelection actorSelection2 = package$.MODULE$.ask(sel);
                    promise.completeWith(AskableActorSelection$.MODULE$.ask$extension(actorSelection2, message, timeout, AskableActorSelection$.MODULE$.ask$default$3$extension(actorSelection2, message)));
                    return;
                }
                return;
            }
        }, this.ec);
        Cancellable sendTimeout = this.scheduler().scheduleOnce(this.within(), (Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
            this.$anonfun$2(promise, sender);
            return BoxedUnit.UNIT;
        }, this.ec);
        Future f = promise.future();
        f.onComplete((Function1<Try, boolean> & Serializable)x$1 -> {
            Try try_ = x$1;
            tryWithNext.cancel();
            return sendTimeout.cancel();
        }, this.ec);
        PipeToSupport.PipeableFuture pipeableFuture = package$.MODULE$.pipe(f, this.ec);
        pipeableFuture.pipeTo(sender, pipeableFuture.pipeTo$default$2(sender));
    }

    public TailChoppingRoutees copy(Scheduler scheduler, IndexedSeq<Routee> routees, FiniteDuration within, FiniteDuration interval, ExecutionContext ec) {
        return new TailChoppingRoutees(scheduler, routees, within, interval, ec);
    }

    public Scheduler copy$default$1() {
        return this.scheduler();
    }

    public IndexedSeq<Routee> copy$default$2() {
        return this.routees();
    }

    public FiniteDuration copy$default$3() {
        return this.within();
    }

    public FiniteDuration copy$default$4() {
        return this.interval();
    }

    public Scheduler _1() {
        return this.scheduler();
    }

    public IndexedSeq<Routee> _2() {
        return this.routees();
    }

    public FiniteDuration _3() {
        return this.within();
    }

    public FiniteDuration _4() {
        return this.interval();
    }

    private final void $anonfun$2(Promise promise$2, ActorRef sender$1) {
        promise$2.tryFailure(new AskTimeoutException(new StringBuilder(41).append("Ask timed out on [").append(sender$1).append("] after [").append(this.within()).append(".toMillis} ms]").toString()));
    }
}

