/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import com.typesafe.config.Config;
import java.time.Duration;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.routing.PoolOverrideUnsetConfig;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Resizer$;
import org.apache.pekko.routing.Router;
import org.apache.pekko.routing.RouterConfig;
import org.apache.pekko.routing.TailChoppingPool$;
import org.apache.pekko.routing.TailChoppingRoutingLogic$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class TailChoppingPool
implements PoolOverrideUnsetConfig<TailChoppingPool>,
Product {
    private static final long serialVersionUID = 1L;
    private final int nrOfInstances;
    private final Option resizer;
    private final FiniteDuration within;
    private final FiniteDuration interval;
    private final SupervisorStrategy supervisorStrategy;
    private final String routerDispatcher;
    private final boolean usePoolDispatcher;

    public static TailChoppingPool apply(int n, Option<Resizer> option, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, SupervisorStrategy supervisorStrategy, String string2, boolean bl) {
        return TailChoppingPool$.MODULE$.apply(n, option, finiteDuration, finiteDuration2, supervisorStrategy, string2, bl);
    }

    public static TailChoppingPool fromProduct(Product product) {
        return TailChoppingPool$.MODULE$.fromProduct(product);
    }

    public static TailChoppingPool unapply(TailChoppingPool tailChoppingPool) {
        return TailChoppingPool$.MODULE$.unapply(tailChoppingPool);
    }

    public static Option<Resizer> $lessinit$greater$default$2() {
        return TailChoppingPool$.MODULE$.$lessinit$greater$default$2();
    }

    public static SupervisorStrategy $lessinit$greater$default$5() {
        return TailChoppingPool$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$6() {
        return TailChoppingPool$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return TailChoppingPool$.MODULE$.$lessinit$greater$default$7();
    }

    public TailChoppingPool(int nrOfInstances, Option<Resizer> resizer, FiniteDuration within, FiniteDuration interval, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        this.nrOfInstances = nrOfInstances;
        this.resizer = resizer;
        this.within = within;
        this.interval = interval;
        this.supervisorStrategy = supervisorStrategy;
        this.routerDispatcher = routerDispatcher;
        this.usePoolDispatcher = usePoolDispatcher;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.nrOfInstances());
        n = Statics.mix(n, Statics.anyHash(this.resizer()));
        n = Statics.mix(n, Statics.anyHash(this.within()));
        n = Statics.mix(n, Statics.anyHash(this.interval()));
        n = Statics.mix(n, Statics.anyHash(this.supervisorStrategy()));
        n = Statics.mix(n, Statics.anyHash(this.routerDispatcher()));
        n = Statics.mix(n, this.usePoolDispatcher() ? 1231 : 1237);
        return Statics.finalizeHash(n, 7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TailChoppingPool)) return false;
        TailChoppingPool tailChoppingPool = (TailChoppingPool)object;
        if (this.nrOfInstances() != tailChoppingPool.nrOfInstances()) return false;
        if (this.usePoolDispatcher() != tailChoppingPool.usePoolDispatcher()) return false;
        Option<Resizer> option = this.resizer();
        Option<Resizer> option2 = tailChoppingPool.resizer();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        FiniteDuration finiteDuration = this.within();
        FiniteDuration finiteDuration2 = tailChoppingPool.within();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
        FiniteDuration finiteDuration3 = this.interval();
        FiniteDuration finiteDuration4 = tailChoppingPool.interval();
        if (finiteDuration3 == null) {
            if (finiteDuration4 != null) {
                return false;
            }
        } else if (!((Object)finiteDuration3).equals(finiteDuration4)) return false;
        SupervisorStrategy supervisorStrategy = this.supervisorStrategy();
        SupervisorStrategy supervisorStrategy2 = tailChoppingPool.supervisorStrategy();
        if (supervisorStrategy == null) {
            if (supervisorStrategy2 != null) {
                return false;
            }
        } else if (!supervisorStrategy.equals(supervisorStrategy2)) return false;
        String string2 = this.routerDispatcher();
        String string3 = tailChoppingPool.routerDispatcher();
        if (string2 == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!string2.equals(string3)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof TailChoppingPool;
    }

    @Override
    public int productArity() {
        return 7;
    }

    @Override
    public String productPrefix() {
        return "TailChoppingPool";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger(this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return BoxesRunTime.boxToBoolean(this._7());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "nrOfInstances";
            }
            case 1: {
                return "resizer";
            }
            case 2: {
                return "within";
            }
            case 3: {
                return "interval";
            }
            case 4: {
                return "supervisorStrategy";
            }
            case 5: {
                return "routerDispatcher";
            }
            case 6: {
                return "usePoolDispatcher";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public int nrOfInstances() {
        return this.nrOfInstances;
    }

    @Override
    public Option<Resizer> resizer() {
        return this.resizer;
    }

    public FiniteDuration within() {
        return this.within;
    }

    public FiniteDuration interval() {
        return this.interval;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    @Override
    public String routerDispatcher() {
        return this.routerDispatcher;
    }

    @Override
    public boolean usePoolDispatcher() {
        return this.usePoolDispatcher;
    }

    public TailChoppingPool(Config config) {
        int n = config.getInt("nr-of-instances");
        FiniteDuration finiteDuration = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "within");
        FiniteDuration finiteDuration2 = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "tail-chopping-router.interval");
        Option<Resizer> option = Resizer$.MODULE$.fromConfig(config);
        boolean bl = config.hasPath("pool-dispatcher");
        SupervisorStrategy supervisorStrategy = TailChoppingPool$.MODULE$.$lessinit$greater$default$5();
        String string2 = TailChoppingPool$.MODULE$.$lessinit$greater$default$6();
        this(n, option, finiteDuration, finiteDuration2, supervisorStrategy, string2, bl);
    }

    public TailChoppingPool(int nr, FiniteDuration within, FiniteDuration interval) {
        this(nr, TailChoppingPool$.MODULE$.$lessinit$greater$default$2(), within, interval, TailChoppingPool$.MODULE$.$lessinit$greater$default$5(), TailChoppingPool$.MODULE$.$lessinit$greater$default$6(), TailChoppingPool$.MODULE$.$lessinit$greater$default$7());
    }

    public TailChoppingPool(int nr, Duration within, Duration interval) {
        this(nr, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(within)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)));
    }

    @Override
    public Router createRouter(ActorSystem system) {
        return new Router(TailChoppingRoutingLogic$.MODULE$.apply(system.scheduler(), this.within(), this.interval(), system.dispatchers().lookup(this.routerDispatcher())));
    }

    @Override
    public int nrOfInstances(ActorSystem sys) {
        return this.nrOfInstances();
    }

    @Override
    public TailChoppingPool withSupervisorStrategy(SupervisorStrategy strategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), strategy, this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public TailChoppingPool withResizer(Resizer resizer) {
        Some<Resizer> some = Some$.MODULE$.apply(resizer);
        int n = this.copy$default$1();
        FiniteDuration finiteDuration = this.copy$default$3();
        FiniteDuration finiteDuration2 = this.copy$default$4();
        SupervisorStrategy supervisorStrategy = this.copy$default$5();
        String string2 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        return this.copy(n, some, finiteDuration, finiteDuration2, supervisorStrategy, string2, bl);
    }

    public TailChoppingPool withDispatcher(String dispatcherId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), dispatcherId, this.copy$default$7());
    }

    @Override
    public RouterConfig withFallback(RouterConfig other) {
        return this.overrideUnsetConfig(other);
    }

    public TailChoppingPool copy(int nrOfInstances, Option<Resizer> resizer, FiniteDuration within, FiniteDuration interval, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        return new TailChoppingPool(nrOfInstances, resizer, within, interval, supervisorStrategy, routerDispatcher, usePoolDispatcher);
    }

    public int copy$default$1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> copy$default$2() {
        return this.resizer();
    }

    public FiniteDuration copy$default$3() {
        return this.within();
    }

    public FiniteDuration copy$default$4() {
        return this.interval();
    }

    public SupervisorStrategy copy$default$5() {
        return this.supervisorStrategy();
    }

    public String copy$default$6() {
        return this.routerDispatcher();
    }

    public boolean copy$default$7() {
        return this.usePoolDispatcher();
    }

    public int _1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> _2() {
        return this.resizer();
    }

    public FiniteDuration _3() {
        return this.within();
    }

    public FiniteDuration _4() {
        return this.interval();
    }

    public SupervisorStrategy _5() {
        return this.supervisorStrategy();
    }

    public String _6() {
        return this.routerDispatcher();
    }

    public boolean _7() {
        return this.usePoolDispatcher();
    }
}

