/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorInitializationException$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.AddRoutee;
import org.apache.pekko.routing.AddRoutee$;
import org.apache.pekko.routing.GetRoutees$;
import org.apache.pekko.routing.RemoveRoutee;
import org.apache.pekko.routing.RemoveRoutee$;
import org.apache.pekko.routing.RoutedActorCell;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.Routees$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;

public class RouterActor
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final RoutedActorCell cell;
    private final Option routingLogicController;

    public RouterActor() {
        Actor.$init$(this);
        ActorContext actorContext = this.context();
        if (!(actorContext instanceof RoutedActorCell)) {
            throw ActorInitializationException$.MODULE$.apply(new StringBuilder(56).append("Router actor can only be used in RoutedActorRef, not in ").append(this.context().getClass()).toString());
        }
        RoutedActorCell x = (RoutedActorCell)actorContext;
        this.cell = x;
        this.routingLogicController = this.cell().routerConfig().routingLogicController(this.cell().router().logic()).map((Function1<Props, ActorRef> & Serializable)props -> this.context().actorOf(props.withDispatcher(this.context().props().dispatcher()), "routingLogicController"));
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public RoutedActorCell cell() {
        return this.cell;
    }

    public Option<ActorRef> routingLogicController() {
        return this.routingLogicController;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ RouterActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (GetRoutees$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof AddRoutee) {
                    Routee routee;
                    AddRoutee addRoutee = AddRoutee$.MODULE$.unapply((AddRoutee)object);
                    Routee routee2 = routee = addRoutee._1();
                    return true;
                }
                if (object instanceof RemoveRoutee) {
                    Routee routee;
                    RemoveRoutee removeRoutee = RemoveRoutee$.MODULE$.unapply((RemoveRoutee)object);
                    Routee routee3 = routee = removeRoutee._1();
                    return true;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef child = actorRef = terminated._1();
                    return true;
                }
                Object other = object;
                return this.$outer.routingLogicController().isDefined();
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (GetRoutees$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang(Routees$.MODULE$.apply(this.$outer.cell().router().routees()), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof AddRoutee) {
                    Routee routee;
                    AddRoutee addRoutee = AddRoutee$.MODULE$.unapply((AddRoutee)object);
                    Routee routee2 = routee = addRoutee._1();
                    this.$outer.cell().addRoutee(routee2);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RemoveRoutee) {
                    Routee routee;
                    RemoveRoutee removeRoutee = RemoveRoutee$.MODULE$.unapply((RemoveRoutee)object);
                    Routee routee3 = routee = removeRoutee._1();
                    this.$outer.cell().removeRoutee(routee3, true);
                    this.$outer.stopIfAllRouteesRemoved();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef child = actorRef = terminated._1();
                    this.$outer.cell().removeRoutee(ActorRefRoutee$.MODULE$.apply(child), false);
                    this.$outer.stopIfAllRouteesRemoved();
                    return BoxedUnit.UNIT;
                }
                Object other = object;
                if (this.$outer.routingLogicController().isDefined()) {
                    this.$outer.routingLogicController().foreach(_$2 -> _$2.forward(other, this.$outer.context()));
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Object org.apache.pekko.actor.ActorRef )}, serializedLambda);
            }
        };
    }

    public void stopIfAllRouteesRemoved() {
        if (this.cell().router().routees().isEmpty() && this.cell().routerConfig().stopRouterWhenAllRouteesRemoved()) {
            this.context().stop(this.self());
            return;
        }
    }

    @Override
    public void preRestart(Throwable cause, Option<Object> msg) {
    }
}

