/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.ActorSelectionRoutee$;
import org.apache.pekko.routing.Broadcast;
import org.apache.pekko.routing.Broadcast$;
import org.apache.pekko.routing.NoRoutee$;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.Router$;
import org.apache.pekko.routing.RouterEnvelope;
import org.apache.pekko.routing.RoutingLogic;
import org.apache.pekko.routing.SeveralRoutees$;
import scala.Function1;
import scala.Product;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Router
implements Product,
Serializable {
    private final RoutingLogic logic;
    private final IndexedSeq routees;

    public static Router apply(RoutingLogic routingLogic, IndexedSeq<Routee> indexedSeq) {
        return Router$.MODULE$.apply(routingLogic, indexedSeq);
    }

    public static Router fromProduct(Product product) {
        return Router$.MODULE$.fromProduct(product);
    }

    public static Router unapply(Router router) {
        return Router$.MODULE$.unapply(router);
    }

    public static IndexedSeq<Routee> $lessinit$greater$default$2() {
        return Router$.MODULE$.$lessinit$greater$default$2();
    }

    public Router(RoutingLogic logic, IndexedSeq<Routee> routees) {
        this.logic = logic;
        this.routees = routees;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Router)) return false;
        Router router = (Router)object;
        RoutingLogic routingLogic = this.logic();
        RoutingLogic routingLogic2 = router.logic();
        if (routingLogic == null) {
            if (routingLogic2 != null) {
                return false;
            }
        } else if (!routingLogic.equals(routingLogic2)) return false;
        IndexedSeq<Routee> indexedSeq = this.routees();
        IndexedSeq<Routee> indexedSeq2 = router.routees();
        if (indexedSeq == null) {
            if (indexedSeq2 == null) return true;
            return false;
        } else {
            if (!indexedSeq.equals(indexedSeq2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof Router;
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public String productPrefix() {
        return "Router";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "logic";
        }
        if (1 == n2) {
            return "routees";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public RoutingLogic logic() {
        return this.logic;
    }

    public IndexedSeq<Routee> routees() {
        return this.routees;
    }

    public Router(RoutingLogic logic) {
        this(logic, (IndexedSeq<Routee>)package$.MODULE$.Vector().empty());
    }

    public Router(RoutingLogic logic, Iterable<Routee> routees) {
        this(logic, Util$.MODULE$.immutableSeq(routees).toVector());
    }

    public void route(Object message, ActorRef sender) {
        Object object = message;
        if (object instanceof Broadcast) {
            Object object2;
            Broadcast broadcast = Broadcast$.MODULE$.unapply((Broadcast)object);
            Object msg = object2 = broadcast._1();
            SeveralRoutees$.MODULE$.apply(this.routees()).send(msg, sender);
            return;
        }
        Object msg = object;
        this.send(this.logic().select(msg, this.routees()), message, sender);
    }

    private void send(Routee routee, Object msg, ActorRef sender) {
        Routee routee2 = routee;
        NoRoutee$ noRoutee$ = NoRoutee$.MODULE$;
        if (!(routee2 != null ? !routee2.equals(noRoutee$) : noRoutee$ != null) && sender instanceof InternalActorRef) {
            ((InternalActorRef)sender).provider().deadLetters().tell(this.unwrap(msg), sender);
            return;
        }
        routee.send(this.unwrap(msg), sender);
    }

    private Object unwrap(Object msg) {
        Object object = msg;
        if (object instanceof RouterEnvelope) {
            RouterEnvelope env = (RouterEnvelope)object;
            return env.message();
        }
        return msg;
    }

    public Router withRoutees(IndexedSeq<Routee> rs) {
        return this.copy(this.copy$default$1(), rs);
    }

    public Router addRoutee(Routee routee) {
        IndexedSeq indexedSeq = (IndexedSeq)this.routees().$colon$plus(routee);
        RoutingLogic routingLogic = this.copy$default$1();
        return this.copy(routingLogic, indexedSeq);
    }

    public Router addRoutee(ActorRef ref) {
        return this.addRoutee(ActorRefRoutee$.MODULE$.apply(ref));
    }

    public Router addRoutee(ActorSelection sel) {
        return this.addRoutee(ActorSelectionRoutee$.MODULE$.apply(sel));
    }

    public Router removeRoutee(Routee routee) {
        IndexedSeq indexedSeq = (IndexedSeq)this.routees().filterNot((Function1<Routee, boolean> & Serializable)_$2 -> {
            Routee routee = _$2;
            Routee routee2 = routee;
            return !(routee != null ? !routee.equals(routee2) : routee2 != null);
        });
        RoutingLogic routingLogic = this.copy$default$1();
        return this.copy(routingLogic, indexedSeq);
    }

    public Router removeRoutee(ActorRef ref) {
        return this.removeRoutee(ActorRefRoutee$.MODULE$.apply(ref));
    }

    public Router removeRoutee(ActorSelection sel) {
        return this.removeRoutee(ActorSelectionRoutee$.MODULE$.apply(sel));
    }

    public Router copy(RoutingLogic logic, IndexedSeq<Routee> routees) {
        return new Router(logic, routees);
    }

    public RoutingLogic copy$default$1() {
        return this.logic();
    }

    public IndexedSeq<Routee> copy$default$2() {
        return this.routees();
    }

    public RoutingLogic _1() {
        return this.logic();
    }

    public IndexedSeq<Routee> _2() {
        return this.routees();
    }
}

