/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.RepointableActorRef;
import org.apache.pekko.actor.UnstartedCell;
import org.apache.pekko.dispatch.BalancingDispatcher;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.routing.NoRouter$;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.ResizablePoolCell;
import org.apache.pekko.routing.RoutedActorCell;
import org.apache.pekko.routing.RouterConfig;

public class RoutedActorRef
extends RepointableActorRef {
    private final Props _routeeProps;

    public RoutedActorRef(ActorSystemImpl _system, Props _routerProps, MessageDispatcher _routerDispatcher, MailboxType _routerMailbox, Props _routeeProps, InternalActorRef _supervisor, ActorPath _path) {
        this._routeeProps = _routeeProps;
        super(_system, _routerProps, _routerDispatcher, _routerMailbox, _supervisor, _path);
        RouterConfig routerConfig = _routerProps.routerConfig();
        NoRouter$ noRouter$ = NoRouter$.MODULE$;
        if ((routerConfig == null ? noRouter$ != null : !routerConfig.equals(noRouter$)) && _routerDispatcher instanceof BalancingDispatcher) {
            throw new ConfigurationException(new StringBuilder(137).append("Configuration for ").append(this).append(" is invalid - you can not use a 'BalancingDispatcher' as a Router's dispatcher, you can however use it for the routees.").toString());
        }
        _routerProps.routerConfig().verifyConfig(_path);
    }

    @Override
    public Cell newCell(UnstartedCell old) {
        Pool pool;
        RouterConfig routerConfig = this.props().routerConfig();
        RoutedActorCell cell = routerConfig instanceof Pool && (pool = (Pool)routerConfig).resizer().isDefined() ? new ResizablePoolCell(this.system(), this, this.props(), this.dispatcher(), this._routeeProps, this.supervisor(), pool) : new RoutedActorCell(this.system(), this, this.props(), this.dispatcher(), this._routeeProps, this.supervisor());
        return (RoutedActorCell)cell.init(false, this.mailboxType());
    }
}

