/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.actor.IndirectActorProducer;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.dungeon.Dispatch;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.Group;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.Router;
import org.apache.pekko.routing.RouterActor;
import org.apache.pekko.routing.RouterConfig;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.collection.IterableFactory$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.Nothing$;

public class RoutedActorCell
extends ActorCell
implements Dispatch {
    private final Props routeeProps;
    private final RouterConfig routerConfig;
    private volatile Router _router;

    public RoutedActorCell(ActorSystemImpl _system, InternalActorRef _ref, Props _routerProps, MessageDispatcher _routerDispatcher, Props routeeProps, InternalActorRef _supervisor) {
        this.routeeProps = routeeProps;
        super(_system, _ref, _routerProps, _routerDispatcher, _supervisor);
        this.routerConfig = _routerProps.routerConfig();
        this._router = null;
    }

    public Props routeeProps() {
        return this.routeeProps;
    }

    public RouterConfig routerConfig() {
        return this.routerConfig;
    }

    public Router router() {
        return this._router;
    }

    public void addRoutee(Routee routee) {
        this.addRoutees((Iterable)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)routee), Nil$.MODULE$)));
    }

    public void addRoutees(Iterable<Routee> routees) {
        routees.foreach(routee -> this.watch((Routee)routee));
        Router r = this._router;
        this._router = r.withRoutees((IndexedSeq)r.routees().$plus$plus(routees));
    }

    public void removeRoutee(Routee routee, boolean stopChild) {
        this.removeRoutees((Iterable)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)routee), Nil$.MODULE$)), stopChild);
    }

    public void removeRoutees(Iterable<Routee> routees, boolean stopChild) {
        Router r = this._router;
        IndexedSeq<Routee> newRoutees = routees.foldLeft(r.routees(), (Function2<IndexedSeq, Routee, IndexedSeq> & Serializable)(xs, x) -> {
            this.unwatch((Routee)x);
            return (IndexedSeq)xs.filterNot((Function1<Routee, boolean> & Serializable)_$1 -> {
                Routee routee = _$1;
                Routee routee2 = x;
                return !(routee != null ? !routee.equals(routee2) : routee2 != null);
            });
        });
        this._router = r.withRoutees(newRoutees);
        if (stopChild) {
            routees.foreach(routee -> this.stopIfChild((Routee)routee));
            return;
        }
    }

    private void watch(Routee routee) {
        Routee routee2 = routee;
        if (routee2 instanceof ActorRefRoutee) {
            ActorRef actorRef;
            ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee2);
            ActorRef ref = actorRef = actorRefRoutee._1();
            this.watch(ref);
            return;
        }
    }

    private void unwatch(Routee routee) {
        Routee routee2 = routee;
        if (routee2 instanceof ActorRefRoutee) {
            ActorRef actorRef;
            ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee2);
            ActorRef ref = actorRef = actorRefRoutee._1();
            this.unwatch(ref);
            return;
        }
    }

    private void stopIfChild(Routee routee) {
        Routee routee2 = routee;
        if (routee2 instanceof ActorRefRoutee) {
            ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee2);
            ActorRef actorRef = actorRefRoutee._1();
            ActorRef ref = actorRef;
            Option option = this.child(ref.path().name());
            if (option instanceof Some) {
                ActorRef actorRef2 = ref;
                Object a = ((Some)option).value();
                if (!(actorRef2 != null ? !((Object)actorRef2).equals(a) : a != null)) {
                    FiniteDuration finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds();
                    this.system().scheduler().scheduleOnce(finiteDuration, ref, (Object)PoisonPill$.MODULE$, (ExecutionContext)this.dispatcher(), this.system().scheduler().scheduleOnce$default$5(finiteDuration, ref, PoisonPill$.MODULE$));
                    return;
                }
            }
            return;
        }
    }

    @Override
    public RoutedActorCell start() {
        Group group;
        Iterable<String> paths;
        this._router = this.routerConfig().createRouter(this.system());
        RouterConfig routerConfig = this.routerConfig();
        if (routerConfig instanceof Pool) {
            Pool pool = (Pool)routerConfig;
            int nrOfRoutees = pool.nrOfInstances(this.system());
            if (nrOfRoutees > 0) {
                this.addRoutees((Iterable)((Object)package$.MODULE$.Vector().fill(nrOfRoutees, () -> this.start$$anonfun$1(pool))));
            }
        } else if (routerConfig instanceof Group && (paths = (group = (Group)routerConfig).paths(this.system())).nonEmpty()) {
            this.addRoutees(paths.iterator().map((Function1<String, Routee> & Serializable)p -> group.routeeFor((String)p, this)).to(IterableFactory$.MODULE$.toFactory(IndexedSeq$.MODULE$)));
        }
        this.preSuperStart();
        return (RoutedActorCell)Dispatch.start$(this);
    }

    public void preSuperStart() {
    }

    @Override
    public void sendMessage(Envelope envelope) {
        if (this.routerConfig().isManagementMessage(envelope.message())) {
            Dispatch.sendMessage$(this, envelope);
            return;
        }
        this.router().route(envelope.message(), envelope.sender());
    }

    private final Routee start$$anonfun$1(Pool pool$1) {
        return pool$1.newRoutee(this.routeeProps(), this);
    }

    public static class RouterActorCreator
    implements IndirectActorProducer {
        private final RouterConfig routerConfig;

        public RouterActorCreator(RouterConfig routerConfig) {
            this.routerConfig = routerConfig;
        }

        @Override
        public Class<? extends Actor> actorClass() {
            return RouterActor.class;
        }

        @Override
        public Actor produce() {
            return this.routerConfig.createRouterActor();
        }
    }
}

