/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.routing.PoolOverrideUnsetConfig;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Resizer$;
import org.apache.pekko.routing.RoundRobinPool$;
import org.apache.pekko.routing.RoundRobinRoutingLogic$;
import org.apache.pekko.routing.Router;
import org.apache.pekko.routing.RouterConfig;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class RoundRobinPool
implements PoolOverrideUnsetConfig<RoundRobinPool>,
Product {
    private static final long serialVersionUID = 1L;
    private final int nrOfInstances;
    private final Option resizer;
    private final SupervisorStrategy supervisorStrategy;
    private final String routerDispatcher;
    private final boolean usePoolDispatcher;

    public static RoundRobinPool apply(int n, Option<Resizer> option, SupervisorStrategy supervisorStrategy, String string2, boolean bl) {
        return RoundRobinPool$.MODULE$.apply(n, option, supervisorStrategy, string2, bl);
    }

    public static RoundRobinPool fromProduct(Product product) {
        return RoundRobinPool$.MODULE$.fromProduct(product);
    }

    public static RoundRobinPool unapply(RoundRobinPool roundRobinPool) {
        return RoundRobinPool$.MODULE$.unapply(roundRobinPool);
    }

    public static Option<Resizer> $lessinit$greater$default$2() {
        return RoundRobinPool$.MODULE$.$lessinit$greater$default$2();
    }

    public static SupervisorStrategy $lessinit$greater$default$3() {
        return RoundRobinPool$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$4() {
        return RoundRobinPool$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$5() {
        return RoundRobinPool$.MODULE$.$lessinit$greater$default$5();
    }

    public RoundRobinPool(int nrOfInstances, Option<Resizer> resizer, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        this.nrOfInstances = nrOfInstances;
        this.resizer = resizer;
        this.supervisorStrategy = supervisorStrategy;
        this.routerDispatcher = routerDispatcher;
        this.usePoolDispatcher = usePoolDispatcher;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.nrOfInstances());
        n = Statics.mix(n, Statics.anyHash(this.resizer()));
        n = Statics.mix(n, Statics.anyHash(this.supervisorStrategy()));
        n = Statics.mix(n, Statics.anyHash(this.routerDispatcher()));
        n = Statics.mix(n, this.usePoolDispatcher() ? 1231 : 1237);
        return Statics.finalizeHash(n, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RoundRobinPool)) return false;
        RoundRobinPool roundRobinPool = (RoundRobinPool)object;
        if (this.nrOfInstances() != roundRobinPool.nrOfInstances()) return false;
        if (this.usePoolDispatcher() != roundRobinPool.usePoolDispatcher()) return false;
        Option<Resizer> option = this.resizer();
        Option<Resizer> option2 = roundRobinPool.resizer();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        SupervisorStrategy supervisorStrategy = this.supervisorStrategy();
        SupervisorStrategy supervisorStrategy2 = roundRobinPool.supervisorStrategy();
        if (supervisorStrategy == null) {
            if (supervisorStrategy2 != null) {
                return false;
            }
        } else if (!supervisorStrategy.equals(supervisorStrategy2)) return false;
        String string2 = this.routerDispatcher();
        String string3 = roundRobinPool.routerDispatcher();
        if (string2 == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!string2.equals(string3)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof RoundRobinPool;
    }

    @Override
    public int productArity() {
        return 5;
    }

    @Override
    public String productPrefix() {
        return "RoundRobinPool";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger(this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean(this._5());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "nrOfInstances";
            }
            case 1: {
                return "resizer";
            }
            case 2: {
                return "supervisorStrategy";
            }
            case 3: {
                return "routerDispatcher";
            }
            case 4: {
                return "usePoolDispatcher";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public int nrOfInstances() {
        return this.nrOfInstances;
    }

    @Override
    public Option<Resizer> resizer() {
        return this.resizer;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    @Override
    public String routerDispatcher() {
        return this.routerDispatcher;
    }

    @Override
    public boolean usePoolDispatcher() {
        return this.usePoolDispatcher;
    }

    public RoundRobinPool(Config config) {
        int n = config.getInt("nr-of-instances");
        Option<Resizer> option = Resizer$.MODULE$.fromConfig(config);
        boolean bl = config.hasPath("pool-dispatcher");
        SupervisorStrategy supervisorStrategy = RoundRobinPool$.MODULE$.$lessinit$greater$default$3();
        String string2 = RoundRobinPool$.MODULE$.$lessinit$greater$default$4();
        this(n, option, supervisorStrategy, string2, bl);
    }

    public RoundRobinPool(int nr) {
        this(nr, RoundRobinPool$.MODULE$.$lessinit$greater$default$2(), RoundRobinPool$.MODULE$.$lessinit$greater$default$3(), RoundRobinPool$.MODULE$.$lessinit$greater$default$4(), RoundRobinPool$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public Router createRouter(ActorSystem system) {
        return new Router(RoundRobinRoutingLogic$.MODULE$.apply());
    }

    @Override
    public int nrOfInstances(ActorSystem sys) {
        return this.nrOfInstances();
    }

    @Override
    public RoundRobinPool withSupervisorStrategy(SupervisorStrategy strategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), strategy, this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public RoundRobinPool withResizer(Resizer resizer) {
        Some<Resizer> some = Some$.MODULE$.apply(resizer);
        int n = this.copy$default$1();
        SupervisorStrategy supervisorStrategy = this.copy$default$3();
        String string2 = this.copy$default$4();
        boolean bl = this.copy$default$5();
        return this.copy(n, some, supervisorStrategy, string2, bl);
    }

    public RoundRobinPool withDispatcher(String dispatcherId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), dispatcherId, this.copy$default$5());
    }

    @Override
    public RouterConfig withFallback(RouterConfig other) {
        return this.overrideUnsetConfig(other);
    }

    public RoundRobinPool copy(int nrOfInstances, Option<Resizer> resizer, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        return new RoundRobinPool(nrOfInstances, resizer, supervisorStrategy, routerDispatcher, usePoolDispatcher);
    }

    public int copy$default$1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> copy$default$2() {
        return this.resizer();
    }

    public SupervisorStrategy copy$default$3() {
        return this.supervisorStrategy();
    }

    public String copy$default$4() {
        return this.routerDispatcher();
    }

    public boolean copy$default$5() {
        return this.usePoolDispatcher();
    }

    public int _1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> _2() {
        return this.resizer();
    }

    public SupervisorStrategy _3() {
        return this.supervisorStrategy();
    }

    public String _4() {
        return this.routerDispatcher();
    }

    public boolean _5() {
        return this.usePoolDispatcher();
    }
}

