/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Envelope$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.routing.OptimalSizeExploringResizer;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.ResizablePoolActor$Resize$;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.RoutedActorCell;
import org.apache.pekko.routing.Routee;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Vector;
import scala.package$;

public final class ResizablePoolCell
extends RoutedActorCell {
    private final Pool pool;
    private final Resizer resizer;
    private final AtomicBoolean resizeInProgress;
    private final AtomicLong resizeCounter;

    public ResizablePoolCell(ActorSystemImpl _system, InternalActorRef _ref, Props _routerProps, MessageDispatcher _routerDispatcher, Props _routeeProps, InternalActorRef _supervisor, Pool pool) {
        this.pool = pool;
        super(_system, _ref, _routerProps, _routerDispatcher, _routeeProps, _supervisor);
        Predef$.MODULE$.require(pool.resizer().isDefined(), ResizablePoolCell::$init$$$anonfun$1);
        this.resizer = pool.resizer().get();
        this.resizeInProgress = new AtomicBoolean();
        this.resizeCounter = new AtomicLong();
    }

    public Pool pool() {
        return this.pool;
    }

    public Resizer resizer() {
        return this.resizer;
    }

    @Override
    public void preSuperStart() {
        if (this.resizer().isTimeForResize(this.resizeCounter.getAndIncrement())) {
            this.resize(true);
            return;
        }
    }

    @Override
    public void sendMessage(Envelope envelope) {
        if (!this.routerConfig().isManagementMessage(envelope.message()) && this.resizer().isTimeForResize(this.resizeCounter.getAndIncrement()) && this.resizeInProgress.compareAndSet(false, true)) {
            super.sendMessage(Envelope$.MODULE$.apply(ResizablePoolActor$Resize$.MODULE$, this.self(), this.system()));
        }
        super.sendMessage(envelope);
    }

    public void resize(boolean initial) {
        if (this.resizeInProgress.get() || initial) {
            try {
                this.tryReportMessageCount();
                int requestedCapacity = this.resizer().resize(this.router().routees());
                if (requestedCapacity > 0) {
                    Vector newRoutees = (Vector)package$.MODULE$.Vector().fill(requestedCapacity, this::$anonfun$1);
                    this.addRoutees(newRoutees);
                } else if (requestedCapacity < 0) {
                    IndexedSeq<Routee> currentRoutees = this.router().routees();
                    IndexedSeq abandon = (IndexedSeq)currentRoutees.drop(currentRoutees.length() + requestedCapacity);
                    this.removeRoutees(abandon, true);
                }
            }
            finally {
                this.resizeInProgress.set(false);
            }
            return;
        }
    }

    private void tryReportMessageCount() {
        Resizer resizer = this.resizer();
        if (resizer instanceof OptimalSizeExploringResizer) {
            OptimalSizeExploringResizer r = (OptimalSizeExploringResizer)resizer;
            r.reportMessageCount(this.router().routees(), this.resizeCounter.get());
            return;
        }
    }

    private static final Object $init$$$anonfun$1() {
        return "RouterConfig must be a Pool with defined resizer";
    }

    private final Routee $anonfun$1() {
        return this.pool().newRoutee(this.routeeProps(), this);
    }
}

