/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.Pool$;
import org.apache.pekko.routing.ResizablePoolActor;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.RouterActor;
import org.apache.pekko.routing.RouterConfig;
import org.apache.pekko.routing.RouterPoolActor;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;

public interface Pool
extends RouterConfig {
    public static SupervisorStrategy defaultSupervisorStrategy() {
        return Pool$.MODULE$.defaultSupervisorStrategy();
    }

    public int nrOfInstances(ActorSystem var1);

    public static boolean usePoolDispatcher$(Pool $this) {
        return $this.usePoolDispatcher();
    }

    default public boolean usePoolDispatcher() {
        return false;
    }

    public static Routee newRoutee$(Pool $this, Props routeeProps, ActorContext context) {
        return $this.newRoutee(routeeProps, context);
    }

    default public Routee newRoutee(Props routeeProps, ActorContext context) {
        return ActorRefRoutee$.MODULE$.apply(context.actorOf(this.enrichWithPoolDispatcher(routeeProps, context)));
    }

    public static Props enrichWithPoolDispatcher$(Pool $this, Props routeeProps, ActorContext context) {
        return $this.enrichWithPoolDispatcher(routeeProps, context);
    }

    default public Props enrichWithPoolDispatcher(Props routeeProps, ActorContext context) {
        if (this.usePoolDispatcher()) {
            String string2 = routeeProps.dispatcher();
            String string3 = "pekko.actor.default-dispatcher";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return routeeProps.withDispatcher(new StringBuilder(39).append("pekko.actor.deployment.").append(((IterableOnceOps)context.self().path().elements().drop(1)).mkString("/", "/", "")).append(".pool-dispatcher").toString());
            }
        }
        return routeeProps;
    }

    public Option<Resizer> resizer();

    public SupervisorStrategy supervisorStrategy();

    public static Props props$(Pool $this, Props routeeProps) {
        return $this.props(routeeProps);
    }

    default public Props props(Props routeeProps) {
        return routeeProps.withRouter(this);
    }

    public static boolean stopRouterWhenAllRouteesRemoved$(Pool $this) {
        return $this.stopRouterWhenAllRouteesRemoved();
    }

    @Override
    default public boolean stopRouterWhenAllRouteesRemoved() {
        return this.resizer().isEmpty();
    }

    public static RouterActor createRouterActor$(Pool $this) {
        return $this.createRouterActor();
    }

    @Override
    default public RouterActor createRouterActor() {
        Option<Resizer> option = this.resizer();
        if (None$.MODULE$.equals(option)) {
            return new RouterPoolActor(this.supervisorStrategy());
        }
        if (option instanceof Some) {
            return new ResizablePoolActor(this.supervisorStrategy());
        }
        throw new MatchError(option);
    }
}

