/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import scala.Char$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class MurmurHash$
implements Serializable {
    private static final int visibleMagic;
    private static final int hiddenMagicA;
    private static final int hiddenMagicB;
    private static final int visibleMixer;
    private static final int hiddenMixerA;
    private static final int hiddenMixerB;
    private static final int finalMixer1;
    private static final int finalMixer2;
    private static final int seedString;
    private static final int seedArray;
    private static final int[] storedMagicA;
    private static final int[] storedMagicB;
    public static final MurmurHash$ MODULE$;

    private MurmurHash$() {
    }

    static {
        MODULE$ = new MurmurHash$();
        visibleMagic = -1759636613;
        hiddenMagicA = -1789642873;
        hiddenMagicB = 718793509;
        visibleMixer = 1390208809;
        hiddenMixerA = 2071795100;
        hiddenMixerB = 1808688022;
        finalMixer1 = -2048144789;
        finalMixer2 = -1028477387;
        seedString = -137723950;
        seedArray = 1007110753;
        storedMagicA = (int[])package$.MODULE$.Iterator().iterate(BoxesRunTime.boxToInteger(hiddenMagicA), magicA -> this.nextMagicA(magicA)).take(23).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
        storedMagicB = (int[])package$.MODULE$.Iterator().iterate(BoxesRunTime.boxToInteger(hiddenMagicB), magicB -> this.nextMagicB(magicB)).take(23).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MurmurHash$.class);
    }

    public int startHash(int seed) {
        return seed ^ visibleMagic;
    }

    public int startMagicA() {
        return hiddenMagicA;
    }

    public int startMagicB() {
        return hiddenMagicB;
    }

    public int extendHash(int hash, int value, int magicA, int magicB) {
        return (hash ^ Integer.rotateLeft(value * magicA, 11) * magicB) * 3 + visibleMixer;
    }

    public int nextMagicA(int magicA) {
        return magicA * 5 + hiddenMixerA;
    }

    public int nextMagicB(int magicB) {
        return magicB * 5 + hiddenMixerB;
    }

    public int finalizeHash(int hash) {
        int i = hash ^ hash >>> 16;
        i *= finalMixer1;
        i ^= i >>> 13;
        i *= finalMixer2;
        i ^= i >>> 16;
        return i;
    }

    public <T> int arrayHash(Object a) {
        int h = this.startHash(ScalaRunTime$.MODULE$.array_length(a) * seedArray);
        int c = hiddenMagicA;
        int k = hiddenMagicB;
        for (int j = 0; j < ScalaRunTime$.MODULE$.array_length(a); ++j) {
            h = this.extendHash(h, Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, j)), c, k);
            c = this.nextMagicA(c);
            k = this.nextMagicB(k);
        }
        return this.finalizeHash(h);
    }

    public int stringHash(String s2) {
        int h = this.startHash(s2.length() * seedString);
        int c = hiddenMagicA;
        int k = hiddenMagicB;
        int j = 0;
        while (j + 1 < s2.length()) {
            int i = (s2.charAt(j) << 16) + s2.charAt(j + 1);
            h = this.extendHash(h, i, c, k);
            c = this.nextMagicA(c);
            k = this.nextMagicB(k);
            j += 2;
        }
        if (j < s2.length()) {
            h = this.extendHash(h, Char$.MODULE$.char2int(s2.charAt(j)), c, k);
        }
        return this.finalizeHash(h);
    }

    public <T> int symmetricHash(IterableOnce<T> xs, int seed) {
        IntRef a = IntRef.create(0);
        IntRef b = IntRef.create(0);
        IntRef n = IntRef.create(0);
        IntRef c = IntRef.create(1);
        IterableOnce<T> iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(xs);
        IterableOnceExtensionMethods$.MODULE$.foreach$extension(iterableOnce, i -> {
            int h = Statics.anyHash(i);
            a$1.elem += h;
            b$1.elem ^= h;
            if (h != 0) {
                c$1.elem *= h;
            }
            ++n$1.elem;
        });
        int h = this.startHash(seed * n.elem);
        h = this.extendHash(h, a.elem, storedMagicA[0], storedMagicB[0]);
        h = this.extendHash(h, b.elem, storedMagicA[1], storedMagicB[1]);
        h = this.extendHash(h, c.elem, storedMagicA[2], storedMagicB[2]);
        return this.finalizeHash(h);
    }
}

