/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.DefaultOptimalSizeExploringResizer$;
import org.apache.pekko.routing.OptimalSizeExploringResizer;
import org.apache.pekko.routing.OptimalSizeExploringResizer$ResizeRecord$;
import org.apache.pekko.routing.OptimalSizeExploringResizer$UnderUtilizationStreak$;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$ScalaDurationOps$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.Duration$DurationIsOrdered$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class DefaultOptimalSizeExploringResizer
implements OptimalSizeExploringResizer,
Product,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int lowerBound;
    private final int upperBound;
    private final double chanceOfScalingDownWhenFull;
    private final Duration actionInterval;
    private final int numOfAdjacentSizesToConsiderDuringOptimization;
    private final double exploreStepSize;
    private final double downsizeRatio;
    private final Duration downsizeAfterUnderutilizedFor;
    private final double explorationProbability;
    private final double weightOfLatestMetric;
    @InternalApi
    private Map performanceLog;
    @InternalApi
    private OptimalSizeExploringResizer.ResizeRecord record;
    @InternalApi
    private boolean stopExploring;
    private final long actionInternalNanos;

    public static DefaultOptimalSizeExploringResizer apply(int n, int n2, double d, Duration duration, int n3, double d2, double d3, Duration duration2, double d4, double d5) {
        return DefaultOptimalSizeExploringResizer$.MODULE$.apply(n, n2, d, duration, n3, d2, d3, duration2, d4, d5);
    }

    public static DefaultOptimalSizeExploringResizer fromProduct(Product product) {
        return DefaultOptimalSizeExploringResizer$.MODULE$.fromProduct(product);
    }

    public static DefaultOptimalSizeExploringResizer unapply(DefaultOptimalSizeExploringResizer defaultOptimalSizeExploringResizer) {
        return DefaultOptimalSizeExploringResizer$.MODULE$.unapply(defaultOptimalSizeExploringResizer);
    }

    public static int $lessinit$greater$default$1() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$1();
    }

    public static int $lessinit$greater$default$2() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$3() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$3();
    }

    public static Duration $lessinit$greater$default$4() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$5() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$5();
    }

    public static double $lessinit$greater$default$6() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$7() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$7();
    }

    public static Duration $lessinit$greater$default$8() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$8();
    }

    public static double $lessinit$greater$default$9() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$9();
    }

    public static double $lessinit$greater$default$10() {
        return DefaultOptimalSizeExploringResizer$.MODULE$.$lessinit$greater$default$10();
    }

    public DefaultOptimalSizeExploringResizer(int lowerBound, int upperBound, double chanceOfScalingDownWhenFull, Duration actionInterval, int numOfAdjacentSizesToConsiderDuringOptimization, double exploreStepSize, double downsizeRatio, Duration downsizeAfterUnderutilizedFor, double explorationProbability, double weightOfLatestMetric) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.chanceOfScalingDownWhenFull = chanceOfScalingDownWhenFull;
        this.actionInterval = actionInterval;
        this.numOfAdjacentSizesToConsiderDuringOptimization = numOfAdjacentSizesToConsiderDuringOptimization;
        this.exploreStepSize = exploreStepSize;
        this.downsizeRatio = downsizeRatio;
        this.downsizeAfterUnderutilizedFor = downsizeAfterUnderutilizedFor;
        this.explorationProbability = explorationProbability;
        this.weightOfLatestMetric = weightOfLatestMetric;
        this.performanceLog = Predef$.MODULE$.Map().empty();
        this.record = OptimalSizeExploringResizer$ResizeRecord$.MODULE$.apply(OptimalSizeExploringResizer$ResizeRecord$.MODULE$.$lessinit$greater$default$1(), OptimalSizeExploringResizer$ResizeRecord$.MODULE$.$lessinit$greater$default$2(), OptimalSizeExploringResizer$ResizeRecord$.MODULE$.$lessinit$greater$default$3(), OptimalSizeExploringResizer$ResizeRecord$.MODULE$.$lessinit$greater$default$4());
        this.stopExploring = false;
        this.checkParamAsPositiveNum(Int$.MODULE$.int2double(lowerBound), "lowerBound");
        this.checkParamAsPositiveNum(Int$.MODULE$.int2double(upperBound), "upperBound");
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("upperBound must be >= lowerBound, was: [%s] < [%s]"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(upperBound), BoxesRunTime.boxToInteger(lowerBound)})));
        }
        this.checkParamLowerBound(Int$.MODULE$.int2double(numOfAdjacentSizesToConsiderDuringOptimization), 2.0, "numOfAdjacentSizesToConsiderDuringOptimization");
        this.checkParamAsProbability(chanceOfScalingDownWhenFull, "chanceOfScalingDownWhenFull");
        this.checkParamAsPositiveNum(Int$.MODULE$.int2double(numOfAdjacentSizesToConsiderDuringOptimization), "numOfAdjacentSizesToConsiderDuringOptimization");
        this.checkParamAsPositiveNum(exploreStepSize, "exploreStepSize");
        this.checkParamAsPositiveNum(downsizeRatio, "downsizeRatio");
        this.checkParamAsProbability(explorationProbability, "explorationProbability");
        this.checkParamAsProbability(weightOfLatestMetric, "weightOfLatestMetric");
        this.actionInternalNanos = actionInterval.toNanos();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.lowerBound());
        n = Statics.mix(n, this.upperBound());
        n = Statics.mix(n, Statics.doubleHash(this.chanceOfScalingDownWhenFull()));
        n = Statics.mix(n, Statics.anyHash(this.actionInterval()));
        n = Statics.mix(n, this.numOfAdjacentSizesToConsiderDuringOptimization());
        n = Statics.mix(n, Statics.doubleHash(this.exploreStepSize()));
        n = Statics.mix(n, Statics.doubleHash(this.downsizeRatio()));
        n = Statics.mix(n, Statics.anyHash(this.downsizeAfterUnderutilizedFor()));
        n = Statics.mix(n, Statics.doubleHash(this.explorationProbability()));
        n = Statics.mix(n, Statics.doubleHash(this.weightOfLatestMetric()));
        return Statics.finalizeHash(n, 10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DefaultOptimalSizeExploringResizer)) return false;
        DefaultOptimalSizeExploringResizer defaultOptimalSizeExploringResizer = (DefaultOptimalSizeExploringResizer)object;
        if (this.chanceOfScalingDownWhenFull() != defaultOptimalSizeExploringResizer.chanceOfScalingDownWhenFull()) return false;
        if (this.numOfAdjacentSizesToConsiderDuringOptimization() != defaultOptimalSizeExploringResizer.numOfAdjacentSizesToConsiderDuringOptimization()) return false;
        if (this.exploreStepSize() != defaultOptimalSizeExploringResizer.exploreStepSize()) return false;
        if (this.downsizeRatio() != defaultOptimalSizeExploringResizer.downsizeRatio()) return false;
        if (this.explorationProbability() != defaultOptimalSizeExploringResizer.explorationProbability()) return false;
        if (this.weightOfLatestMetric() != defaultOptimalSizeExploringResizer.weightOfLatestMetric()) return false;
        if (this.lowerBound() != defaultOptimalSizeExploringResizer.lowerBound()) return false;
        if (this.upperBound() != defaultOptimalSizeExploringResizer.upperBound()) return false;
        Duration duration = this.actionInterval();
        Duration duration2 = defaultOptimalSizeExploringResizer.actionInterval();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!duration.equals(duration2)) return false;
        Duration duration3 = this.downsizeAfterUnderutilizedFor();
        Duration duration4 = defaultOptimalSizeExploringResizer.downsizeAfterUnderutilizedFor();
        if (duration3 == null) {
            if (duration4 != null) {
                return false;
            }
        } else if (!duration3.equals(duration4)) return false;
        if (!defaultOptimalSizeExploringResizer.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof DefaultOptimalSizeExploringResizer;
    }

    @Override
    public int productArity() {
        return 10;
    }

    @Override
    public String productPrefix() {
        return "DefaultOptimalSizeExploringResizer";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger(this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger(this._2());
            }
            case 2: {
                return BoxesRunTime.boxToDouble(this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return BoxesRunTime.boxToInteger(this._5());
            }
            case 5: {
                return BoxesRunTime.boxToDouble(this._6());
            }
            case 6: {
                return BoxesRunTime.boxToDouble(this._7());
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return BoxesRunTime.boxToDouble(this._9());
            }
            case 9: {
                return BoxesRunTime.boxToDouble(this._10());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "lowerBound";
            }
            case 1: {
                return "upperBound";
            }
            case 2: {
                return "chanceOfScalingDownWhenFull";
            }
            case 3: {
                return "actionInterval";
            }
            case 4: {
                return "numOfAdjacentSizesToConsiderDuringOptimization";
            }
            case 5: {
                return "exploreStepSize";
            }
            case 6: {
                return "downsizeRatio";
            }
            case 7: {
                return "downsizeAfterUnderutilizedFor";
            }
            case 8: {
                return "explorationProbability";
            }
            case 9: {
                return "weightOfLatestMetric";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public int lowerBound() {
        return this.lowerBound;
    }

    public int upperBound() {
        return this.upperBound;
    }

    public double chanceOfScalingDownWhenFull() {
        return this.chanceOfScalingDownWhenFull;
    }

    public Duration actionInterval() {
        return this.actionInterval;
    }

    public int numOfAdjacentSizesToConsiderDuringOptimization() {
        return this.numOfAdjacentSizesToConsiderDuringOptimization;
    }

    public double exploreStepSize() {
        return this.exploreStepSize;
    }

    public double downsizeRatio() {
        return this.downsizeRatio;
    }

    public Duration downsizeAfterUnderutilizedFor() {
        return this.downsizeAfterUnderutilizedFor;
    }

    public double explorationProbability() {
        return this.explorationProbability;
    }

    public double weightOfLatestMetric() {
        return this.weightOfLatestMetric;
    }

    public Map<Object, Duration> performanceLog() {
        return this.performanceLog;
    }

    public void performanceLog_$eq(Map<Object, Duration> x$1) {
        this.performanceLog = x$1;
    }

    public OptimalSizeExploringResizer.ResizeRecord record() {
        return this.record;
    }

    public void record_$eq(OptimalSizeExploringResizer.ResizeRecord x$1) {
        this.record = x$1;
    }

    public boolean stopExploring() {
        return this.stopExploring;
    }

    public void stopExploring_$eq(boolean x$1) {
        this.stopExploring = x$1;
    }

    private ThreadLocalRandom random() {
        return ThreadLocalRandom.current();
    }

    private void checkParamAsProbability(double value, String paramName) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(47).append(paramName).append(" must be between 0 and 1 (inclusive), was: [%s]").toString()), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(value)})));
        }
    }

    private void checkParamAsPositiveNum(double value, String paramName) {
        this.checkParamLowerBound(value, 0.0, paramName);
    }

    private void checkParamLowerBound(double value, double lowerBound, String paramName) {
        if (value < lowerBound) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(23).append(paramName).append(" must be >= ").append(lowerBound).append(", was: [%s]").toString()), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(value)})));
        }
    }

    @Override
    public boolean isTimeForResize(long messageCounter) {
        return System.nanoTime() > this.record().checkTime() + this.actionInternalNanos;
    }

    @Override
    public void reportMessageCount(IndexedSeq<Routee> currentRoutees, long messageCounter) {
        Tuple2<Map<Object, Duration>, OptimalSizeExploringResizer.ResizeRecord> tuple2 = this.updatedStats(currentRoutees, messageCounter);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map<Object, Duration> newPerfLog = tuple2._1();
        OptimalSizeExploringResizer.ResizeRecord newRecord = tuple2._2();
        Tuple2<Map<Object, Duration>, OptimalSizeExploringResizer.ResizeRecord> tuple22 = Tuple2$.MODULE$.apply(newPerfLog, newRecord);
        Map<Object, Duration> newPerfLog2 = tuple22._1();
        OptimalSizeExploringResizer.ResizeRecord newRecord2 = tuple22._2();
        this.performanceLog_$eq(newPerfLog2);
        this.record_$eq(newRecord2);
    }

    public Tuple2<Map<Object, Duration>, OptimalSizeExploringResizer.ResizeRecord> updatedStats(IndexedSeq<Routee> currentRoutees, long messageCounter) {
        Map map;
        None$ newUnderutilizationStreak;
        LocalDateTime now = LocalDateTime.now();
        int currentSize = currentRoutees.length();
        IndexedSeq messagesInRoutees = (IndexedSeq)currentRoutees.map((Function1<Routee, int> & Serializable)x$1 -> {
            ActorRefRoutee actorRefRoutee;
            ActorRef actorRef;
            Routee routee = x$1;
            if (routee instanceof ActorRefRoutee && (actorRef = (actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee))._1()) instanceof ActorRefWithCell) {
                ActorRefWithCell a = (ActorRefWithCell)actorRef;
                Cell cell = a.underlying();
                if (cell instanceof ActorCell) {
                    ActorCell cell2 = (ActorCell)cell;
                    return cell2.mailbox().numberOfMessages() + (cell2.currentMessage() != null ? 1 : 0);
                }
                Cell cell3 = cell;
                return cell3.numberOfMessages();
            }
            return 0;
        });
        int totalQueueLength = BoxesRunTime.unboxToInt(messagesInRoutees.sum(Numeric$IntIsIntegral$.MODULE$));
        int utilized = messagesInRoutees.count(_$1 -> _$1 > 0);
        boolean fullyUtilized = utilized == currentSize;
        Option option = newUnderutilizationStreak = fullyUtilized ? None$.MODULE$ : Some$.MODULE$.apply(OptimalSizeExploringResizer$UnderUtilizationStreak$.MODULE$.apply((LocalDateTime)this.record().underutilizationStreak().fold(() -> DefaultOptimalSizeExploringResizer.$anonfun$3(now), (Function1<OptimalSizeExploringResizer.UnderUtilizationStreak, LocalDateTime> & Serializable)_$2 -> _$2.start()), Math.max(BoxesRunTime.unboxToInt(this.record().underutilizationStreak().fold(DefaultOptimalSizeExploringResizer::$anonfun$5, (Function1<OptimalSizeExploringResizer.UnderUtilizationStreak, int> & Serializable)_$3 -> _$3.highestUtilization())), utilized)));
        if (fullyUtilized && this.record().underutilizationStreak().isEmpty() && this.record().checkTime() > 0L) {
            long totalMessageReceived = messageCounter - this.record().messageCount();
            int queueSizeChange = this.record().totalQueueLength() - totalQueueLength;
            long totalProcessed = (long)queueSizeChange + totalMessageReceived;
            if (totalProcessed > 0L) {
                FiniteDuration duration = Duration$.MODULE$.fromNanos(System.nanoTime() - this.record().checkTime());
                FiniteDuration last = duration.$div(totalProcessed);
                Duration toUpdate = (Duration)this.performanceLog().get(BoxesRunTime.boxToInteger(currentSize)).fold(() -> DefaultOptimalSizeExploringResizer.$anonfun$7(last), (Function1<Duration, Duration> & Serializable)oldSpeed -> oldSpeed.$times(1.0 - this.weightOfLatestMetric()).$plus(last.$times(this.weightOfLatestMetric())));
                Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(currentSize));
                map = (Map)this.performanceLog().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, toUpdate));
            } else {
                map = this.performanceLog();
            }
        } else {
            map = this.performanceLog();
        }
        Map newPerformanceLog = map;
        OptimalSizeExploringResizer.ResizeRecord newRecord = this.record().copy(newUnderutilizationStreak, messageCounter, totalQueueLength, System.nanoTime());
        return Tuple2$.MODULE$.apply(newPerformanceLog, newRecord);
    }

    @Override
    public int resize(IndexedSeq<Routee> currentRoutees) {
        int n;
        int currentSize = currentRoutees.length();
        LocalDateTime now = LocalDateTime.now();
        if (BoxesRunTime.unboxToBoolean(this.record().underutilizationStreak().fold(DefaultOptimalSizeExploringResizer::$anonfun$9, (Function1<OptimalSizeExploringResizer.UnderUtilizationStreak, boolean> & Serializable)_$4 -> _$4.start().isBefore(now.minus(JavaDurationConverters$ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps(this.downsizeAfterUnderutilizedFor()))))))) {
            int downsizeTo = (int)((double)this.record().underutilizationStreak().get().highestUtilization() * this.downsizeRatio());
            n = Math.min(downsizeTo - currentSize, 0);
        } else {
            n = this.performanceLog().isEmpty() || this.record().underutilizationStreak().isDefined() ? 0 : (!this.stopExploring() && this.random().nextDouble() < this.explorationProbability() ? this.explore(currentSize) : this.optimize(currentSize));
        }
        int proposedChange = n;
        return Math.max(this.lowerBound(), Math.min(proposedChange + currentSize, this.upperBound())) - currentSize;
    }

    private int optimize(int currentSize) {
        Seq<Object> sizes = this.performanceLog().keys().toSeq();
        int numOfSizesEachSide = this.numOfAdjacentSizesToConsiderDuringOptimization() / 2;
        int leftBoundary = BoxesRunTime.unboxToInt(((IterableOps)((IterableOps)((SeqOps)sizes.filter(_$5 -> _$5 < currentSize)).sortBy(DefaultOptimalSizeExploringResizer.adjacency$1(currentSize), Ordering$Int$.MODULE$)).take(numOfSizesEachSide)).lastOption().getOrElse(() -> DefaultOptimalSizeExploringResizer.$anonfun$12(currentSize)));
        int rightBoundary = BoxesRunTime.unboxToInt(((IterableOps)((IterableOps)((SeqOps)sizes.filter(_$6 -> _$6 >= currentSize)).sortBy(DefaultOptimalSizeExploringResizer.adjacency$1(currentSize), Ordering$Int$.MODULE$)).take(numOfSizesEachSide)).lastOption().getOrElse(() -> DefaultOptimalSizeExploringResizer.$anonfun$14(currentSize)));
        Map adjacentDispatchWaits = (Map)this.performanceLog().filter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int size = BoxesRunTime.unboxToInt(tuple2._1());
                return size >= leftBoundary && size <= rightBoundary;
            }
            throw new MatchError(tuple2);
        });
        int optimalSize = BoxesRunTime.unboxToInt(((Tuple2)adjacentDispatchWaits.minBy((Function1<Tuple2, Duration> & Serializable)_$7 -> (Duration)_$7._2(), Duration$DurationIsOrdered$.MODULE$))._1());
        double movement = (double)(optimalSize - currentSize) / 2.0;
        if (movement < 0.0) {
            return (int)Math.floor(movement);
        }
        return (int)Math.ceil(movement);
    }

    private int explore(int currentSize) {
        int change = Math.max(1, this.random().nextInt((int)Math.ceil((double)currentSize * this.exploreStepSize())));
        if (this.random().nextDouble() < this.chanceOfScalingDownWhenFull()) {
            return -change;
        }
        return change;
    }

    public DefaultOptimalSizeExploringResizer copy(int lowerBound, int upperBound, double chanceOfScalingDownWhenFull, Duration actionInterval, int numOfAdjacentSizesToConsiderDuringOptimization, double exploreStepSize, double downsizeRatio, Duration downsizeAfterUnderutilizedFor, double explorationProbability, double weightOfLatestMetric) {
        return new DefaultOptimalSizeExploringResizer(lowerBound, upperBound, chanceOfScalingDownWhenFull, actionInterval, numOfAdjacentSizesToConsiderDuringOptimization, exploreStepSize, downsizeRatio, downsizeAfterUnderutilizedFor, explorationProbability, weightOfLatestMetric);
    }

    public int copy$default$1() {
        return this.lowerBound();
    }

    public int copy$default$2() {
        return this.upperBound();
    }

    public double copy$default$3() {
        return this.chanceOfScalingDownWhenFull();
    }

    public Duration copy$default$4() {
        return this.actionInterval();
    }

    public int copy$default$5() {
        return this.numOfAdjacentSizesToConsiderDuringOptimization();
    }

    public double copy$default$6() {
        return this.exploreStepSize();
    }

    public double copy$default$7() {
        return this.downsizeRatio();
    }

    public Duration copy$default$8() {
        return this.downsizeAfterUnderutilizedFor();
    }

    public double copy$default$9() {
        return this.explorationProbability();
    }

    public double copy$default$10() {
        return this.weightOfLatestMetric();
    }

    public int _1() {
        return this.lowerBound();
    }

    public int _2() {
        return this.upperBound();
    }

    public double _3() {
        return this.chanceOfScalingDownWhenFull();
    }

    public Duration _4() {
        return this.actionInterval();
    }

    public int _5() {
        return this.numOfAdjacentSizesToConsiderDuringOptimization();
    }

    public double _6() {
        return this.exploreStepSize();
    }

    public double _7() {
        return this.downsizeRatio();
    }

    public Duration _8() {
        return this.downsizeAfterUnderutilizedFor();
    }

    public double _9() {
        return this.explorationProbability();
    }

    public double _10() {
        return this.weightOfLatestMetric();
    }

    private static final LocalDateTime $anonfun$3(LocalDateTime now$1) {
        return now$1;
    }

    private static final int $anonfun$5() {
        return 0;
    }

    private static final Duration $anonfun$7(Duration last$1) {
        return last$1;
    }

    private static final boolean $anonfun$9() {
        return false;
    }

    private static final Function1 adjacency$1(int currentSize$1) {
        return size -> Math.abs(currentSize$1 - size);
    }

    private static final int $anonfun$12(int currentSize$4) {
        return currentSize$4;
    }

    private static final int $anonfun$14(int currentSize$6) {
        return currentSize$6;
    }
}

