/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.ActorSelectionRoutee;
import org.apache.pekko.routing.ActorSelectionRoutee$;
import org.apache.pekko.routing.ConsistentRoutee$;
import org.apache.pekko.routing.Routee;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ConsistentRoutee
implements Product,
Serializable {
    private final Routee routee;
    private final Address selfAddress;

    public static ConsistentRoutee apply(Routee routee, Address address) {
        return ConsistentRoutee$.MODULE$.apply(routee, address);
    }

    public static ConsistentRoutee fromProduct(Product product) {
        return ConsistentRoutee$.MODULE$.fromProduct(product);
    }

    public static ConsistentRoutee unapply(ConsistentRoutee consistentRoutee) {
        return ConsistentRoutee$.MODULE$.unapply(consistentRoutee);
    }

    public ConsistentRoutee(Routee routee, Address selfAddress) {
        this.routee = routee;
        this.selfAddress = selfAddress;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConsistentRoutee)) return false;
        ConsistentRoutee consistentRoutee = (ConsistentRoutee)object;
        Routee routee = this.routee();
        Routee routee2 = consistentRoutee.routee();
        if (routee == null) {
            if (routee2 != null) {
                return false;
            }
        } else if (!routee.equals(routee2)) return false;
        Address address = this.selfAddress();
        Address address2 = consistentRoutee.selfAddress();
        if (address == null) {
            if (address2 == null) return true;
            return false;
        } else {
            if (!((Object)address).equals(address2)) return false;
            return true;
        }
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof ConsistentRoutee;
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public String productPrefix() {
        return "ConsistentRoutee";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "routee";
        }
        if (1 == n2) {
            return "selfAddress";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public Routee routee() {
        return this.routee;
    }

    public Address selfAddress() {
        return this.selfAddress;
    }

    public String toString() {
        Routee routee = this.routee();
        if (routee instanceof ActorRefRoutee) {
            ActorRef actorRef;
            ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee);
            ActorRef ref = actorRef = actorRefRoutee._1();
            return this.toStringWithfullAddress(ref.path());
        }
        if (routee instanceof ActorSelectionRoutee) {
            ActorSelection actorSelection;
            ActorSelectionRoutee actorSelectionRoutee = ActorSelectionRoutee$.MODULE$.unapply((ActorSelectionRoutee)routee);
            ActorSelection sel = actorSelection = actorSelectionRoutee._1();
            return new StringBuilder(0).append(this.toStringWithfullAddress(sel.anchorPath())).append(sel.pathString()).toString();
        }
        Routee other = routee;
        return other.toString();
    }

    private String toStringWithfullAddress(ActorPath path) {
        Address address = path.address();
        if (address != null) {
            Address address2 = Address$.MODULE$.unapply(address);
            String string2 = address2._1();
            String string3 = address2._2();
            Option<String> option = address2._3();
            Option<Object> option2 = address2._4();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return path.toStringWithAddress(this.selfAddress());
            }
        }
        return path.toString();
    }

    public ConsistentRoutee copy(Routee routee, Address selfAddress) {
        return new ConsistentRoutee(routee, selfAddress);
    }

    public Routee copy$default$1() {
        return this.routee();
    }

    public Address copy$default$2() {
        return this.selfAddress();
    }

    public Routee _1() {
        return this.routee();
    }

    public Address _2() {
        return this.selfAddress();
    }
}

