/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.routing.ConsistentHash$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public class ConsistentHash<T> {
    private final SortedMap<Object, T> nodes;
    private final int virtualNodesFactor;
    private final ClassTag<T> evidence$1;
    private final int[] nodeHashRing;
    private final Object nodeRing;

    public static <T> ConsistentHash<T> apply(Iterable<T> iterable, int n, ClassTag<T> classTag) {
        return ConsistentHash$.MODULE$.apply(iterable, n, classTag);
    }

    public static <T> ConsistentHash<T> create(java.lang.Iterable<T> iterable, int n) {
        return ConsistentHash$.MODULE$.create(iterable, n);
    }

    public ConsistentHash(SortedMap<Object, T> nodes, int virtualNodesFactor, ClassTag<T> evidence$1) {
        int[] nodeHashRing;
        Object object;
        block10: {
            Tuple2<Object, Object> tuple2;
            block9: {
                Seq nhr;
                Seq seq;
                block8: {
                    Tuple2 tuple22;
                    block7: {
                        this.nodes = nodes;
                        this.virtualNodesFactor = virtualNodesFactor;
                        this.evidence$1 = evidence$1;
                        if (virtualNodesFactor < 1) {
                            throw new IllegalArgumentException("virtualNodesFactor must be >= 1");
                        }
                        tuple22 = nodes.toSeq().unzip(Predef$.MODULE$.$conforms());
                        if (tuple22 == null) break block7;
                        Seq seq2 = (Seq)tuple22._1();
                        seq = (Seq)tuple22._2();
                        if (!(seq2 instanceof Seq)) break block7;
                        nhr = seq2;
                        if (seq instanceof Seq) break block8;
                    }
                    throw new MatchError(tuple22);
                }
                Seq nr = seq;
                Tuple2<Seq, Seq> tuple23 = Tuple2$.MODULE$.apply(nhr, nr);
                Seq nhr2 = tuple23._1();
                Seq nr2 = tuple23._2();
                tuple2 = Tuple2$.MODULE$.apply(nhr2.toArray(ClassTag$.MODULE$.apply(Integer.TYPE)), nr2.toArray(evidence$1));
                if (tuple2 == null) break block9;
                int[] nArray = (int[])tuple2._1();
                object = tuple2._2();
                if (!(nArray instanceof int[])) break block9;
                nodeHashRing = nArray;
                if (ScalaRunTime$.MODULE$.isArray(object, 1)) break block10;
            }
            throw new MatchError(tuple2);
        }
        Object nodeRing = object;
        Tuple2<int[], Object> tuple2 = Tuple2$.MODULE$.apply(nodeHashRing, nodeRing);
        this.nodeHashRing = tuple2._1();
        this.nodeRing = tuple2._2();
    }

    public int virtualNodesFactor() {
        return this.virtualNodesFactor;
    }

    public ConsistentHash<T> $colon$plus(T node) {
        int nodeHash = ConsistentHash$.MODULE$.org$apache$pekko$routing$ConsistentHash$$$hashFor(node.toString());
        return new ConsistentHash<T>((SortedMap)this.nodes.$plus$plus(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.virtualNodesFactor()).map((Function1<Object, Tuple2> & Serializable)r -> ConsistentHash.$colon$plus$$anonfun$1(nodeHash, node, BoxesRunTime.unboxToInt(r)))), this.virtualNodesFactor(), this.evidence$1);
    }

    public ConsistentHash<T> add(T node) {
        return this.$colon$plus(node);
    }

    public ConsistentHash<T> $colon$minus(T node) {
        int nodeHash = ConsistentHash$.MODULE$.org$apache$pekko$routing$ConsistentHash$$$hashFor(node.toString());
        return new ConsistentHash<T>((SortedMap)this.nodes.$minus$minus((IterableOnce<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.virtualNodesFactor()).map(r -> ConsistentHash$.MODULE$.org$apache$pekko$routing$ConsistentHash$$$concatenateNodeHash(nodeHash, r))), this.virtualNodesFactor(), this.evidence$1);
    }

    public ConsistentHash<T> remove(T node) {
        return this.$colon$minus(node);
    }

    private int idx(int i) {
        if (i >= 0) {
            return i;
        }
        int j = package$.MODULE$.abs(i + 1);
        if (j >= this.nodeHashRing.length) {
            return 0;
        }
        return j;
    }

    public T nodeFor(byte[] key2) {
        if (this.isEmpty()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Can't get node for [%s] from an empty node ring"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key2})));
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(this.nodeRing, this.idx(Arrays.binarySearch(this.nodeHashRing, ConsistentHash$.MODULE$.org$apache$pekko$routing$ConsistentHash$$$hashFor(key2))));
    }

    public T nodeFor(String key2) {
        if (this.isEmpty()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Can't get node for [%s] from an empty node ring"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key2})));
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(this.nodeRing, this.idx(Arrays.binarySearch(this.nodeHashRing, ConsistentHash$.MODULE$.org$apache$pekko$routing$ConsistentHash$$$hashFor(key2))));
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    private static final /* synthetic */ Tuple2 $colon$plus$$anonfun$1(int nodeHash$1, Object node$1, int r) {
        Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(ConsistentHash$.MODULE$.org$apache$pekko$routing$ConsistentHash$$$concatenateNodeHash(nodeHash$1, r)));
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, node$1);
    }
}

