/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.dispatch.BalancingDispatcherConfigurator;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.BalancingPool$;
import org.apache.pekko.routing.BalancingPoolDeploy$;
import org.apache.pekko.routing.BalancingRoutingLogic$;
import org.apache.pekko.routing.NoRouter$;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.Pool$;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.Router;
import org.apache.pekko.routing.RouterConfig;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BalancingPool
implements RouterConfig,
Pool,
Product {
    private static final long serialVersionUID = 1L;
    private final int nrOfInstances;
    private final SupervisorStrategy supervisorStrategy;
    private final String routerDispatcher;
    private final Option resizer;

    public static BalancingPool apply(int n, SupervisorStrategy supervisorStrategy, String string2) {
        return BalancingPool$.MODULE$.apply(n, supervisorStrategy, string2);
    }

    public static BalancingPool fromProduct(Product product) {
        return BalancingPool$.MODULE$.fromProduct(product);
    }

    public static BalancingPool unapply(BalancingPool balancingPool) {
        return BalancingPool$.MODULE$.unapply(balancingPool);
    }

    public static SupervisorStrategy $lessinit$greater$default$2() {
        return BalancingPool$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$3() {
        return BalancingPool$.MODULE$.$lessinit$greater$default$3();
    }

    public BalancingPool(int nrOfInstances, SupervisorStrategy supervisorStrategy, String routerDispatcher) {
        this.nrOfInstances = nrOfInstances;
        this.supervisorStrategy = supervisorStrategy;
        this.routerDispatcher = routerDispatcher;
        this.resizer = None$.MODULE$;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.nrOfInstances());
        n = Statics.mix(n, Statics.anyHash(this.supervisorStrategy()));
        n = Statics.mix(n, Statics.anyHash(this.routerDispatcher()));
        return Statics.finalizeHash(n, 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BalancingPool)) return false;
        BalancingPool balancingPool = (BalancingPool)object;
        if (this.nrOfInstances() != balancingPool.nrOfInstances()) return false;
        SupervisorStrategy supervisorStrategy = this.supervisorStrategy();
        SupervisorStrategy supervisorStrategy2 = balancingPool.supervisorStrategy();
        if (supervisorStrategy == null) {
            if (supervisorStrategy2 != null) {
                return false;
            }
        } else if (!supervisorStrategy.equals(supervisorStrategy2)) return false;
        String string2 = this.routerDispatcher();
        String string3 = balancingPool.routerDispatcher();
        if (string2 == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!string2.equals(string3)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof BalancingPool;
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public String productPrefix() {
        return "BalancingPool";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger(this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "nrOfInstances";
            }
            case 1: {
                return "supervisorStrategy";
            }
            case 2: {
                return "routerDispatcher";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public int nrOfInstances() {
        return this.nrOfInstances;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    @Override
    public String routerDispatcher() {
        return this.routerDispatcher;
    }

    public BalancingPool(Config config) {
        this(config.getInt("nr-of-instances"), BalancingPool$.MODULE$.$lessinit$greater$default$2(), BalancingPool$.MODULE$.$lessinit$greater$default$3());
    }

    public BalancingPool(int nr) {
        this(nr, BalancingPool$.MODULE$.$lessinit$greater$default$2(), BalancingPool$.MODULE$.$lessinit$greater$default$3());
    }

    @Override
    public Router createRouter(ActorSystem system) {
        return new Router(BalancingRoutingLogic$.MODULE$.apply());
    }

    public BalancingPool withSupervisorStrategy(SupervisorStrategy strategy) {
        return this.copy(this.copy$default$1(), strategy, this.copy$default$3());
    }

    public BalancingPool withDispatcher(String dispatcherId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), dispatcherId);
    }

    @Override
    public int nrOfInstances(ActorSystem sys) {
        return this.nrOfInstances();
    }

    @Override
    public Routee newRoutee(Props routeeProps, ActorContext context) {
        String rawDeployPath = ((IterableOnceOps)context.self().path().elements().drop(1)).mkString("/", "/", "");
        String deployPath = BalancingPoolDeploy$.MODULE$.invalidConfigKeyChars().foldLeft(rawDeployPath, (Function2<Object, Object, String> & Serializable)(replaced, c) -> ((String)replaced).replace(BoxesRunTime.unboxToChar(c), '_'));
        String dispatcherId = new StringBuilder(14).append("BalancingPool-").append(deployPath).toString();
        if (!BalancingPool.dispatchers$1(context).hasDispatcher(dispatcherId)) {
            String deployDispatcherConfigPath = new StringBuilder(39).append("pekko.actor.deployment.").append(deployPath).append(".pool-dispatcher").toString();
            Config systemConfig = context.system().settings().config();
            Config dispatcherConfig = context.system().dispatchers().config(dispatcherId, systemConfig.hasPath(deployDispatcherConfigPath) ? systemConfig.getConfig(deployDispatcherConfigPath) : ConfigFactory.empty());
            BalancingPool.dispatchers$1(context).registerConfigurator(dispatcherId, new BalancingDispatcherConfigurator(dispatcherConfig, BalancingPool.dispatchers$1(context).prerequisites()));
        }
        Props routeePropsWithDispatcher = routeeProps.withDispatcher(dispatcherId);
        return ActorRefRoutee$.MODULE$.apply(context.actorOf(routeePropsWithDispatcher));
    }

    @Override
    public RouterConfig withFallback(RouterConfig other) {
        RouterConfig routerConfig = other;
        NoRouter$ noRouter$ = NoRouter$.MODULE$;
        if (!(routerConfig != null ? !routerConfig.equals(noRouter$) : noRouter$ != null)) {
            return this;
        }
        RouterConfig routerConfig2 = other;
        if (routerConfig2 instanceof Pool) {
            Pool p = (Pool)routerConfig2;
            if (this.supervisorStrategy() == Pool$.MODULE$.defaultSupervisorStrategy() && p.supervisorStrategy() != Pool$.MODULE$.defaultSupervisorStrategy()) {
                return this.withSupervisorStrategy(p.supervisorStrategy());
            }
            return this;
        }
        return this;
    }

    @Override
    public Option<Resizer> resizer() {
        return this.resizer;
    }

    public BalancingPool copy(int nrOfInstances, SupervisorStrategy supervisorStrategy, String routerDispatcher) {
        return new BalancingPool(nrOfInstances, supervisorStrategy, routerDispatcher);
    }

    public int copy$default$1() {
        return this.nrOfInstances();
    }

    public SupervisorStrategy copy$default$2() {
        return this.supervisorStrategy();
    }

    public String copy$default$3() {
        return this.routerDispatcher();
    }

    public int _1() {
        return this.nrOfInstances();
    }

    public SupervisorStrategy _2() {
        return this.supervisorStrategy();
    }

    public String _3() {
        return this.routerDispatcher();
    }

    private static final Dispatchers dispatchers$1(ActorContext context$1) {
        return context$1.system().dispatchers();
    }
}

