/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import org.apache.pekko.Done;
import org.apache.pekko.actor.InvalidMessageException$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.pattern.StatusReply$;
import org.apache.pekko.pattern.StatusReply$ErrorMessage$;
import scala.MatchError;
import scala.Product;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NoStackTrace;

public final class StatusReply<T> {
    private final Try status;

    public static StatusReply<Done> Ack() {
        return StatusReply$.MODULE$.Ack();
    }

    public static StatusReply<Done> ack() {
        return StatusReply$.MODULE$.ack();
    }

    public static <T> StatusReply<T> error(String string2) {
        return StatusReply$.MODULE$.error(string2);
    }

    public static <T> StatusReply<T> error(Throwable throwable) {
        return StatusReply$.MODULE$.error(throwable);
    }

    @InternalApi
    public static <T> Future<T> flattenStatusFuture(Future<StatusReply<T>> future) {
        return StatusReply$.MODULE$.flattenStatusFuture(future);
    }

    public static <T> StatusReply<T> success(T t) {
        return StatusReply$.MODULE$.success(t);
    }

    public StatusReply(Try<T> status) {
        this.status = status;
        if (status == null) {
            throw InvalidMessageException$.MODULE$.apply("[null] is not an allowed status");
        }
    }

    private Try<T> status() {
        return this.status;
    }

    public T getValue() {
        return this.status().get();
    }

    public Throwable getError() {
        Try<T> try_ = this.status();
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return ex;
        }
        throw new IllegalArgumentException("Expected reply to be a failure, but was a success");
    }

    public boolean isError() {
        return this.status().isFailure();
    }

    public boolean isSuccess() {
        return this.status().isSuccess();
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof StatusReply) {
            StatusReply that = (StatusReply)object;
            Try<T> try_ = this.status();
            Try<T> try_2 = that.status();
            return !(try_ != null ? !try_.equals(try_2) : try_2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.status().hashCode();
    }

    public String toString() {
        Try<T> try_ = this.status();
        if (try_ instanceof Success) {
            Object t = ((Success)try_).value();
            return new StringBuilder(9).append("Success(").append(t).append(")").toString();
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return new StringBuilder(7).append("Error(").append(ex.getMessage()).append(")").toString();
        }
        throw new MatchError(try_);
    }

    public static final class ErrorMessage
    extends RuntimeException
    implements NoStackTrace,
    Product {
        private final String errorMessage;

        public static ErrorMessage apply(String string2) {
            return StatusReply$ErrorMessage$.MODULE$.apply(string2);
        }

        public static ErrorMessage fromProduct(Product product) {
            return StatusReply$ErrorMessage$.MODULE$.fromProduct(product);
        }

        public static ErrorMessage unapply(ErrorMessage errorMessage) {
            return StatusReply$ErrorMessage$.MODULE$.unapply(errorMessage);
        }

        public ErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            super(errorMessage);
            NoStackTrace.$init$(this);
        }

        @Override
        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ErrorMessage)) return false;
            ErrorMessage errorMessage = (ErrorMessage)object;
            String string2 = this.errorMessage();
            String string3 = errorMessage.errorMessage();
            if (string2 != null) {
                if (!string2.equals(string3)) return false;
                return true;
            }
            if (string3 == null) return true;
            return false;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ErrorMessage;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "ErrorMessage";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "errorMessage";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        private String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public String toString() {
            return this.errorMessage();
        }

        public ErrorMessage copy(String errorMessage) {
            return new ErrorMessage(errorMessage);
        }

        public String copy$default$1() {
            return this.errorMessage();
        }

        public String _1() {
            return this.errorMessage();
        }
    }
}

