/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import java.io.Serializable;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.pattern.BackoffSupervisor$;
import org.apache.pekko.pattern.RetrySupport$;
import org.apache.pekko.util.ConstantFun$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

public interface RetrySupport {
    public static Future retry$(RetrySupport $this, Function0 attempt, int attempts, ExecutionContext ec) {
        return $this.retry(attempt, attempts, ec);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, int attempts, ExecutionContext ec) {
        return RetrySupport$.MODULE$.org$apache$pekko$pattern$RetrySupport$$$retry(attempt, attempts, 0, ec);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, Function2 shouldRetry, int attempts, ExecutionContext ec) {
        return $this.retry(attempt, shouldRetry, attempts, ec);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, Function2<T, Throwable, Object> shouldRetry, int attempts, ExecutionContext ec) {
        return RetrySupport$.MODULE$.org$apache$pekko$pattern$RetrySupport$$$retry(attempt, shouldRetry, attempts, ConstantFun$.MODULE$.scalaAnyToNone(), 0, ec, null);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, int attempts, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, attempts, minBackoff, maxBackoff, randomFactor, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, int attempts, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, ExecutionContext ec, Scheduler scheduler) {
        return this.retry(attempt, RetrySupport$.org$apache$pekko$pattern$RetrySupport$$$retryOnException, attempts, minBackoff, maxBackoff, randomFactor, ec, scheduler);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, Function2 shouldRetry, int attempts, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, shouldRetry, attempts, minBackoff, maxBackoff, randomFactor, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, Function2<T, Throwable, Object> shouldRetry, int attempts, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, ExecutionContext ec, Scheduler scheduler) {
        Predef$.MODULE$.require(minBackoff != null, RetrySupport::retry$$anonfun$1);
        Predef$.MODULE$.require(maxBackoff != null, RetrySupport::retry$$anonfun$2);
        Predef$.MODULE$.require(minBackoff.$greater(Duration$.MODULE$.Zero()), RetrySupport::retry$$anonfun$3);
        Predef$.MODULE$.require(maxBackoff.$greater$eq(minBackoff), RetrySupport::retry$$anonfun$4);
        Predef$.MODULE$.require(0.0 <= randomFactor && randomFactor <= 1.0, RetrySupport::retry$$anonfun$5);
        return this.retry(attempt, shouldRetry, attempts, (Function1<Object, Option<FiniteDuration>>)(Function1<Object, Option> & Serializable)attempted -> Some$.MODULE$.apply(BackoffSupervisor$.MODULE$.calculateDelay(BoxesRunTime.unboxToInt(attempted), minBackoff, maxBackoff, randomFactor)), ec, scheduler);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, int attempts, FiniteDuration delay, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, attempts, delay, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, int attempts, FiniteDuration delay, ExecutionContext ec, Scheduler scheduler) {
        return this.retry(attempt, attempts, (Function1<Object, Option<FiniteDuration>>)(Function1<Object, Option> & Serializable)_$1 -> Some$.MODULE$.apply(delay), ec, scheduler);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, Function2 shouldRetry, int attempts, FiniteDuration delay, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, shouldRetry, attempts, delay, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, Function2<T, Throwable, Object> shouldRetry, int attempts, FiniteDuration delay, ExecutionContext ec, Scheduler scheduler) {
        return this.retry(attempt, shouldRetry, attempts, (Function1<Object, Option<FiniteDuration>>)(Function1<Object, Option> & Serializable)_$2 -> Some$.MODULE$.apply(delay), ec, scheduler);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, int attempts, Function1 delayFunction, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, attempts, delayFunction, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, int attempts, Function1<Object, Option<FiniteDuration>> delayFunction, ExecutionContext ec, Scheduler scheduler) {
        return RetrySupport$.MODULE$.org$apache$pekko$pattern$RetrySupport$$$retry(attempt, RetrySupport$.org$apache$pekko$pattern$RetrySupport$$$retryOnException, attempts, delayFunction, 0, ec, scheduler);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, Function2 shouldRetry, int attempts, Function1 delayFunction, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, shouldRetry, attempts, delayFunction, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, Function2<T, Throwable, Object> shouldRetry, int attempts, Function1<Object, Option<FiniteDuration>> delayFunction, ExecutionContext ec, Scheduler scheduler) {
        return RetrySupport$.MODULE$.org$apache$pekko$pattern$RetrySupport$$$retry(attempt, shouldRetry, attempts, delayFunction, 0, ec, scheduler);
    }

    private static Object retry$$anonfun$1() {
        return "Parameter minBackoff should not be null.";
    }

    private static Object retry$$anonfun$2() {
        return "Parameter maxBackoff should not be null.";
    }

    private static Object retry$$anonfun$3() {
        return "Parameter minBackoff must be > 0";
    }

    private static Object retry$$anonfun$4() {
        return "Parameter maxBackoff must be >= minBackoff";
    }

    private static Object retry$$anonfun$5() {
        return "randomFactor must be between 0.0 and 1.0";
    }
}

