/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import java.io.Serializable;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.pattern.RetrySupport;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.ConstantFun$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class RetrySupport$
implements RetrySupport,
Serializable {
    public static final Function2<Object, Throwable, Object> org$apache$pekko$pattern$RetrySupport$$$retryOnException;
    public static final RetrySupport$ MODULE$;

    private RetrySupport$() {
    }

    static {
        MODULE$ = new RetrySupport$();
        org$apache$pekko$pattern$RetrySupport$$$retryOnException = (Function2<Object, Throwable, boolean> & Serializable)(_$3, e) -> e != null;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RetrySupport$.class);
    }

    public <T> Future<T> org$apache$pekko$pattern$RetrySupport$$$retry(Function0<Future<T>> attempt, int maxAttempts, int attempted, ExecutionContext ec) {
        return this.org$apache$pekko$pattern$RetrySupport$$$retry(attempt, org$apache$pekko$pattern$RetrySupport$$$retryOnException, maxAttempts, ConstantFun$.MODULE$.scalaAnyToNone(), attempted, ec, null);
    }

    public <T> Future<T> org$apache$pekko$pattern$RetrySupport$$$retry(Function0<Future<T>> attempt, Function2<T, Throwable, Object> shouldRetry, int maxAttempts, Function1<Object, Option<FiniteDuration>> delayFunction, int attempted, ExecutionContext ec, Scheduler scheduler) {
        Predef$.MODULE$.require(attempt != null, RetrySupport$::retry$$anonfun$9);
        Predef$.MODULE$.require(maxAttempts >= 0, RetrySupport$::retry$$anonfun$10);
        Predef$.MODULE$.require(delayFunction != null, RetrySupport$::retry$$anonfun$11);
        Predef$.MODULE$.require(attempted >= 0, RetrySupport$::retry$$anonfun$12);
        if (maxAttempts - attempted > 0) {
            Future result = this.tryAttempt$1(attempt);
            if (result == null) {
                return result;
            }
            return result.transformWith((Function1<Try, Future> & Serializable)x$1 -> {
                Throwable e;
                Object value;
                Try try_ = x$1;
                if (try_ instanceof Success && BoxesRunTime.unboxToBoolean(shouldRetry.apply(value = ((Success)try_).value(), null))) {
                    return this.doRetry$1(delayFunction, attempt, shouldRetry, maxAttempts, ec, scheduler, attempted + 1);
                }
                if (try_ instanceof Failure && NonFatal$.MODULE$.apply(e = ((Failure)try_).exception()) && BoxesRunTime.unboxToBoolean(shouldRetry.apply(null, e))) {
                    return this.doRetry$1(delayFunction, attempt, shouldRetry, maxAttempts, ec, scheduler, attempted + 1);
                }
                return result;
            }, ec);
        }
        return this.tryAttempt$1(attempt);
    }

    private final Future tryAttempt$1(Function0 attempt$1) {
        Future future;
        try {
            future = (Future)attempt$1.apply();
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable exc = throwable3 = option.get();
                future = Future$.MODULE$.failed(exc);
            }
            throw throwable;
        }
        return future;
    }

    private static final Future doRetry$1$$anonfun$1(Function0 attempt$3, Function2 shouldRetry$2, int maxAttempts$2, Function1 delayFunction$2, int nextAttempt$1, ExecutionContext ec$2, Scheduler scheduler$2) {
        return MODULE$.org$apache$pekko$pattern$RetrySupport$$$retry(attempt$3, shouldRetry$2, maxAttempts$2, delayFunction$2, nextAttempt$1, ec$2, scheduler$2);
    }

    private final Future doRetry$1(Function1 delayFunction$1, Function0 attempt$2, Function2 shouldRetry$1, int maxAttempts$1, ExecutionContext ec$1, Scheduler scheduler$1, int nextAttempt) {
        Option option = (Option)delayFunction$1.apply(BoxesRunTime.boxToInteger(nextAttempt));
        if (option instanceof Some) {
            FiniteDuration delay = (FiniteDuration)((Some)option).value();
            if (delay.length() < 1L) {
                return this.org$apache$pekko$pattern$RetrySupport$$$retry(attempt$2, shouldRetry$1, maxAttempts$1, delayFunction$1, nextAttempt, ec$1, scheduler$1);
            }
            return package$.MODULE$.after(delay, scheduler$1, () -> RetrySupport$.doRetry$1$$anonfun$1(attempt$2, shouldRetry$1, maxAttempts$1, delayFunction$1, nextAttempt, ec$1, scheduler$1), ec$1);
        }
        if (None$.MODULE$.equals(option)) {
            return this.org$apache$pekko$pattern$RetrySupport$$$retry(attempt$2, shouldRetry$1, maxAttempts$1, delayFunction$1, nextAttempt, ec$1, scheduler$1);
        }
        if (option == null) {
            return Future$.MODULE$.failed(new IllegalArgumentException("The delayFunction of retry should not return null."));
        }
        throw new MatchError(option);
    }

    private static final Object retry$$anonfun$9() {
        return "Parameter attempt should not be null.";
    }

    private static final Object retry$$anonfun$10() {
        return "Parameter maxAttempts must >= 0.";
    }

    private static final Object retry$$anonfun$11() {
        return "Parameter delayFunction should not be null.";
    }

    private static final Object retry$$anonfun$12() {
        return "Parameter attempted must >= 0.";
    }
}

