/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import java.io.Serializable;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorCell$;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.DeadLetter$;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.InvalidMessageException$;
import org.apache.pekko.actor.LocalRef;
import org.apache.pekko.actor.MinimalActorRef;
import org.apache.pekko.actor.Status;
import org.apache.pekko.actor.Status$Failure$;
import org.apache.pekko.actor.Status$Success$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.Terminate;
import org.apache.pekko.dispatch.sysmsg.Unwatch;
import org.apache.pekko.dispatch.sysmsg.Unwatch$;
import org.apache.pekko.dispatch.sysmsg.Watch;
import org.apache.pekko.dispatch.sysmsg.Watch$;
import org.apache.pekko.pattern.AbstractPromiseActorRef;
import org.apache.pekko.pattern.PromiseActorRef$;
import org.apache.pekko.pattern.PromiseActorRef$Registering$;
import org.apache.pekko.pattern.PromiseActorRef$Stopped$;
import org.apache.pekko.pattern.PromiseActorRef$StoppedWithPath$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Unsafe;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public final class PromiseActorRef
extends InternalActorRef
implements LocalRef,
MinimalActorRef {
    private final ActorRefProvider provider;
    private final Promise result;
    private final String refPathPrefix;
    private volatile String messageClassName;
    private volatile Object _stateDoNotCallMeDirectly;
    private volatile Set<ActorRef> _watchedByDoNotCallMeDirectly;

    public static PromiseActorRef apply(ActorRefProvider actorRefProvider, Timeout timeout, Object object, String string2, String string3, ActorRef actorRef, Function1<String, Throwable> function1) {
        return PromiseActorRef$.MODULE$.apply(actorRefProvider, timeout, object, string2, string3, actorRef, function1);
    }

    public static ActorRef apply$default$6() {
        return PromiseActorRef$.MODULE$.apply$default$6();
    }

    public static Function1<String, Throwable> apply$default$7() {
        return PromiseActorRef$.MODULE$.apply$default$7();
    }

    public PromiseActorRef(ActorRefProvider provider, Promise<Object> result, String _mcn, String refPathPrefix) {
        this.provider = provider;
        this.result = result;
        this.refPathPrefix = refPathPrefix;
        this.messageClassName = _mcn;
        this._watchedByDoNotCallMeDirectly = ActorCell$.MODULE$.emptyActorRefSet();
    }

    @Override
    public ActorRefProvider provider() {
        return this.provider;
    }

    public Promise<Object> result() {
        return this.result;
    }

    public String messageClassName() {
        return this.messageClassName;
    }

    public void messageClassName_$eq(String x$1) {
        this.messageClassName = x$1;
    }

    private Set<ActorRef> _preventPrivateUnusedErasure() {
        return this._watchedByDoNotCallMeDirectly;
    }

    private Set<ActorRef> watchedBy() {
        return (Set)Unsafe.instance.getObjectVolatile(this, AbstractPromiseActorRef.watchedByOffset);
    }

    private boolean updateWatchedBy(Set<ActorRef> oldWatchedBy, Set<ActorRef> newWatchedBy) {
        return Unsafe.instance.compareAndSwapObject(this, AbstractPromiseActorRef.watchedByOffset, oldWatchedBy, newWatchedBy);
    }

    private final boolean addWatcher(ActorRef watcher) {
        Set<ActorRef> set;
        Set<ActorRef> other;
        do {
            if ((set = this.watchedBy()) != null) continue;
            return false;
        } while (!this.updateWatchedBy(other = set, (Set)other.$plus(watcher)));
        return true;
    }

    private final void remWatcher(ActorRef watcher) {
        Set<ActorRef> set;
        Set<ActorRef> other;
        do {
            if ((set = this.watchedBy()) != null) continue;
            return;
        } while (!this.updateWatchedBy(other = set, (Set)other.$minus(watcher)));
    }

    private final Set<ActorRef> clearWatchers() {
        Set<ActorRef> set;
        Set<ActorRef> other;
        do {
            if ((set = this.watchedBy()) != null) continue;
            return ActorCell$.MODULE$.emptyActorRefSet();
        } while (!this.updateWatchedBy(other = set, null));
        return other;
    }

    private Object state() {
        return Unsafe.instance.getObjectVolatile(this, AbstractPromiseActorRef.stateOffset);
    }

    private boolean updateState(Object oldState, Object newState) {
        return Unsafe.instance.compareAndSwapObject(this, AbstractPromiseActorRef.stateOffset, oldState, newState);
    }

    private void setState(Object newState) {
        Unsafe.instance.putObjectVolatile(this, AbstractPromiseActorRef.stateOffset, newState);
    }

    @Override
    public InternalActorRef getParent() {
        return this.provider().tempContainer();
    }

    @Override
    public ActorPath path() {
        Object object;
        while (true) {
            if ((object = this.state()) == null) {
                ActorPath actorPath;
                if (!this.updateState(null, PromiseActorRef$Registering$.MODULE$)) continue;
                ActorPath p = null;
                try {
                    p = this.provider().tempPath(this.refPathPrefix);
                    this.provider().registerTempActor(this, p);
                    actorPath = p;
                }
                catch (Throwable throwable) {
                    this.setState(p);
                    throw throwable;
                }
                this.setState(p);
                return actorPath;
            }
            if (object instanceof ActorPath) {
                ActorPath p = (ActorPath)object;
                return p;
            }
            if (object instanceof StoppedWithPath) {
                ActorPath actorPath;
                StoppedWithPath stoppedWithPath = PromiseActorRef$StoppedWithPath$.MODULE$.unapply((StoppedWithPath)object);
                ActorPath p = actorPath = stoppedWithPath._1();
                return p;
            }
            if (PromiseActorRef$Stopped$.MODULE$.equals(object)) {
                this.updateState(PromiseActorRef$Stopped$.MODULE$, PromiseActorRef$StoppedWithPath$.MODULE$.apply(this.provider().tempPath(this.refPathPrefix)));
                continue;
            }
            if (!PromiseActorRef$Registering$.MODULE$.equals(object)) break;
        }
        Object unexpected = object;
        throw new IllegalStateException(new StringBuilder(18).append("Unexpected state: ").append(unexpected).toString());
    }

    @Override
    public void $bang(Object message, ActorRef sender) {
        boolean alreadyCompleted;
        Try try_;
        Object object = this.state();
        if (PromiseActorRef$Stopped$.MODULE$.equals(object) || object instanceof StoppedWithPath) {
            this.provider().deadLetters().$bang(DeadLetter$.MODULE$.apply(message, sender == Actor$.MODULE$.noSender() ? this.provider().deadLetters() : sender, this), sender);
            this.onComplete(message, true);
            return;
        }
        if (message == null) {
            throw InvalidMessageException$.MODULE$.apply("Message is null");
        }
        Object object2 = message;
        if (object2 instanceof Status.Success) {
            Object object3;
            Status.Success success = Status$Success$.MODULE$.unapply((Status.Success)object2);
            Object r = object3 = success._1();
            try_ = Success$.MODULE$.apply(r);
        } else if (object2 instanceof Status.Failure) {
            Throwable throwable;
            Status.Failure failure = Status$Failure$.MODULE$.unapply((Status.Failure)object2);
            Throwable f = throwable = failure._1();
            try_ = Failure$.MODULE$.apply(f);
        } else {
            Object other = object2;
            try_ = Success$.MODULE$.apply(other);
        }
        Success<Object> promiseResult = try_;
        boolean bl = alreadyCompleted = !this.result().tryComplete(promiseResult);
        if (alreadyCompleted) {
            this.provider().deadLetters().$bang(message, sender);
        }
        this.onComplete(message, alreadyCompleted);
    }

    @Override
    public ActorRef $bang$default$2(Object message) {
        return Actor$.MODULE$.noSender();
    }

    @Override
    public void sendSystemMessage(SystemMessage message) {
        SystemMessage systemMessage = message;
        if (systemMessage instanceof Terminate) {
            this.stop();
            return;
        }
        if (systemMessage instanceof DeathWatchNotification) {
            DeathWatchNotification deathWatchNotification = DeathWatchNotification$.MODULE$.unapply((DeathWatchNotification)systemMessage);
            ActorRef actorRef = deathWatchNotification._1();
            boolean bl = deathWatchNotification._2();
            boolean bl2 = deathWatchNotification._3();
            ActorRef a = actorRef;
            boolean ec = bl;
            boolean at = bl2;
            Terminated terminated = Terminated$.MODULE$.apply(a, ec, at);
            this.$bang(terminated, this.$bang$default$2(terminated));
            return;
        }
        if (systemMessage instanceof Watch) {
            Watch watch = Watch$.MODULE$.unapply((Watch)systemMessage);
            InternalActorRef internalActorRef = watch._1();
            InternalActorRef internalActorRef2 = watch._2();
            InternalActorRef watchee = internalActorRef;
            InternalActorRef watcher = internalActorRef2;
            InternalActorRef internalActorRef3 = watchee;
            PromiseActorRef promiseActorRef = this;
            if (!(internalActorRef3 != null ? !((Object)internalActorRef3).equals(promiseActorRef) : promiseActorRef != null)) {
                InternalActorRef internalActorRef4 = watcher;
                PromiseActorRef promiseActorRef2 = this;
                if (internalActorRef4 == null ? promiseActorRef2 != null : !((Object)internalActorRef4).equals(promiseActorRef2)) {
                    if (!this.addWatcher(watcher)) {
                        watcher.sendSystemMessage(DeathWatchNotification$.MODULE$.apply(watchee, true, false));
                        return;
                    }
                    return;
                }
            }
            System.err.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("BUG: illegal Watch(%s,%s) for %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{watchee, watcher, this})));
            return;
        }
        if (systemMessage instanceof Unwatch) {
            Unwatch unwatch = Unwatch$.MODULE$.unapply((Unwatch)systemMessage);
            ActorRef actorRef = unwatch._1();
            ActorRef actorRef2 = unwatch._2();
            ActorRef watchee = actorRef;
            ActorRef watcher = actorRef2;
            ActorRef actorRef3 = watchee;
            PromiseActorRef promiseActorRef = this;
            if (!(actorRef3 != null ? !((Object)actorRef3).equals(promiseActorRef) : promiseActorRef != null)) {
                ActorRef actorRef4 = watcher;
                PromiseActorRef promiseActorRef3 = this;
                if (actorRef4 == null ? promiseActorRef3 != null : !((Object)actorRef4).equals(promiseActorRef3)) {
                    this.remWatcher(watcher);
                    return;
                }
            }
            System.err.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("BUG: illegal Unwatch(%s,%s) for %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{watchee, watcher, this})));
            return;
        }
    }

    @Override
    public boolean isTerminated() {
        Object object = this.state();
        return PromiseActorRef$Stopped$.MODULE$.equals(object) || object instanceof StoppedWithPath;
        {
        }
    }

    @Override
    public void stop() {
        Object object;
        while (true) {
            if ((object = this.state()) == null) {
                if (!this.updateState(null, PromiseActorRef$Stopped$.MODULE$)) continue;
                this.ensureCompleted$1();
                return;
            }
            if (object instanceof ActorPath) {
                ActorPath p = (ActorPath)object;
                if (!this.updateState(p, PromiseActorRef$StoppedWithPath$.MODULE$.apply(p))) continue;
                try {
                    this.ensureCompleted$1();
                }
                finally {
                    this.provider().unregisterTempActor(p);
                }
                return;
            }
            if (PromiseActorRef$Stopped$.MODULE$.equals(object) || object instanceof StoppedWithPath) {
                return;
            }
            if (!PromiseActorRef$Registering$.MODULE$.equals(object)) break;
        }
        Object unexpected = object;
        throw new IllegalStateException(new StringBuilder(18).append("Unexpected state: ").append(unexpected).toString());
    }

    @InternalStableApi
    public Future<Object> ask(ActorSelection actorSel, Object message, Timeout timeout) {
        actorSel.tell(message, this);
        return this.result().future();
    }

    @InternalStableApi
    public Future<Object> ask(ActorRef actorRef, Object message, Timeout timeout) {
        actorRef.tell(message, this);
        return this.result().future();
    }

    @InternalStableApi
    public void onComplete(Object message, boolean alreadyCompleted) {
    }

    @InternalStableApi
    public void onTimeout(Timeout timeout) {
    }

    private final void ensureCompleted$1() {
        this.result().tryComplete(PromiseActorRef$.org$apache$pekko$pattern$PromiseActorRef$$$ActorStopResult);
        Set<ActorRef> watchers = this.clearWatchers();
        if (watchers.nonEmpty()) {
            watchers.foreach(watcher -> ((InternalActorRef)watcher).sendSystemMessage(DeathWatchNotification$.MODULE$.apply(this, true, false)));
            return;
        }
    }

    public static final class StoppedWithPath
    implements Product,
    Serializable {
        private final ActorPath path;

        public static StoppedWithPath apply(ActorPath actorPath) {
            return PromiseActorRef$StoppedWithPath$.MODULE$.apply(actorPath);
        }

        public static StoppedWithPath fromProduct(Product product) {
            return PromiseActorRef$StoppedWithPath$.MODULE$.fromProduct(product);
        }

        public static StoppedWithPath unapply(StoppedWithPath stoppedWithPath) {
            return PromiseActorRef$StoppedWithPath$.MODULE$.unapply(stoppedWithPath);
        }

        public StoppedWithPath(ActorPath path) {
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoppedWithPath)) return false;
            StoppedWithPath stoppedWithPath = (StoppedWithPath)object;
            ActorPath actorPath = this.path();
            ActorPath actorPath2 = stoppedWithPath.path();
            if (actorPath != null) {
                if (!actorPath.equals(actorPath2)) return false;
                return true;
            }
            if (actorPath2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof StoppedWithPath;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "StoppedWithPath";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorPath path() {
            return this.path;
        }

        public StoppedWithPath copy(ActorPath path) {
            return new StoppedWithPath(path);
        }

        public ActorPath copy$default$1() {
            return this.path();
        }

        public ActorPath _1() {
            return this.path();
        }
    }
}

