/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import com.typesafe.config.Config;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.pattern.CircuitBreaker;
import org.apache.pekko.pattern.CircuitBreakersRegistry$;
import org.apache.pekko.pattern.internal.CircuitBreakerTelemetry;
import org.apache.pekko.pattern.internal.CircuitBreakerTelemetryProvider$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public final class CircuitBreakersRegistry
implements Extension {
    private final ExtendedActorSystem system;
    private final ConcurrentHashMap<String, CircuitBreaker> breakers;
    private final Config config;
    private final Config defaultBreakerConfig;

    public static Extension apply(ActorSystem actorSystem) {
        return CircuitBreakersRegistry$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return CircuitBreakersRegistry$.MODULE$.apply(classicActorSystemProvider);
    }

    public static CircuitBreakersRegistry createExtension(ExtendedActorSystem extendedActorSystem) {
        return CircuitBreakersRegistry$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return CircuitBreakersRegistry$.MODULE$.lookup();
    }

    public CircuitBreakersRegistry(ExtendedActorSystem system) {
        this.system = system;
        this.breakers = new ConcurrentHashMap();
        this.config = system.settings().config().getConfig("pekko.circuit-breaker");
        this.defaultBreakerConfig = this.config.getConfig("default");
    }

    private CircuitBreaker createCircuitBreaker(String id) {
        Config breakerConfig = this.config.hasPath(id) ? this.config.getConfig(id).withFallback(this.defaultBreakerConfig) : this.defaultBreakerConfig;
        int maxFailures = breakerConfig.getInt("max-failures");
        FiniteDuration callTimeout = new package.DurationLong(package$.MODULE$.DurationLong(breakerConfig.getDuration("call-timeout", package$.MODULE$.MILLISECONDS()))).millis();
        FiniteDuration resetTimeout = new package.DurationLong(package$.MODULE$.DurationLong(breakerConfig.getDuration("reset-timeout", package$.MODULE$.MILLISECONDS()))).millis();
        FiniteDuration maxResetTimeout = new package.DurationLong(package$.MODULE$.DurationLong(breakerConfig.getDuration("max-reset-timeout", package$.MODULE$.MILLISECONDS()))).millis();
        double exponentialBackoffFactor = breakerConfig.getDouble("exponential-backoff");
        double randomFactor = breakerConfig.getDouble("random-factor");
        Set<String> allowExceptions = package$JavaConverters$.MODULE$.ListHasAsScala(breakerConfig.getStringList("exception-allowlist")).asScala().toSet();
        CircuitBreakerTelemetry telemetry = CircuitBreakerTelemetryProvider$.MODULE$.start(id, this.system);
        return new CircuitBreaker(this.system.scheduler(), maxFailures, callTimeout, resetTimeout, maxResetTimeout, exponentialBackoffFactor, randomFactor, allowExceptions, telemetry, this.system.dispatcher());
    }

    public CircuitBreaker get(String id2) {
        return this.breakers.computeIfAbsent(id2, id -> this.createCircuitBreaker((String)id));
    }
}

