/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.pattern.AbstractCircuitBreaker;
import org.apache.pekko.pattern.CircuitBreaker$;
import org.apache.pekko.pattern.CircuitBreaker$Closed$;
import org.apache.pekko.pattern.CircuitBreaker$HalfOpen$;
import org.apache.pekko.pattern.CircuitBreaker$Open$;
import org.apache.pekko.pattern.internal.CircuitBreakerNoopTelemetry$;
import org.apache.pekko.pattern.internal.CircuitBreakerTelemetry;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.FutureConverters$CompletionStageOps$;
import org.apache.pekko.util.FutureConverters$FutureOps$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.Unsafe;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

public class CircuitBreaker
extends AbstractCircuitBreaker {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(CircuitBreaker.class.getDeclaredField("Open$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(CircuitBreaker.class.getDeclaredField("HalfOpen$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CircuitBreaker.class.getDeclaredField("Closed$lzy1"));
    public final Scheduler org$apache$pekko$pattern$CircuitBreaker$$scheduler;
    public final int org$apache$pekko$pattern$CircuitBreaker$$maxFailures;
    public final FiniteDuration org$apache$pekko$pattern$CircuitBreaker$$callTimeout;
    private final FiniteDuration resetTimeout;
    public final FiniteDuration org$apache$pekko$pattern$CircuitBreaker$$maxResetTimeout;
    public final double org$apache$pekko$pattern$CircuitBreaker$$exponentialBackoffFactor;
    public final double org$apache$pekko$pattern$CircuitBreaker$$randomFactor;
    private final Set allowExceptions;
    private final CircuitBreakerTelemetry telemetry;
    public final ExecutionContext org$apache$pekko$pattern$CircuitBreaker$$executor;
    private volatile State _currentStateDoNotCallMeDirectly;
    private volatile FiniteDuration _currentResetTimeoutDoNotCallMeDirectly;
    public final TimeoutException org$apache$pekko$pattern$CircuitBreaker$$timeoutEx;
    private final CopyOnWriteArrayList<Consumer<Object>> callFailureListeners;
    private final CopyOnWriteArrayList<Consumer<Object>> callTimeoutListeners;
    private final CopyOnWriteArrayList<Runnable> callBreakerOpenListeners;
    private final CopyOnWriteArrayList<Consumer<Object>> successListeners;
    public final Function1<Try<?>, Object> org$apache$pekko$pattern$CircuitBreaker$$failureFn;
    private volatile Object Closed$lzy1;
    private volatile Object HalfOpen$lzy1;
    private volatile Object Open$lzy1;

    public static CircuitBreaker apply(Scheduler scheduler, int n, FiniteDuration finiteDuration, FiniteDuration finiteDuration2) {
        return CircuitBreaker$.MODULE$.apply(scheduler, n, finiteDuration, finiteDuration2);
    }

    public static CircuitBreaker apply(String string2, ExtendedActorSystem extendedActorSystem) {
        return CircuitBreaker$.MODULE$.apply(string2, extendedActorSystem);
    }

    public static CircuitBreaker create(Scheduler scheduler, int n, Duration duration, Duration duration2) {
        return CircuitBreaker$.MODULE$.create(scheduler, n, duration, duration2);
    }

    public static CircuitBreaker create(Scheduler scheduler, int n, FiniteDuration finiteDuration, FiniteDuration finiteDuration2) {
        return CircuitBreaker$.MODULE$.create(scheduler, n, finiteDuration, finiteDuration2);
    }

    public static CircuitBreaker lookup(String string2, ExtendedActorSystem extendedActorSystem) {
        return CircuitBreaker$.MODULE$.lookup(string2, extendedActorSystem);
    }

    public CircuitBreaker(Scheduler scheduler, int maxFailures, FiniteDuration callTimeout, FiniteDuration resetTimeout, FiniteDuration maxResetTimeout, double exponentialBackoffFactor, double randomFactor, Set<String> allowExceptions, CircuitBreakerTelemetry telemetry, ExecutionContext executor) {
        this.org$apache$pekko$pattern$CircuitBreaker$$scheduler = scheduler;
        this.org$apache$pekko$pattern$CircuitBreaker$$maxFailures = maxFailures;
        this.org$apache$pekko$pattern$CircuitBreaker$$callTimeout = callTimeout;
        this.resetTimeout = resetTimeout;
        this.org$apache$pekko$pattern$CircuitBreaker$$maxResetTimeout = maxResetTimeout;
        this.org$apache$pekko$pattern$CircuitBreaker$$exponentialBackoffFactor = exponentialBackoffFactor;
        this.org$apache$pekko$pattern$CircuitBreaker$$randomFactor = randomFactor;
        this.allowExceptions = allowExceptions;
        this.telemetry = telemetry;
        this.org$apache$pekko$pattern$CircuitBreaker$$executor = executor;
        Predef$.MODULE$.require(exponentialBackoffFactor >= 1.0, CircuitBreaker::$init$$$anonfun$1);
        Predef$.MODULE$.require(0.0 <= randomFactor && randomFactor <= 1.0, CircuitBreaker::$init$$$anonfun$2);
        this._currentStateDoNotCallMeDirectly = this.Closed();
        this._currentResetTimeoutDoNotCallMeDirectly = resetTimeout;
        this.org$apache$pekko$pattern$CircuitBreaker$$timeoutEx = new NoStackTrace(){
            {
                NoStackTrace.$init$(this);
            }

            public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                return super.fillInStackTrace();
            }
        };
        this.callFailureListeners = new CopyOnWriteArrayList();
        this.callTimeoutListeners = new CopyOnWriteArrayList();
        this.callBreakerOpenListeners = new CopyOnWriteArrayList();
        this.successListeners = new CopyOnWriteArrayList();
        CircuitBreakerTelemetry circuitBreakerTelemetry = telemetry;
        CircuitBreakerNoopTelemetry$ circuitBreakerNoopTelemetry$ = CircuitBreakerNoopTelemetry$.MODULE$;
        if (circuitBreakerTelemetry == null ? circuitBreakerNoopTelemetry$ != null : !circuitBreakerTelemetry.equals(circuitBreakerNoopTelemetry$)) {
            this.onOpen((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                CircuitBreaker.$init$$$anonfun$3(telemetry);
                return BoxedUnit.UNIT;
            });
            this.onHalfOpen((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                CircuitBreaker.$init$$$anonfun$4(telemetry);
                return BoxedUnit.UNIT;
            });
            this.onClose((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                CircuitBreaker.$init$$$anonfun$5(telemetry);
                return BoxedUnit.UNIT;
            });
            this.onCallBreakerOpen((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                CircuitBreaker.$init$$$anonfun$6(telemetry);
                return BoxedUnit.UNIT;
            });
            this.onCallTimeout(elapsedNanos -> telemetry.onCallTimeoutFailure(elapsedNanos));
            this.onCallFailure(elapsedNanos -> telemetry.onCallFailure(elapsedNanos));
            this.onCallSuccess(elapsedNanos -> telemetry.onCallSuccess(elapsedNanos));
        }
        this.org$apache$pekko$pattern$CircuitBreaker$$failureFn = (Function1<Try, boolean> & Serializable)x$1 -> {
            Throwable t;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                return false;
            }
            return !(try_ instanceof Failure) || !this.org$apache$pekko$pattern$CircuitBreaker$$isIgnoredException(t = ((Failure)try_).exception());
        };
    }

    public FiniteDuration resetTimeout() {
        return this.resetTimeout;
    }

    public Set<String> allowExceptions() {
        return this.allowExceptions;
    }

    public CircuitBreakerTelemetry telemetry() {
        return this.telemetry;
    }

    public CircuitBreaker(Scheduler scheduler, int maxFailures, FiniteDuration callTimeout, FiniteDuration resetTimeout, FiniteDuration maxResetTimeout, double exponentialBackoffFactor, double randomFactor, ExecutionContext executor) {
        this(scheduler, maxFailures, callTimeout, resetTimeout, maxResetTimeout, exponentialBackoffFactor, randomFactor, (Set<String>)Predef$.MODULE$.Set().empty(), CircuitBreakerNoopTelemetry$.MODULE$, executor);
    }

    public CircuitBreaker(ExecutionContext executor, Scheduler scheduler, int maxFailures, FiniteDuration callTimeout, FiniteDuration resetTimeout) {
        this(scheduler, maxFailures, callTimeout, resetTimeout, new package.DurationInt(package$.MODULE$.DurationInt(36500)).days(), 1.0, 0.0, executor);
    }

    public CircuitBreaker(ExecutionContext executor, Scheduler scheduler, int maxFailures, Duration callTimeout, Duration resetTimeout) {
        this(scheduler, maxFailures, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(callTimeout)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(resetTimeout)), new package.DurationInt(package$.MODULE$.DurationInt(36500)).days(), 1.0, 0.0, executor);
    }

    public CircuitBreaker(Scheduler scheduler, int maxFailures, FiniteDuration callTimeout, FiniteDuration resetTimeout, ExecutionContext executor) {
        this(scheduler, maxFailures, callTimeout, resetTimeout, new package.DurationInt(package$.MODULE$.DurationInt(36500)).days(), 1.0, 0.0, executor);
    }

    public CircuitBreaker(Scheduler scheduler, int maxFailures, FiniteDuration callTimeout, FiniteDuration resetTimeout, FiniteDuration maxResetTimeout, double exponentialBackoffFactor, ExecutionContext executor) {
        this(scheduler, maxFailures, callTimeout, resetTimeout, maxResetTimeout, exponentialBackoffFactor, 0.0, executor);
    }

    public CircuitBreaker withExponentialBackoff(FiniteDuration maxResetTimeout) {
        return new CircuitBreaker(this.org$apache$pekko$pattern$CircuitBreaker$$scheduler, this.org$apache$pekko$pattern$CircuitBreaker$$maxFailures, this.org$apache$pekko$pattern$CircuitBreaker$$callTimeout, this.resetTimeout(), maxResetTimeout, 2.0, this.org$apache$pekko$pattern$CircuitBreaker$$randomFactor, this.allowExceptions(), this.telemetry(), this.org$apache$pekko$pattern$CircuitBreaker$$executor);
    }

    public CircuitBreaker withExponentialBackoff(Duration maxResetTimeout) {
        return this.withExponentialBackoff(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(maxResetTimeout)));
    }

    public CircuitBreaker withRandomFactor(double randomFactor) {
        return new CircuitBreaker(this.org$apache$pekko$pattern$CircuitBreaker$$scheduler, this.org$apache$pekko$pattern$CircuitBreaker$$maxFailures, this.org$apache$pekko$pattern$CircuitBreaker$$callTimeout, this.resetTimeout(), this.org$apache$pekko$pattern$CircuitBreaker$$maxResetTimeout, this.org$apache$pekko$pattern$CircuitBreaker$$exponentialBackoffFactor, randomFactor, this.allowExceptions(), this.telemetry(), this.org$apache$pekko$pattern$CircuitBreaker$$executor);
    }

    private FiniteDuration _preventPrivateUnusedErasure() {
        return this._currentResetTimeoutDoNotCallMeDirectly;
    }

    private boolean swapState(State oldState, State newState) {
        return Unsafe.instance.compareAndSwapObject(this, AbstractCircuitBreaker.stateOffset, oldState, newState);
    }

    private State currentState() {
        return (State)Unsafe.instance.getObjectVolatile(this, AbstractCircuitBreaker.stateOffset);
    }

    public boolean org$apache$pekko$pattern$CircuitBreaker$$swapResetTimeout(FiniteDuration oldResetTimeout, FiniteDuration newResetTimeout) {
        return Unsafe.instance.compareAndSwapObject(this, AbstractCircuitBreaker.resetTimeoutOffset, oldResetTimeout, newResetTimeout);
    }

    public FiniteDuration org$apache$pekko$pattern$CircuitBreaker$$currentResetTimeout() {
        return (FiniteDuration)Unsafe.instance.getObjectVolatile(this, AbstractCircuitBreaker.resetTimeoutOffset);
    }

    public <T> Future<T> withCircuitBreaker(Function0<Future<T>> body, Function1<Try<T>, Object> defineFailureFn) {
        return this.currentState().invoke(body, defineFailureFn);
    }

    public <T> Future<T> withCircuitBreaker(Function0<Future<T>> body) {
        return this.currentState().invoke(body, this.org$apache$pekko$pattern$CircuitBreaker$$failureFn);
    }

    public <T> Future<T> callWithCircuitBreaker(Callable<Future<T>> body) {
        return this.withCircuitBreaker(() -> CircuitBreaker.callWithCircuitBreaker$$anonfun$1(body));
    }

    public <T> Future<T> callWithCircuitBreaker(Callable<Future<T>> body, BiFunction<Optional<T>, Optional<Throwable>, Boolean> defineFailureFn) {
        Function1<Try<T>, Object> failureFnInScala = CircuitBreaker$.MODULE$.convertJavaFailureFnToScala(defineFailureFn);
        return this.withCircuitBreaker(() -> CircuitBreaker.callWithCircuitBreaker$$anonfun$2(body), failureFnInScala);
    }

    public <T> CompletionStage<T> callWithCircuitBreakerCS(Callable<CompletionStage<T>> body) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.callWithCircuitBreaker(new Callable<Future<T>>(body){
            private final Callable body$3;
            {
                this.body$3 = body$8;
            }

            public Future call() {
                CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)this.body$3.call());
                return FutureConverters$CompletionStageOps$.MODULE$.asScala$extension(completionStage);
            }
        }));
        return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
    }

    public <T> CompletionStage<T> callWithCircuitBreakerCS(Callable<CompletionStage<T>> body, BiFunction<Optional<T>, Optional<Throwable>, Boolean> defineFailureFn) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.callWithCircuitBreaker(new Callable<Future<T>>(body){
            private final Callable body$4;
            {
                this.body$4 = body$9;
            }

            public Future call() {
                CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)this.body$4.call());
                return FutureConverters$CompletionStageOps$.MODULE$.asScala$extension(completionStage);
            }
        }, defineFailureFn));
        return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
    }

    public <T> T withSyncCircuitBreaker(Function0<T> body) {
        return this.withSyncCircuitBreaker(body, this.org$apache$pekko$pattern$CircuitBreaker$$failureFn);
    }

    public <T> T withSyncCircuitBreaker(Function0<T> body, Function1<Try<T>, Object> defineFailureFn) {
        return Await$.MODULE$.result(this.withCircuitBreaker(() -> CircuitBreaker.withSyncCircuitBreaker$$anonfun$1(body), defineFailureFn), this.org$apache$pekko$pattern$CircuitBreaker$$callTimeout);
    }

    public <T> T callWithSyncCircuitBreaker(Callable<T> body) {
        return this.withSyncCircuitBreaker(() -> CircuitBreaker.callWithSyncCircuitBreaker$$anonfun$1(body));
    }

    public <T> T callWithSyncCircuitBreaker(Callable<T> body, BiFunction<Optional<T>, Optional<Throwable>, Boolean> defineFailureFn) {
        Function1<Try<T>, Object> failureFnInScala = CircuitBreaker$.MODULE$.convertJavaFailureFnToScala(defineFailureFn);
        return this.withSyncCircuitBreaker(() -> CircuitBreaker.callWithSyncCircuitBreaker$$anonfun$2(body), failureFnInScala);
    }

    public void succeed() {
        this.currentState().callSucceeds();
    }

    public void fail() {
        this.currentState().callFails();
    }

    public boolean isClosed() {
        State state = this.currentState();
        CircuitBreaker$Closed$ circuitBreaker$Closed$ = this.Closed();
        return !(state != null ? !state.equals(circuitBreaker$Closed$) : circuitBreaker$Closed$ != null);
    }

    public boolean isOpen() {
        State state = this.currentState();
        CircuitBreaker$Open$ circuitBreaker$Open$ = this.Open();
        return !(state != null ? !state.equals(circuitBreaker$Open$) : circuitBreaker$Open$ != null);
    }

    public boolean isHalfOpen() {
        State state = this.currentState();
        CircuitBreaker$HalfOpen$ circuitBreaker$HalfOpen$ = this.HalfOpen();
        return !(state != null ? !state.equals(circuitBreaker$HalfOpen$) : circuitBreaker$HalfOpen$ != null);
    }

    public CircuitBreaker onOpen(Function0<BoxedUnit> callback) {
        return this.addOnOpenListener(new Runnable(callback){
            private final Function0 callback$1;
            {
                this.callback$1 = callback$8;
            }

            public void run() {
                this.callback$1.apply$mcV$sp();
            }
        });
    }

    public CircuitBreaker addOnOpenListener(Runnable callback) {
        this.Open().addListener(callback);
        return this;
    }

    public CircuitBreaker onHalfOpen(Function0<BoxedUnit> callback) {
        return this.addOnHalfOpenListener(new Runnable(callback){
            private final Function0 callback$2;
            {
                this.callback$2 = callback$9;
            }

            public void run() {
                this.callback$2.apply$mcV$sp();
            }
        });
    }

    public CircuitBreaker addOnHalfOpenListener(Runnable callback) {
        this.HalfOpen().addListener(callback);
        return this;
    }

    public CircuitBreaker onClose(Function0<BoxedUnit> callback) {
        return this.addOnCloseListener(new Runnable(callback){
            private final Function0 callback$3;
            {
                this.callback$3 = callback$10;
            }

            public void run() {
                this.callback$3.apply$mcV$sp();
            }
        });
    }

    public CircuitBreaker addOnCloseListener(Runnable callback) {
        this.Closed().addListener(callback);
        return this;
    }

    public CircuitBreaker onCallSuccess(Function1<Object, BoxedUnit> callback) {
        return this.addOnCallSuccessListener(new Consumer<Object>(callback){
            private final Function1 callback$4;
            {
                this.callback$4 = callback$11;
            }

            public void accept(long result) {
                this.callback$4.apply$mcVJ$sp(result);
            }
        });
    }

    public CircuitBreaker addOnCallSuccessListener(Consumer<Object> callback) {
        this.successListeners.add(callback);
        return this;
    }

    public CircuitBreaker onCallFailure(Function1<Object, BoxedUnit> callback) {
        return this.addOnCallFailureListener(new Consumer<Object>(callback){
            private final Function1 callback$5;
            {
                this.callback$5 = callback$12;
            }

            public void accept(long result) {
                this.callback$5.apply$mcVJ$sp(result);
            }
        });
    }

    public CircuitBreaker addOnCallFailureListener(Consumer<Object> callback) {
        this.callFailureListeners.add(callback);
        return this;
    }

    public CircuitBreaker onCallTimeout(Function1<Object, BoxedUnit> callback) {
        return this.addOnCallTimeoutListener(new Consumer<Object>(callback){
            private final Function1 callback$6;
            {
                this.callback$6 = callback$13;
            }

            public void accept(long result) {
                this.callback$6.apply$mcVJ$sp(result);
            }
        });
    }

    public CircuitBreaker addOnCallTimeoutListener(Consumer<Object> callback) {
        this.callTimeoutListeners.add(callback);
        return this;
    }

    public CircuitBreaker onCallBreakerOpen(Function0<BoxedUnit> callback) {
        return this.addOnCallBreakerOpenListener(new Runnable(callback){
            private final Function0 callback$7;
            {
                this.callback$7 = callback$14;
            }

            public void run() {
                this.callback$7.apply$mcV$sp();
            }
        });
    }

    public CircuitBreaker addOnCallBreakerOpenListener(Runnable callback) {
        this.callBreakerOpenListeners.add(callback);
        return this;
    }

    public int currentFailureCount() {
        return this.Closed().get();
    }

    private void transition(State fromState, State toState) {
        if (this.swapState(fromState, toState)) {
            toState.enter();
            return;
        }
    }

    public void org$apache$pekko$pattern$CircuitBreaker$$tripBreaker(State fromState) {
        this.transition(fromState, this.Open());
    }

    public void org$apache$pekko$pattern$CircuitBreaker$$resetBreaker() {
        this.transition(this.HalfOpen(), this.Closed());
    }

    public void org$apache$pekko$pattern$CircuitBreaker$$notifyCallSuccessListeners(long start) {
        if (!this.successListeners.isEmpty()) {
            long elapsed = System.nanoTime() - start;
            for (Consumer<Object> listener : this.successListeners) {
                this.org$apache$pekko$pattern$CircuitBreaker$$executor.execute(new Runnable(listener, elapsed){
                    private final Consumer listener$1;
                    private final long elapsed$1;
                    {
                        this.listener$1 = listener$4;
                        this.elapsed$1 = elapsed$4;
                    }

                    public void run() {
                        this.listener$1.accept(BoxesRunTime.boxToLong(this.elapsed$1));
                    }
                });
            }
            return;
        }
    }

    public void org$apache$pekko$pattern$CircuitBreaker$$notifyCallFailureListeners(long start) {
        if (!this.callFailureListeners.isEmpty()) {
            long elapsed = System.nanoTime() - start;
            for (Consumer<Object> listener : this.callFailureListeners) {
                this.org$apache$pekko$pattern$CircuitBreaker$$executor.execute(new Runnable(listener, elapsed){
                    private final Consumer listener$2;
                    private final long elapsed$2;
                    {
                        this.listener$2 = listener$5;
                        this.elapsed$2 = elapsed$5;
                    }

                    public void run() {
                        this.listener$2.accept(BoxesRunTime.boxToLong(this.elapsed$2));
                    }
                });
            }
            return;
        }
    }

    public void org$apache$pekko$pattern$CircuitBreaker$$notifyCallTimeoutListeners(long start) {
        if (!this.callTimeoutListeners.isEmpty()) {
            long elapsed = System.nanoTime() - start;
            for (Consumer<Object> listener : this.callTimeoutListeners) {
                this.org$apache$pekko$pattern$CircuitBreaker$$executor.execute(new Runnable(listener, elapsed){
                    private final Consumer listener$3;
                    private final long elapsed$3;
                    {
                        this.listener$3 = listener$6;
                        this.elapsed$3 = elapsed$6;
                    }

                    public void run() {
                        this.listener$3.accept(BoxesRunTime.boxToLong(this.elapsed$3));
                    }
                });
            }
            return;
        }
    }

    public void org$apache$pekko$pattern$CircuitBreaker$$notifyCallBreakerOpenListeners() {
        if (!this.callBreakerOpenListeners.isEmpty()) {
            for (Runnable listener : this.callBreakerOpenListeners) {
                this.org$apache$pekko$pattern$CircuitBreaker$$executor.execute(listener);
            }
            return;
        }
    }

    public void org$apache$pekko$pattern$CircuitBreaker$$attemptReset() {
        this.transition(this.Open(), this.HalfOpen());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$pekko$pattern$CircuitBreaker$$isIgnoredException(Object ex) {
        if (!this.allowExceptions().nonEmpty()) return false;
        Object object = ex;
        if (object instanceof CompletionException) {
            CompletionException ce = (CompletionException)object;
            if (ce.getCause() == null) return false;
            if (!this.allowExceptions().contains(ce.getCause().getClass().getName())) return false;
            return true;
        }
        boolean bl = this.allowExceptions().contains(ex.getClass().getName());
        if (!bl) return false;
        return true;
    }

    private final CircuitBreaker$Closed$ Closed() {
        Object object = this.Closed$lzy1;
        if (object instanceof CircuitBreaker$Closed$) {
            return (CircuitBreaker$Closed$)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (CircuitBreaker$Closed$)this.Closed$lzyINIT1();
    }

    private Object Closed$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Closed$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    CircuitBreaker$Closed$ circuitBreaker$Closed$ = null;
                    try {
                        circuitBreaker$Closed$ = new CircuitBreaker$Closed$(this);
                        serializable = circuitBreaker$Closed$ == null ? LazyVals$NullValue$.MODULE$ : circuitBreaker$Closed$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Closed$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return circuitBreaker$Closed$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final CircuitBreaker$HalfOpen$ HalfOpen() {
        Object object = this.HalfOpen$lzy1;
        if (object instanceof CircuitBreaker$HalfOpen$) {
            return (CircuitBreaker$HalfOpen$)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (CircuitBreaker$HalfOpen$)this.HalfOpen$lzyINIT1();
    }

    private Object HalfOpen$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.HalfOpen$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    CircuitBreaker$HalfOpen$ circuitBreaker$HalfOpen$ = null;
                    try {
                        circuitBreaker$HalfOpen$ = new CircuitBreaker$HalfOpen$(this);
                        serializable = circuitBreaker$HalfOpen$ == null ? LazyVals$NullValue$.MODULE$ : circuitBreaker$HalfOpen$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.HalfOpen$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return circuitBreaker$HalfOpen$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final CircuitBreaker$Open$ Open() {
        Object object = this.Open$lzy1;
        if (object instanceof CircuitBreaker$Open$) {
            return (CircuitBreaker$Open$)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (CircuitBreaker$Open$)this.Open$lzyINIT1();
    }

    private Object Open$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Open$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    CircuitBreaker$Open$ circuitBreaker$Open$ = null;
                    try {
                        circuitBreaker$Open$ = new CircuitBreaker$Open$(this);
                        serializable = circuitBreaker$Open$ == null ? LazyVals$NullValue$.MODULE$ : circuitBreaker$Open$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Open$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$2, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return circuitBreaker$Open$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$2, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final Object $init$$$anonfun$1() {
        return "exponentialBackoffFactor must be >= 1.0";
    }

    private static final Object $init$$$anonfun$2() {
        return "randomFactor must be between 0.0 and 1.0";
    }

    private static final void $init$$$anonfun$3(CircuitBreakerTelemetry telemetry$1) {
        telemetry$1.onOpen();
    }

    private static final void $init$$$anonfun$4(CircuitBreakerTelemetry telemetry$2) {
        telemetry$2.onHalfOpen();
    }

    private static final void $init$$$anonfun$5(CircuitBreakerTelemetry telemetry$3) {
        telemetry$3.onClose();
    }

    private static final void $init$$$anonfun$6(CircuitBreakerTelemetry telemetry$4) {
        telemetry$4.onCallBreakerOpenFailure();
    }

    private static final Future callWithCircuitBreaker$$anonfun$1(Callable body$1) {
        return (Future)body$1.call();
    }

    private static final Future callWithCircuitBreaker$$anonfun$2(Callable body$2) {
        return (Future)body$2.call();
    }

    private static final Future withSyncCircuitBreaker$$anonfun$1(Function0 body$5) {
        Future<Object> future;
        try {
            future = Future$.MODULE$.successful(body$5.apply());
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = option.get();
                future = Future$.MODULE$.failed(t);
            }
            throw throwable;
        }
        return future;
    }

    private static final Object callWithSyncCircuitBreaker$$anonfun$1(Callable body$6) {
        return body$6.call();
    }

    private static final Object callWithSyncCircuitBreaker$$anonfun$2(Callable body$7) {
        return body$7.call();
    }

    public static final Future org$apache$pekko$pattern$CircuitBreaker$State$$_$materialize$1(Function0 value) {
        Future future;
        try {
            future = (Future)value.apply();
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = option.get();
                future = Future$.MODULE$.failed(t);
            }
            throw throwable;
        }
        return future;
    }

    public interface State {
        public static void $init$(State $this) {
            $this.org$apache$pekko$pattern$CircuitBreaker$State$_setter_$org$apache$pekko$pattern$CircuitBreaker$State$$listeners_$eq(new CopyOnWriteArrayList());
        }

        public CopyOnWriteArrayList<Runnable> org$apache$pekko$pattern$CircuitBreaker$State$$listeners();

        public void org$apache$pekko$pattern$CircuitBreaker$State$_setter_$org$apache$pekko$pattern$CircuitBreaker$State$$listeners_$eq(CopyOnWriteArrayList var1);

        public static void addListener$(State $this, Runnable listener) {
            $this.addListener(listener);
        }

        default public void addListener(Runnable listener) {
            this.org$apache$pekko$pattern$CircuitBreaker$State$$listeners().add(listener);
        }

        private boolean hasListeners() {
            return !this.org$apache$pekko$pattern$CircuitBreaker$State$$listeners().isEmpty();
        }

        public static void notifyTransitionListeners$(State $this) {
            $this.notifyTransitionListeners();
        }

        default public void notifyTransitionListeners() {
            if (this.hasListeners()) {
                for (Runnable listener : this.org$apache$pekko$pattern$CircuitBreaker$State$$listeners()) {
                    this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$executor.execute(listener);
                }
                return;
            }
        }

        public static Future callThrough$(State $this, Function0 body, Function1 defineFailureFn) {
            return $this.callThrough(body, defineFailureFn);
        }

        default public <T> Future<T> callThrough(Function0<Future<T>> body, Function1<Try<T>, Object> defineFailureFn) {
            FiniteDuration finiteDuration = this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$callTimeout;
            FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
            if (!(finiteDuration != null ? !((Object)finiteDuration).equals(finiteDuration2) : finiteDuration2 != null)) {
                long start = System.nanoTime();
                Future f = CircuitBreaker.org$apache$pekko$pattern$CircuitBreaker$State$$_$materialize$1(body);
                f.onComplete(x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$notifyCallSuccessListeners(start);
                        this.callSucceeds();
                        return;
                    }
                    if (try_ instanceof Failure) {
                        this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$notifyCallFailureListeners(start);
                        this.callFails();
                        return;
                    }
                    throw new MatchError(try_);
                }, this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$executor);
                return f;
            }
            long start = System.nanoTime();
            Promise p = Promise$.MODULE$.apply();
            p.future().onComplete(fResult -> {
                if (BoxesRunTime.unboxToBoolean(defineFailureFn.apply((Try)fResult))) {
                    this.callFails();
                    return;
                }
                this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$notifyCallSuccessListeners(start);
                this.callSucceeds();
            }, ExecutionContexts$.MODULE$.parasitic());
            Cancellable timeout = this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$scheduler.scheduleOnce(this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$callTimeout, (Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                this.$anonfun$1(p, start);
                return BoxedUnit.UNIT;
            }, ExecutionContexts$.MODULE$.parasitic());
            CircuitBreaker.org$apache$pekko$pattern$CircuitBreaker$State$$_$materialize$1(body).onComplete((Function1<Try, boolean> & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    Object result = ((Success)try_).value();
                    p.trySuccess(result);
                    return timeout.cancel();
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    if (p.tryFailure(ex) && !this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$isIgnoredException(ex)) {
                        this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$notifyCallFailureListeners(start);
                    }
                    return timeout.cancel();
                }
                throw new MatchError(try_);
            }, ExecutionContexts$.MODULE$.parasitic());
            return p.future();
        }

        public static Future callThrough$(State $this, Function0 body) {
            return $this.callThrough(body);
        }

        default public <T> Future<T> callThrough(Function0<Future<T>> body) {
            return this.callThrough(body, this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$failureFn);
        }

        public <T> Future<T> invoke(Function0<Future<T>> var1, Function1<Try<T>, Object> var2);

        public static Future invoke$(State $this, Function0 body) {
            return $this.invoke(body);
        }

        default public <T> Future<T> invoke(Function0<Future<T>> body) {
            return this.invoke(body, this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$failureFn);
        }

        public void callSucceeds();

        public void callFails();

        public static void enter$(State $this) {
            $this.enter();
        }

        default public void enter() {
            this._enter();
            this.notifyTransitionListeners();
        }

        public void _enter();

        public /* synthetic */ CircuitBreaker org$apache$pekko$pattern$CircuitBreaker$State$$$outer();

        private void $anonfun$1(Promise p$1, long start$3) {
            if (p$1.tryFailure(this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$timeoutEx)) {
                this.org$apache$pekko$pattern$CircuitBreaker$State$$$outer().org$apache$pekko$pattern$CircuitBreaker$$notifyCallTimeoutListeners(start$3);
                return;
            }
        }
    }
}

