/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.OneForOneStrategy;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.SupervisorStrategy$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.pattern.AutoReset$;
import org.apache.pekko.pattern.BackoffOnFailureOptions;
import org.apache.pekko.pattern.BackoffOnStopOptions;
import org.apache.pekko.pattern.BackoffOptions;
import org.apache.pekko.pattern.BackoffSupervisor$CurrentChild$;
import org.apache.pekko.pattern.BackoffSupervisor$GetCurrentChild$;
import org.apache.pekko.pattern.BackoffSupervisor$GetRestartCount$;
import org.apache.pekko.pattern.BackoffSupervisor$Reset$;
import org.apache.pekko.pattern.BackoffSupervisor$ResetRestartCount$;
import org.apache.pekko.pattern.BackoffSupervisor$RestartCount$;
import org.apache.pekko.pattern.BackoffSupervisor$StartChild$;
import org.apache.pekko.pattern.ForwardDeathLetters$;
import org.apache.pekko.pattern.internal.BackoffOnStopSupervisor;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import scala.Int$;
import scala.None$;
import scala.Predef$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;

public final class BackoffSupervisor$
implements Serializable {
    public static final BackoffSupervisor$GetCurrentChild$ GetCurrentChild;
    public static final BackoffSupervisor$CurrentChild$ CurrentChild;
    public static final BackoffSupervisor$Reset$ Reset;
    public static final BackoffSupervisor$GetRestartCount$ GetRestartCount;
    public static final BackoffSupervisor$RestartCount$ RestartCount;
    @InternalApi
    public static final BackoffSupervisor$StartChild$ StartChild;
    public static final BackoffSupervisor$ResetRestartCount$ ResetRestartCount;
    public static final BackoffSupervisor$ MODULE$;

    private BackoffSupervisor$() {
    }

    static {
        MODULE$ = new BackoffSupervisor$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BackoffSupervisor$.class);
    }

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, SupervisorStrategy$.MODULE$.defaultStrategy());
    }

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, int maxNrOfRetries) {
        SupervisorStrategy supervisorStrategy;
        SupervisorStrategy supervisorStrategy2 = SupervisorStrategy$.MODULE$.defaultStrategy();
        if (supervisorStrategy2 instanceof OneForOneStrategy) {
            OneForOneStrategy oneForOne = (OneForOneStrategy)supervisorStrategy2;
            supervisorStrategy = oneForOne.withMaxNrOfRetries(maxNrOfRetries);
        } else {
            SupervisorStrategy s2;
            supervisorStrategy = s2 = supervisorStrategy2;
        }
        SupervisorStrategy supervisionStrategy = supervisorStrategy;
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, supervisionStrategy);
    }

    public Props props(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor) {
        return this.props(childProps, childName, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff)), randomFactor);
    }

    public Props props(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor, int maxNrOfRetries) {
        return this.props(childProps, childName, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff)), randomFactor, maxNrOfRetries);
    }

    public Props propsWithSupervisorStrategy(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        Predef$.MODULE$.require(minBackoff.$greater(Duration$.MODULE$.Zero()), BackoffSupervisor$::propsWithSupervisorStrategy$$anonfun$1);
        Predef$.MODULE$.require(maxBackoff.$greater$eq(minBackoff), BackoffSupervisor$::propsWithSupervisorStrategy$$anonfun$2);
        Predef$.MODULE$.require(0.0 <= randomFactor && randomFactor <= 1.0, BackoffSupervisor$::propsWithSupervisorStrategy$$anonfun$3);
        return Props$.MODULE$.apply(() -> BackoffSupervisor$.propsWithSupervisorStrategy$$anonfun$4(childProps, childName, minBackoff, maxBackoff, randomFactor, strategy), ClassTag$.MODULE$.apply(BackoffOnStopSupervisor.class));
    }

    public Props propsWithSupervisorStrategy(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        return this.propsWithSupervisorStrategy(childProps, childName, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff)), randomFactor, strategy);
    }

    public Props props(BackoffOptions options) {
        return options.props();
    }

    public Props props(BackoffOnStopOptions options) {
        return options.props();
    }

    public Props props(BackoffOnFailureOptions options) {
        return options.props();
    }

    public BackoffSupervisor$GetCurrentChild$ getCurrentChild() {
        return BackoffSupervisor$GetCurrentChild$.MODULE$;
    }

    public BackoffSupervisor$Reset$ reset() {
        return BackoffSupervisor$Reset$.MODULE$;
    }

    public BackoffSupervisor$GetRestartCount$ getRestartCount() {
        return BackoffSupervisor$GetRestartCount$.MODULE$;
    }

    public FiniteDuration calculateDelay(int restartCount, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        double rnd = 1.0 + ThreadLocalRandom.current().nextDouble() * randomFactor;
        Duration calculatedDuration = (Duration)Try$.MODULE$.apply(() -> BackoffSupervisor$.$anonfun$1(maxBackoff, minBackoff, restartCount, rnd)).getOrElse(() -> BackoffSupervisor$.$anonfun$2(maxBackoff));
        Duration duration = calculatedDuration;
        if (duration instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration;
            return f;
        }
        return maxBackoff;
    }

    private static final Object propsWithSupervisorStrategy$$anonfun$1() {
        return "minBackoff must be > 0";
    }

    private static final Object propsWithSupervisorStrategy$$anonfun$2() {
        return "maxBackoff must be >= minBackoff";
    }

    private static final Object propsWithSupervisorStrategy$$anonfun$3() {
        return "randomFactor must be between 0.0 and 1.0";
    }

    private static final BackoffOnStopSupervisor propsWithSupervisorStrategy$$anonfun$4(Props childProps$1, String childName$1, FiniteDuration minBackoff$1, FiniteDuration maxBackoff$1, double randomFactor$1, SupervisorStrategy strategy$1) {
        return new BackoffOnStopSupervisor(childProps$1, childName$1, minBackoff$1, maxBackoff$1, AutoReset$.MODULE$.apply(minBackoff$1), randomFactor$1, strategy$1, ForwardDeathLetters$.MODULE$, None$.MODULE$);
    }

    private static final Duration $anonfun$1(FiniteDuration maxBackoff$2, FiniteDuration minBackoff$2, int restartCount$1, double rnd$1) {
        return maxBackoff$2.min(minBackoff$2.$times(package$.MODULE$.pow(2.0, Int$.MODULE$.int2double(restartCount$1)))).$times(rnd$1);
    }

    private static final Duration $anonfun$2(FiniteDuration maxBackoff$3) {
        return maxBackoff$3;
    }
}

