/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import java.io.Serializable;
import org.apache.pekko.actor.OneForOneStrategy;
import org.apache.pekko.actor.OneForOneStrategy$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.SupervisorStrategy$;
import org.apache.pekko.pattern.AutoReset;
import org.apache.pekko.pattern.AutoReset$;
import org.apache.pekko.pattern.BackoffOptions;
import org.apache.pekko.pattern.BackoffOptionsImpl$;
import org.apache.pekko.pattern.BackoffReset;
import org.apache.pekko.pattern.BackoffType;
import org.apache.pekko.pattern.ForwardDeathLetters$;
import org.apache.pekko.pattern.HandlingWhileStopped;
import org.apache.pekko.pattern.ManualReset$;
import org.apache.pekko.pattern.ReplyWith;
import org.apache.pekko.pattern.ReplyWith$;
import org.apache.pekko.pattern.RestartImpliesFailure$;
import org.apache.pekko.pattern.StopImpliesFailure$;
import org.apache.pekko.pattern.internal.BackoffOnRestartSupervisor;
import org.apache.pekko.pattern.internal.BackoffOnStopSupervisor;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BackoffOptionsImpl
implements BackoffOptions,
Product,
Serializable {
    private final BackoffType backoffType;
    private final Props childProps;
    private final String childName;
    private final FiniteDuration minBackoff;
    private final FiniteDuration maxBackoff;
    private final double randomFactor;
    private final Option reset;
    private final OneForOneStrategy supervisorStrategy;
    private final Option replyWhileStopped;
    private final Option finalStopMessage;
    private final BackoffReset backoffReset;

    public static BackoffOptionsImpl apply(BackoffType backoffType, Props props, String string2, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, double d, Option<BackoffReset> option, OneForOneStrategy oneForOneStrategy, Option<Object> option2, Option<Function1<Object, Object>> option3) {
        return BackoffOptionsImpl$.MODULE$.apply(backoffType, props, string2, finiteDuration, finiteDuration2, d, option, oneForOneStrategy, option2, option3);
    }

    public static BackoffOptionsImpl fromProduct(Product product) {
        return BackoffOptionsImpl$.MODULE$.fromProduct(product);
    }

    public static BackoffOptionsImpl unapply(BackoffOptionsImpl backoffOptionsImpl) {
        return BackoffOptionsImpl$.MODULE$.unapply(backoffOptionsImpl);
    }

    public static BackoffType $lessinit$greater$default$1() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<BackoffReset> $lessinit$greater$default$7() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$7();
    }

    public static OneForOneStrategy $lessinit$greater$default$8() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Object> $lessinit$greater$default$9() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<Function1<Object, Object>> $lessinit$greater$default$10() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$10();
    }

    public BackoffOptionsImpl(BackoffType backoffType, Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, Option<BackoffReset> reset, OneForOneStrategy supervisorStrategy, Option<Object> replyWhileStopped, Option<Function1<Object, Object>> finalStopMessage) {
        this.backoffType = backoffType;
        this.childProps = childProps;
        this.childName = childName;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.randomFactor = randomFactor;
        this.reset = reset;
        this.supervisorStrategy = supervisorStrategy;
        this.replyWhileStopped = replyWhileStopped;
        this.finalStopMessage = finalStopMessage;
        this.backoffReset = (BackoffReset)reset.getOrElse(() -> BackoffOptionsImpl.$init$$$anonfun$1(minBackoff));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, Statics.anyHash(this.backoffType()));
        n = Statics.mix(n, Statics.anyHash(this.childProps()));
        n = Statics.mix(n, Statics.anyHash(this.childName()));
        n = Statics.mix(n, Statics.anyHash(this.minBackoff()));
        n = Statics.mix(n, Statics.anyHash(this.maxBackoff()));
        n = Statics.mix(n, Statics.doubleHash(this.randomFactor()));
        n = Statics.mix(n, Statics.anyHash(this.reset()));
        n = Statics.mix(n, Statics.anyHash(this.supervisorStrategy()));
        n = Statics.mix(n, Statics.anyHash(this.replyWhileStopped()));
        n = Statics.mix(n, Statics.anyHash(this.finalStopMessage()));
        return Statics.finalizeHash(n, 10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BackoffOptionsImpl)) return false;
        BackoffOptionsImpl backoffOptionsImpl = (BackoffOptionsImpl)object;
        if (this.randomFactor() != backoffOptionsImpl.randomFactor()) return false;
        BackoffType backoffType = this.backoffType();
        BackoffType backoffType2 = backoffOptionsImpl.backoffType();
        if (backoffType == null) {
            if (backoffType2 != null) {
                return false;
            }
        } else if (!backoffType.equals(backoffType2)) return false;
        Props props = this.childProps();
        Props props2 = backoffOptionsImpl.childProps();
        if (props == null) {
            if (props2 != null) {
                return false;
            }
        } else if (!((Object)props).equals(props2)) return false;
        String string2 = this.childName();
        String string3 = backoffOptionsImpl.childName();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        FiniteDuration finiteDuration = this.minBackoff();
        FiniteDuration finiteDuration2 = backoffOptionsImpl.minBackoff();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
        FiniteDuration finiteDuration3 = this.maxBackoff();
        FiniteDuration finiteDuration4 = backoffOptionsImpl.maxBackoff();
        if (finiteDuration3 == null) {
            if (finiteDuration4 != null) {
                return false;
            }
        } else if (!((Object)finiteDuration3).equals(finiteDuration4)) return false;
        Option<BackoffReset> option = this.reset();
        Option<BackoffReset> option2 = backoffOptionsImpl.reset();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        OneForOneStrategy oneForOneStrategy = this.supervisorStrategy();
        OneForOneStrategy oneForOneStrategy2 = backoffOptionsImpl.supervisorStrategy();
        if (oneForOneStrategy == null) {
            if (oneForOneStrategy2 != null) {
                return false;
            }
        } else if (!((Object)oneForOneStrategy).equals(oneForOneStrategy2)) return false;
        Option<Object> option3 = this.replyWhileStopped();
        Option<Object> option4 = backoffOptionsImpl.replyWhileStopped();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Function1<Object, Object>> option5 = this.finalStopMessage();
        Option<Function1<Object, Object>> option6 = backoffOptionsImpl.finalStopMessage();
        if (option5 == null) {
            if (option6 == null) return true;
            return false;
        } else {
            if (!option5.equals(option6)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof BackoffOptionsImpl;
    }

    @Override
    public int productArity() {
        return 10;
    }

    @Override
    public String productPrefix() {
        return "BackoffOptionsImpl";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return BoxesRunTime.boxToDouble(this._6());
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return this._10();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "backoffType";
            }
            case 1: {
                return "childProps";
            }
            case 2: {
                return "childName";
            }
            case 3: {
                return "minBackoff";
            }
            case 4: {
                return "maxBackoff";
            }
            case 5: {
                return "randomFactor";
            }
            case 6: {
                return "reset";
            }
            case 7: {
                return "supervisorStrategy";
            }
            case 8: {
                return "replyWhileStopped";
            }
            case 9: {
                return "finalStopMessage";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public BackoffType backoffType() {
        return this.backoffType;
    }

    public Props childProps() {
        return this.childProps;
    }

    public String childName() {
        return this.childName;
    }

    public FiniteDuration minBackoff() {
        return this.minBackoff;
    }

    public FiniteDuration maxBackoff() {
        return this.maxBackoff;
    }

    public double randomFactor() {
        return this.randomFactor;
    }

    public Option<BackoffReset> reset() {
        return this.reset;
    }

    public OneForOneStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public Option<Object> replyWhileStopped() {
        return this.replyWhileStopped;
    }

    public Option<Function1<Object, Object>> finalStopMessage() {
        return this.finalStopMessage;
    }

    public BackoffReset backoffReset() {
        return this.backoffReset;
    }

    @Override
    public BackoffOptions withAutoReset(FiniteDuration resetBackoff) {
        Some<BackoffReset> some = Some$.MODULE$.apply(AutoReset$.MODULE$.apply(resetBackoff));
        BackoffType backoffType = this.copy$default$1();
        Props props = this.copy$default$2();
        String string2 = this.copy$default$3();
        FiniteDuration finiteDuration = this.copy$default$4();
        FiniteDuration finiteDuration2 = this.copy$default$5();
        double d = this.copy$default$6();
        OneForOneStrategy oneForOneStrategy = this.copy$default$8();
        Option<Object> option = this.copy$default$9();
        Option<Function1<Object, Object>> option2 = this.copy$default$10();
        return this.copy(backoffType, props, string2, finiteDuration, finiteDuration2, d, some, oneForOneStrategy, option, option2);
    }

    @Override
    public BackoffOptions withManualReset() {
        Some<BackoffReset> some = Some$.MODULE$.apply(ManualReset$.MODULE$);
        BackoffType backoffType = this.copy$default$1();
        Props props = this.copy$default$2();
        String string2 = this.copy$default$3();
        FiniteDuration finiteDuration = this.copy$default$4();
        FiniteDuration finiteDuration2 = this.copy$default$5();
        double d = this.copy$default$6();
        OneForOneStrategy oneForOneStrategy = this.copy$default$8();
        Option<Object> option = this.copy$default$9();
        Option<Function1<Object, Object>> option2 = this.copy$default$10();
        return this.copy(backoffType, props, string2, finiteDuration, finiteDuration2, d, some, oneForOneStrategy, option, option2);
    }

    @Override
    public BackoffOptions withSupervisorStrategy(OneForOneStrategy supervisorStrategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), supervisorStrategy, this.copy$default$9(), this.copy$default$10());
    }

    @Override
    public BackoffOptions withDefaultStoppingStrategy() {
        OneForOneStrategy oneForOneStrategy = OneForOneStrategy$.MODULE$.apply(this.supervisorStrategy().maxNrOfRetries(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$2(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$3(), SupervisorStrategy$.MODULE$.stoppingStrategy().decider());
        BackoffType backoffType = this.copy$default$1();
        Props props = this.copy$default$2();
        String string2 = this.copy$default$3();
        FiniteDuration finiteDuration = this.copy$default$4();
        FiniteDuration finiteDuration2 = this.copy$default$5();
        double d = this.copy$default$6();
        Option<BackoffReset> option = this.copy$default$7();
        Option<Object> option2 = this.copy$default$9();
        Option<Function1<Object, Object>> option3 = this.copy$default$10();
        return this.copy(backoffType, props, string2, finiteDuration, finiteDuration2, d, option, oneForOneStrategy, option2, option3);
    }

    @Override
    public BackoffOptions withReplyWhileStopped(Object replyWhileStopped) {
        Some<Object> some = Some$.MODULE$.apply(replyWhileStopped);
        BackoffType backoffType = this.copy$default$1();
        Props props = this.copy$default$2();
        String string2 = this.copy$default$3();
        FiniteDuration finiteDuration = this.copy$default$4();
        FiniteDuration finiteDuration2 = this.copy$default$5();
        double d = this.copy$default$6();
        Option<BackoffReset> option = this.copy$default$7();
        OneForOneStrategy oneForOneStrategy = this.copy$default$8();
        Option<Function1<Object, Object>> option2 = this.copy$default$10();
        return this.copy(backoffType, props, string2, finiteDuration, finiteDuration2, d, option, oneForOneStrategy, some, option2);
    }

    @Override
    public BackoffOptions withMaxNrOfRetries(int maxNrOfRetries) {
        OneForOneStrategy oneForOneStrategy = this.supervisorStrategy().withMaxNrOfRetries(maxNrOfRetries);
        BackoffType backoffType = this.copy$default$1();
        Props props = this.copy$default$2();
        String string2 = this.copy$default$3();
        FiniteDuration finiteDuration = this.copy$default$4();
        FiniteDuration finiteDuration2 = this.copy$default$5();
        double d = this.copy$default$6();
        Option<BackoffReset> option = this.copy$default$7();
        Option<Object> option2 = this.copy$default$9();
        Option<Function1<Object, Object>> option3 = this.copy$default$10();
        return this.copy(backoffType, props, string2, finiteDuration, finiteDuration2, d, option, oneForOneStrategy, option2, option3);
    }

    @Override
    public BackoffOptions withFinalStopMessage(Function1<Object, Object> action) {
        Some<Function1<Object, Object>> some = Some$.MODULE$.apply(action);
        BackoffType backoffType = this.copy$default$1();
        Props props = this.copy$default$2();
        String string2 = this.copy$default$3();
        FiniteDuration finiteDuration = this.copy$default$4();
        FiniteDuration finiteDuration2 = this.copy$default$5();
        double d = this.copy$default$6();
        Option<BackoffReset> option = this.copy$default$7();
        OneForOneStrategy oneForOneStrategy = this.copy$default$8();
        Option<Object> option2 = this.copy$default$9();
        return this.copy(backoffType, props, string2, finiteDuration, finiteDuration2, d, option, oneForOneStrategy, option2, some);
    }

    @Override
    public Props props() {
        BackoffType backoffType;
        Predef$.MODULE$.require(this.minBackoff().$greater(Duration$.MODULE$.Zero()), BackoffOptionsImpl::props$$anonfun$1);
        Predef$.MODULE$.require(this.maxBackoff().$greater$eq(this.minBackoff()), BackoffOptionsImpl::props$$anonfun$2);
        Predef$.MODULE$.require(0.0 <= this.randomFactor() && this.randomFactor() <= 1.0, BackoffOptionsImpl::props$$anonfun$3);
        BackoffReset backoffReset = this.backoffReset();
        if (backoffReset instanceof AutoReset) {
            FiniteDuration finiteDuration;
            AutoReset autoReset = AutoReset$.MODULE$.unapply((AutoReset)backoffReset);
            FiniteDuration resetBackoff = finiteDuration = autoReset._1();
            Predef$.MODULE$.require(this.minBackoff().$less$eq(resetBackoff) && resetBackoff.$less$eq(this.maxBackoff()));
        }
        if (RestartImpliesFailure$.MODULE$.equals(backoffType = this.backoffType())) {
            return Props$.MODULE$.apply(this::props$$anonfun$4, ClassTag$.MODULE$.apply(BackoffOnRestartSupervisor.class));
        }
        if (StopImpliesFailure$.MODULE$.equals(backoffType)) {
            return Props$.MODULE$.apply(this::props$$anonfun$5, ClassTag$.MODULE$.apply(BackoffOnStopSupervisor.class));
        }
        throw new MatchError(backoffType);
    }

    public BackoffOptionsImpl copy(BackoffType backoffType, Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, Option<BackoffReset> reset, OneForOneStrategy supervisorStrategy, Option<Object> replyWhileStopped, Option<Function1<Object, Object>> finalStopMessage) {
        return new BackoffOptionsImpl(backoffType, childProps, childName, minBackoff, maxBackoff, randomFactor, reset, supervisorStrategy, replyWhileStopped, finalStopMessage);
    }

    public BackoffType copy$default$1() {
        return this.backoffType();
    }

    public Props copy$default$2() {
        return this.childProps();
    }

    public String copy$default$3() {
        return this.childName();
    }

    public FiniteDuration copy$default$4() {
        return this.minBackoff();
    }

    public FiniteDuration copy$default$5() {
        return this.maxBackoff();
    }

    public double copy$default$6() {
        return this.randomFactor();
    }

    public Option<BackoffReset> copy$default$7() {
        return this.reset();
    }

    public OneForOneStrategy copy$default$8() {
        return this.supervisorStrategy();
    }

    public Option<Object> copy$default$9() {
        return this.replyWhileStopped();
    }

    public Option<Function1<Object, Object>> copy$default$10() {
        return this.finalStopMessage();
    }

    public BackoffType _1() {
        return this.backoffType();
    }

    public Props _2() {
        return this.childProps();
    }

    public String _3() {
        return this.childName();
    }

    public FiniteDuration _4() {
        return this.minBackoff();
    }

    public FiniteDuration _5() {
        return this.maxBackoff();
    }

    public double _6() {
        return this.randomFactor();
    }

    public Option<BackoffReset> _7() {
        return this.reset();
    }

    public OneForOneStrategy _8() {
        return this.supervisorStrategy();
    }

    public Option<Object> _9() {
        return this.replyWhileStopped();
    }

    public Option<Function1<Object, Object>> _10() {
        return this.finalStopMessage();
    }

    private static final BackoffReset $init$$$anonfun$1(FiniteDuration minBackoff$7) {
        return AutoReset$.MODULE$.apply(minBackoff$7);
    }

    private static final Object props$$anonfun$1() {
        return "minBackoff must be > 0";
    }

    private static final Object props$$anonfun$2() {
        return "maxBackoff must be >= minBackoff";
    }

    private static final Object props$$anonfun$3() {
        return "randomFactor must be between 0.0 and 1.0";
    }

    private static final HandlingWhileStopped props$$anonfun$4$$anonfun$2() {
        return ForwardDeathLetters$.MODULE$;
    }

    private final BackoffOnRestartSupervisor props$$anonfun$4() {
        return new BackoffOnRestartSupervisor(this.childProps(), this.childName(), this.minBackoff(), this.maxBackoff(), this.backoffReset(), this.randomFactor(), this.supervisorStrategy(), (HandlingWhileStopped)this.replyWhileStopped().map((Function1<Object, ReplyWith> & Serializable)msg -> ReplyWith$.MODULE$.apply(msg)).getOrElse(BackoffOptionsImpl::props$$anonfun$4$$anonfun$2));
    }

    private static final HandlingWhileStopped props$$anonfun$5$$anonfun$2() {
        return ForwardDeathLetters$.MODULE$;
    }

    private final BackoffOnStopSupervisor props$$anonfun$5() {
        return new BackoffOnStopSupervisor(this.childProps(), this.childName(), this.minBackoff(), this.maxBackoff(), this.backoffReset(), this.randomFactor(), this.supervisorStrategy(), (HandlingWhileStopped)this.replyWhileStopped().map((Function1<Object, ReplyWith> & Serializable)msg -> ReplyWith$.MODULE$.apply(msg)).getOrElse(BackoffOptionsImpl::props$$anonfun$5$$anonfun$2), this.finalStopMessage());
    }
}

