/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.Status$Failure$;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.IO$;
import org.apache.pekko.io.Tcp$;
import org.apache.pekko.io.Udp;
import org.apache.pekko.io.Udp$;
import org.apache.pekko.io.Udp$Bind$;
import org.apache.pekko.io.Udp$Bound$;
import org.apache.pekko.io.Udp$CommandFailed$;
import org.apache.pekko.io.Udp$Received$;
import org.apache.pekko.io.Udp$Send$;
import org.apache.pekko.io.Udp$Unbind$;
import org.apache.pekko.io.Udp$Unbound$;
import org.apache.pekko.io.dns.RecordClass$;
import org.apache.pekko.io.dns.RecordType;
import org.apache.pekko.io.dns.RecordType$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.internal.DnsClient$Answer$;
import org.apache.pekko.io.dns.internal.DnsClient$DropRequest$;
import org.apache.pekko.io.dns.internal.DnsClient$DuplicateId$;
import org.apache.pekko.io.dns.internal.DnsClient$Question4$;
import org.apache.pekko.io.dns.internal.DnsClient$Question6$;
import org.apache.pekko.io.dns.internal.DnsClient$SrvQuestion$;
import org.apache.pekko.io.dns.internal.Message;
import org.apache.pekko.io.dns.internal.Message$;
import org.apache.pekko.io.dns.internal.MessageFlags$;
import org.apache.pekko.io.dns.internal.Question;
import org.apache.pekko.io.dns.internal.Question$;
import org.apache.pekko.io.dns.internal.ResponseCode$;
import org.apache.pekko.io.dns.internal.TcpDnsClient;
import org.apache.pekko.pattern.BackoffOpts$;
import org.apache.pekko.pattern.BackoffSupervisor$;
import org.apache.pekko.util.ByteString;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try$;

@InternalApi
public class DnsClient
implements Actor,
ActorLogging,
StashSupport,
UnrestrictedStash,
Stash {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DnsClient.class.getDeclaredField("tcpDnsClient$lzy1"));
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private Vector org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    public final InetSocketAddress org$apache$pekko$io$dns$internal$DnsClient$$ns;
    private final ActorRef udp;
    private final ActorRef tcp;
    private Map inflightRequests;
    private volatile Object tcpDnsClient$lzy1;

    public DnsClient(InetSocketAddress ns) {
        this.org$apache$pekko$io$dns$internal$DnsClient$$ns = ns;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        StashSupport.$init$(this);
        this.udp = IO$.MODULE$.apply(Udp$.MODULE$, this.context().system());
        this.tcp = IO$.MODULE$.apply(Tcp$.MODULE$, this.context().system());
        this.inflightRequests = Predef$.MODULE$.Map().empty();
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Vector org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    @Override
    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    @Override
    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    @Override
    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
    }

    @Override
    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$(this);
    }

    public ActorRef udp() {
        return this.udp;
    }

    public ActorRef tcp() {
        return this.tcp;
    }

    public Map<Object, Tuple2<ActorRef, Message>> inflightRequests() {
        return this.inflightRequests;
    }

    public void inflightRequests_$eq(Map<Object, Tuple2<ActorRef, Message>> x$1) {
        this.inflightRequests = x$1;
    }

    public ActorRef tcpDnsClient() {
        Object object = this.tcpDnsClient$lzy1;
        if (object instanceof ActorRef) {
            return (ActorRef)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (ActorRef)this.tcpDnsClient$lzyINIT1();
    }

    private Object tcpDnsClient$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.tcpDnsClient$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    ActorRef actorRef = null;
                    try {
                        actorRef = this.createTcpClient();
                        serializable = actorRef == null ? LazyVals$NullValue$.MODULE$ : actorRef;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.tcpDnsClient$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return actorRef;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void preStart() {
        this.udp().$bang(Udp$Bind$.MODULE$.apply(this.self(), new InetSocketAddress(InetAddress.getByAddress(new byte[4]), 0), Udp$Bind$.MODULE$.$lessinit$greater$default$3()), this.self());
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ DnsClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Udp.Bound) {
                    InetSocketAddress inetSocketAddress;
                    Udp.Bound bound = Udp$Bound$.MODULE$.unapply((Udp.Bound)object);
                    InetSocketAddress local = inetSocketAddress = bound._1();
                    return true;
                }
                if (object instanceof Question4) {
                    return true;
                }
                if (object instanceof Question6) {
                    return true;
                }
                return object instanceof SrvQuestion;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Udp.Bound) {
                    InetSocketAddress inetSocketAddress;
                    Udp.Bound bound = Udp$Bound$.MODULE$.unapply((Udp.Bound)object);
                    InetSocketAddress local = inetSocketAddress = bound._1();
                    this.$outer.log().debug("Bound to UDP address [{}]", local);
                    this.$outer.context().become(this.$outer.ready(this.$outer.sender()));
                    this.$outer.unstashAll();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Question4) {
                    this.$outer.stash();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Question6) {
                    this.$outer.stash();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof SrvQuestion) {
                    this.$outer.stash();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public Message org$apache$pekko$io$dns$internal$DnsClient$$message(String name, short id, RecordType recordType) {
        return Message$.MODULE$.apply(id, MessageFlags$.MODULE$.apply(MessageFlags$.MODULE$.apply$default$1(), MessageFlags$.MODULE$.apply$default$2(), MessageFlags$.MODULE$.apply$default$3(), MessageFlags$.MODULE$.apply$default$4(), MessageFlags$.MODULE$.apply$default$5(), MessageFlags$.MODULE$.apply$default$6(), MessageFlags$.MODULE$.apply$default$7()), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Question$.MODULE$.apply(name, recordType, RecordClass$.MODULE$.IN())), Nil$.MODULE$)), Message$.MODULE$.$lessinit$greater$default$4(), Message$.MODULE$.$lessinit$greater$default$5(), Message$.MODULE$.$lessinit$greater$default$6());
    }

    public PartialFunction<Object, BoxedUnit> ready(ActorRef socket) {
        return new Serializable(socket, this){
            private final ActorRef socket$1;
            private final /* synthetic */ DnsClient $outer;
            {
                this.socket$1 = socket$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof DropRequest) {
                    DnsQuestion dnsQuestion;
                    DropRequest dropRequest = DnsClient$DropRequest$.MODULE$.unapply((DropRequest)object);
                    DnsQuestion msg = dnsQuestion = dropRequest._1();
                    return true;
                }
                if (object instanceof Question4) {
                    Question4 question4 = DnsClient$Question4$.MODULE$.unapply((Question4)object);
                    short s2 = question4._1();
                    String string2 = question4._2();
                    short id = s2;
                    String name = string2;
                    return true;
                }
                if (object instanceof Question6) {
                    Question6 question6 = DnsClient$Question6$.MODULE$.unapply((Question6)object);
                    short s3 = question6._1();
                    String string3 = question6._2();
                    short id = s3;
                    String name = string3;
                    return true;
                }
                if (object instanceof SrvQuestion) {
                    SrvQuestion srvQuestion = DnsClient$SrvQuestion$.MODULE$.unapply((SrvQuestion)object);
                    short s4 = srvQuestion._1();
                    String string4 = srvQuestion._2();
                    short id = s4;
                    String name = string4;
                    return true;
                }
                if (object instanceof Udp.CommandFailed) {
                    Udp.Command command;
                    Udp.CommandFailed commandFailed = Udp$CommandFailed$.MODULE$.unapply((Udp.CommandFailed)object);
                    Udp.Command cmd = command = commandFailed._1();
                    return true;
                }
                if (object instanceof Udp.Received) {
                    Udp.Received received = Udp$Received$.MODULE$.unapply((Udp.Received)object);
                    ByteString byteString = received._1();
                    InetSocketAddress inetSocketAddress = received._2();
                    ByteString data = byteString;
                    InetSocketAddress remote = inetSocketAddress;
                    return true;
                }
                if (object instanceof Answer) {
                    Answer response = (Answer)object;
                    return true;
                }
                if (Udp$Unbind$.MODULE$.equals(object)) {
                    return true;
                }
                return Udp$Unbound$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof DropRequest) {
                    DnsQuestion dnsQuestion;
                    DropRequest dropRequest = DnsClient$DropRequest$.MODULE$.unapply((DropRequest)object);
                    DnsQuestion msg = dnsQuestion = dropRequest._1();
                    this.$outer.inflightRequests().get(BoxesRunTime.boxToShort(msg.id())).foreach(x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Message message;
                            Message orig = message = (Message)tuple2._2();
                            SeqOps seqOps = new $colon$colon<Nothing$>((Nothing$)((Object)msg.name()), Nil$.MODULE$);
                            CC CC = orig.questions().map(DnsClient::org$apache$pekko$io$dns$internal$DnsClient$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1);
                            if (!(seqOps != null ? !seqOps.equals(CC) : CC != null)) {
                                this.$outer.log().debug("Dropping request [{}]", BoxesRunTime.boxToShort(msg.id()));
                                this.$outer.inflightRequests_$eq((Map)this.$outer.inflightRequests().$minus(BoxesRunTime.boxToShort(msg.id())));
                                return;
                            }
                            Message orig2 = message;
                            this.$outer.log().warning("Cannot drop inflight DNS request the question [{}] does not match [{}]", (Object)msg.name(), (Object)((IterableOnceOps)orig2.questions().map(DnsClient::org$apache$pekko$io$dns$internal$DnsClient$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$2)).mkString(","));
                            return;
                        }
                        throw new MatchError(tuple2);
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Question4) {
                    Question4 question4 = DnsClient$Question4$.MODULE$.unapply((Question4)object);
                    short s2 = question4._1();
                    String string2 = question4._2();
                    short id = s2;
                    String name = string2;
                    this.$outer.log().debug("Resolving [{}] (A)", name);
                    Message msg = this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.A());
                    this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$newInflightRequests(msg, this.$outer.sender(), (Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                        this.applyOrElse$$anonfun$2(id, msg);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Question6) {
                    Question6 question6 = DnsClient$Question6$.MODULE$.unapply((Question6)object);
                    short s3 = question6._1();
                    String string3 = question6._2();
                    short id = s3;
                    String name = string3;
                    this.$outer.log().debug("Resolving [{}] (AAAA)", name);
                    Message msg = this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.AAAA());
                    this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$newInflightRequests(msg, this.$outer.sender(), (Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                        this.applyOrElse$$anonfun$3(id, msg);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof SrvQuestion) {
                    SrvQuestion srvQuestion = DnsClient$SrvQuestion$.MODULE$.unapply((SrvQuestion)object);
                    short s4 = srvQuestion._1();
                    String string4 = srvQuestion._2();
                    short id = s4;
                    String name = string4;
                    this.$outer.log().debug("Resolving [{}] (SRV)", name);
                    Message msg = this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.SRV());
                    this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$newInflightRequests(msg, this.$outer.sender(), (Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                        this.applyOrElse$$anonfun$4(id, msg);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Udp.CommandFailed) {
                    Udp.Command command;
                    Udp.CommandFailed commandFailed = Udp$CommandFailed$.MODULE$.unapply((Udp.CommandFailed)object);
                    Udp.Command cmd = command = commandFailed._1();
                    this.$outer.log().debug("Command failed [{}]", cmd);
                    Udp.Command command2 = cmd;
                    if (command2 instanceof Udp.Send) {
                        Udp.Send send = (Udp.Send)command2;
                        Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
                            this.applyOrElse$$anonfun$5(send);
                            return BoxedUnit.UNIT;
                        });
                    } else {
                        this.$outer.log().warning("Dns client failed to send {}", cmd);
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Udp.Received) {
                    Tuple2 tuple2;
                    Udp.Received received = Udp$Received$.MODULE$.unapply((Udp.Received)object);
                    ByteString byteString = received._1();
                    InetSocketAddress inetSocketAddress = received._2();
                    ByteString data = byteString;
                    InetSocketAddress remote = inetSocketAddress;
                    this.$outer.log().debug("Received message from [{}]: [{}]", remote, data);
                    Message msg = Message$.MODULE$.parse(data);
                    this.$outer.log().debug("Decoded UDP DNS response [{}]", msg);
                    if (MessageFlags$.MODULE$.isTruncated$extension(msg.flags())) {
                        Tuple2 tuple22;
                        this.$outer.log().debug("DNS response truncated, falling back to TCP");
                        Option<V> option = this.$outer.inflightRequests().get(BoxesRunTime.boxToShort(msg.id()));
                        if (option instanceof Some && (tuple22 = (Tuple2)((Some)option).value()) != null) {
                            Message msg2 = (Message)tuple22._2();
                            this.$outer.tcpDnsClient().$bang(msg2, this.$outer.self());
                        } else {
                            this.$outer.log().debug("Client for id {} not found. Discarding unsuccessful response.", BoxesRunTime.boxToShort(msg.id()));
                        }
                        return BoxedUnit.UNIT;
                    }
                    Option<V> option = this.$outer.inflightRequests().get(BoxesRunTime.boxToShort(msg.id()));
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        Message orig = (Message)tuple2._2();
                        if (!this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$isSameQuestion(msg.questions(), orig.questions())) {
                            this.$outer.log().warning("Unexpected DNS response id {} question [{}] does not match question asked [{}]", BoxesRunTime.boxToShort(msg.id()), (Object)msg.questions().mkString(","), (Object)orig.questions().mkString(","));
                        } else {
                            if (this.$outer.log().isDebugEnabled()) {
                                this.$outer.log().debug("DNS response id {} has response code {}: question [{}]", BoxesRunTime.boxToShort(msg.id()), MessageFlags$.MODULE$.responseCode$extension(msg.flags()), msg.questions().mkString(","));
                            }
                            Enumeration.Value value = MessageFlags$.MODULE$.responseCode$extension(msg.flags());
                            Enumeration.Value value2 = ResponseCode$.MODULE$.SUCCESS();
                            Tuple2<Seq<ResourceRecord>, Seq<ResourceRecord>> tuple23 = !(value != null ? !((Object)value).equals(value2) : value2 != null) ? Tuple2$.MODULE$.apply(msg.answerRecs(), msg.additionalRecs()) : Tuple2$.MODULE$.apply(scala.package$.MODULE$.Nil(), scala.package$.MODULE$.Nil());
                            Seq<ResourceRecord> recs = tuple23._1();
                            Seq<ResourceRecord> additionalRecs = tuple23._2();
                            this.$outer.self().$bang(DnsClient$Answer$.MODULE$.apply(msg.id(), recs, additionalRecs), this.$outer.self());
                        }
                    } else if (None$.MODULE$.equals(option)) {
                        this.$outer.log().warning("Unexpected DNS response invalid id {}", BoxesRunTime.boxToShort(msg.id()));
                    } else {
                        throw new MatchError(option);
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Answer) {
                    Tuple2 tuple2;
                    Answer response = (Answer)object;
                    Option<V> option = this.$outer.inflightRequests().get(BoxesRunTime.boxToShort(response.id()));
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        ActorRef reply = (ActorRef)tuple2._1();
                        reply.$bang(response, this.$outer.self());
                        this.$outer.inflightRequests_$eq((Map)this.$outer.inflightRequests().$minus(BoxesRunTime.boxToShort(response.id())));
                    } else if (None$.MODULE$.equals(option)) {
                        this.$outer.log().debug("Client for id {} not found. Discarding response.", BoxesRunTime.boxToShort(response.id()));
                    } else {
                        throw new MatchError(option);
                    }
                    return BoxedUnit.UNIT;
                }
                if (Udp$Unbind$.MODULE$.equals(object)) {
                    this.socket$1.$bang(Udp$Unbind$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (Udp$Unbound$.MODULE$.equals(object)) {
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private final void applyOrElse$$anonfun$2(short id$1, Message msg$2) {
                this.$outer.log().debug("Message [{}] to [{}]: [{}]", BoxesRunTime.boxToShort(id$1), this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$ns, msg$2);
                this.socket$1.$bang(Udp$Send$.MODULE$.apply(msg$2.write(), this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$ns), this.$outer.self());
            }

            private final void applyOrElse$$anonfun$3(short id$2, Message msg$3) {
                this.$outer.log().debug("Message [{}] to [{}]: [{}]", BoxesRunTime.boxToShort(id$2), this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$ns, msg$3);
                this.socket$1.$bang(Udp$Send$.MODULE$.apply(msg$3.write(), this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$ns), this.$outer.self());
            }

            private final void applyOrElse$$anonfun$4(short id$3, Message msg$4) {
                this.$outer.log().debug("Message [{}] to [{}]: [{}]", BoxesRunTime.boxToShort(id$3), this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$ns, msg$4);
                this.socket$1.$bang(Udp$Send$.MODULE$.apply(msg$4.write(), this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$ns), this.$outer.self());
            }

            private final void applyOrElse$$anonfun$5(Udp.Send send$1) {
                Message msg = Message$.MODULE$.parse(send$1.payload());
                this.$outer.inflightRequests().get(BoxesRunTime.boxToShort(msg.id())).foreach(x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Message message = (Message)tuple2._2();
                        ActorRef s2 = (ActorRef)tuple2._1();
                        Message orig = message;
                        if (this.$outer.org$apache$pekko$io$dns$internal$DnsClient$$isSameQuestion(msg.questions(), orig.questions())) {
                            s2.$bang(Status$Failure$.MODULE$.apply(new RuntimeException("Send failed to nameserver")), this.$outer.self());
                            this.$outer.inflightRequests_$eq((Map)this.$outer.inflightRequests().$minus(BoxesRunTime.boxToShort(msg.id())));
                            return;
                        }
                        Message orig2 = message;
                        this.$outer.log().warning("Cannot command failed question [{}] does not match [{}]", (Object)msg.questions().mkString(","), (Object)orig2.questions().mkString(","));
                        return;
                    }
                    throw new MatchError(tuple2);
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.apache.pekko.io.dns.internal.DnsClient$DnsQuestion scala.Tuple2 ), applyOrElse$$anonfun$adapted$1(short org.apache.pekko.io.dns.internal.Message ), applyOrElse$$anonfun$adapted$2(short org.apache.pekko.io.dns.internal.Message ), applyOrElse$$anonfun$adapted$3(short org.apache.pekko.io.dns.internal.Message ), applyOrElse$$anonfun$adapted$4(org.apache.pekko.io.Udp$Send ), org$apache$pekko$io$dns$internal$DnsClient$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1(org.apache.pekko.io.dns.internal.Question ), org$apache$pekko$io$dns$internal$DnsClient$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$2(org.apache.pekko.io.dns.internal.Question ), applyOrElse$$anonfun$5$$anonfun$1(org.apache.pekko.io.dns.internal.Message scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public void org$apache$pekko$io$dns$internal$DnsClient$$newInflightRequests(Message msg, ActorRef theSender, Function0<BoxedUnit> func) {
        if (!this.inflightRequests().contains(BoxesRunTime.boxToShort(msg.id()))) {
            Short s2 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToShort(msg.id()));
            ActorRef actorRef = Predef$.MODULE$.ArrowAssoc(theSender);
            this.inflightRequests_$eq((Map)this.inflightRequests().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(s2, Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(actorRef, msg))));
            func.apply$mcV$sp();
            return;
        }
        this.log().warning("Received duplicate message [{}] with id [{}]", msg, (Object)BoxesRunTime.boxToShort(msg.id()));
        theSender.$bang(DnsClient$DuplicateId$.MODULE$.apply(msg.id()), this.self());
    }

    public boolean org$apache$pekko$io$dns$internal$DnsClient$$isSameQuestion(Seq<Question> q1s, Seq<Question> q2s) {
        return DnsClient.impl$1(((IterableOnceOps)q1s.sortBy((Function1<Question, String> & Serializable)_$3 -> _$3.name(), Ordering$String$.MODULE$)).toList(), ((IterableOnceOps)q2s.sortBy((Function1<Question, String> & Serializable)_$4 -> _$4.name(), Ordering$String$.MODULE$)).toList());
    }

    public ActorRef createTcpClient() {
        return this.context().actorOf(BackoffSupervisor$.MODULE$.props(BackoffOpts$.MODULE$.onFailure(Props$.MODULE$.apply(TcpDnsClient.class, ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.tcp(), this.org$apache$pekko$io$dns$internal$DnsClient$$ns, this.self()})), "tcpDnsClient", new package.DurationInt(package$.MODULE$.DurationInt(10)).millis(), new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds(), 0.1)), "tcpDnsClientSupervisor");
    }

    public static final /* synthetic */ String org$apache$pekko$io$dns$internal$DnsClient$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1(Question _$1) {
        return _$1.name();
    }

    public static final /* synthetic */ String org$apache$pekko$io$dns$internal$DnsClient$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$2(Question _$2) {
        return _$2.name();
    }

    private static final boolean impl$1(List q1s, List q2s) {
        Tuple2<List, List> tuple2;
        while ((tuple2 = Tuple2$.MODULE$.apply(q1s, q2s)) != null) {
            List list = tuple2._1();
            List list2 = tuple2._2();
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List list3 = list;
            if (!(nil$ != null ? !((Object)nil$).equals(list3) : list3 != null)) {
                Nil$ nil$2 = scala.package$.MODULE$.Nil();
                List list4 = list2;
                if (!(nil$2 != null ? !((Object)nil$2).equals(list4) : list4 != null)) {
                    return true;
                }
            }
            if (!(list instanceof $colon$colon)) break;
            $colon$colon $colon$colon = ($colon$colon)list;
            List list5 = $colon$colon.next$access$1();
            Question h1 = (Question)$colon$colon.head();
            List t1 = list5;
            if (!(list2 instanceof $colon$colon)) break;
            $colon$colon $colon$colon2 = ($colon$colon)list2;
            List list6 = $colon$colon2.next$access$1();
            Question h2 = (Question)$colon$colon2.head();
            List t2 = list6;
            if (h1.isSame(h2)) {
                List list7 = t1;
                List list8 = t2;
                q1s = list7;
                q2s = list8;
                continue;
            }
            return false;
        }
        return false;
    }

    public static final class Answer
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final short id;
        private final Seq rrs;
        private final Seq additionalRecs;

        public static Answer apply(short s2, Seq<ResourceRecord> seq, Seq<ResourceRecord> seq2) {
            return DnsClient$Answer$.MODULE$.apply(s2, seq, seq2);
        }

        public static Answer fromProduct(Product product) {
            return DnsClient$Answer$.MODULE$.fromProduct(product);
        }

        public static Answer unapply(Answer answer) {
            return DnsClient$Answer$.MODULE$.unapply(answer);
        }

        public static Seq<ResourceRecord> $lessinit$greater$default$3() {
            return DnsClient$Answer$.MODULE$.$lessinit$greater$default$3();
        }

        public Answer(short id, Seq<ResourceRecord> rrs, Seq<ResourceRecord> additionalRecs) {
            this.id = id;
            this.rrs = rrs;
            this.additionalRecs = additionalRecs;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.id());
            n = Statics.mix(n, Statics.anyHash(this.rrs()));
            n = Statics.mix(n, Statics.anyHash(this.additionalRecs()));
            return Statics.finalizeHash(n, 3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Answer)) return false;
            Answer answer = (Answer)object;
            if (this.id() != answer.id()) return false;
            Seq<ResourceRecord> seq = this.rrs();
            Seq<ResourceRecord> seq2 = answer.rrs();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<ResourceRecord> seq3 = this.additionalRecs();
            Seq<ResourceRecord> seq4 = answer.additionalRecs();
            if (seq3 == null) {
                if (seq4 == null) return true;
                return false;
            } else {
                if (!seq3.equals(seq4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Answer;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Answer";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToShort(this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "rrs";
                }
                case 2: {
                    return "additionalRecs";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public short id() {
            return this.id;
        }

        public Seq<ResourceRecord> rrs() {
            return this.rrs;
        }

        public Seq<ResourceRecord> additionalRecs() {
            return this.additionalRecs;
        }

        public Answer copy(short id, Seq<ResourceRecord> rrs, Seq<ResourceRecord> additionalRecs) {
            return new Answer(id, rrs, additionalRecs);
        }

        public short copy$default$1() {
            return this.id();
        }

        public Seq<ResourceRecord> copy$default$2() {
            return this.rrs();
        }

        public Seq<ResourceRecord> copy$default$3() {
            return this.additionalRecs();
        }

        public short _1() {
            return this.id();
        }

        public Seq<ResourceRecord> _2() {
            return this.rrs();
        }

        public Seq<ResourceRecord> _3() {
            return this.additionalRecs();
        }
    }

    public static interface DnsQuestion {
        public short id();

        public String name();

        public static DnsQuestion withId$(DnsQuestion $this, short newId) {
            return $this.withId(newId);
        }

        default public DnsQuestion withId(short newId) {
            DnsQuestion dnsQuestion;
            DnsQuestion dnsQuestion2 = this;
            if (dnsQuestion2 instanceof SrvQuestion) {
                String string2;
                SrvQuestion srvQuestion = DnsClient$SrvQuestion$.MODULE$.unapply((SrvQuestion)dnsQuestion2);
                short s2 = srvQuestion._1();
                String name = string2 = srvQuestion._2();
                dnsQuestion = DnsClient$SrvQuestion$.MODULE$.apply(newId, name);
            } else if (dnsQuestion2 instanceof Question4) {
                String string3;
                Question4 question4 = DnsClient$Question4$.MODULE$.unapply((Question4)dnsQuestion2);
                short s3 = question4._1();
                String name = string3 = question4._2();
                dnsQuestion = DnsClient$Question4$.MODULE$.apply(newId, name);
            } else if (dnsQuestion2 instanceof Question6) {
                String string4;
                Question6 question6 = DnsClient$Question6$.MODULE$.unapply((Question6)dnsQuestion2);
                short s4 = question6._1();
                String name = string4 = question6._2();
                dnsQuestion = DnsClient$Question6$.MODULE$.apply(newId, name);
            } else {
                throw new MatchError(dnsQuestion2);
            }
            return dnsQuestion;
        }
    }

    public static final class DropRequest
    implements Product,
    Serializable {
        private final DnsQuestion question;

        public static DropRequest apply(DnsQuestion dnsQuestion) {
            return DnsClient$DropRequest$.MODULE$.apply(dnsQuestion);
        }

        public static DropRequest fromProduct(Product product) {
            return DnsClient$DropRequest$.MODULE$.fromProduct(product);
        }

        public static DropRequest unapply(DropRequest dropRequest) {
            return DnsClient$DropRequest$.MODULE$.unapply(dropRequest);
        }

        public DropRequest(DnsQuestion question) {
            this.question = question;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DropRequest)) return false;
            DropRequest dropRequest = (DropRequest)object;
            DnsQuestion dnsQuestion = this.question();
            DnsQuestion dnsQuestion2 = dropRequest.question();
            if (dnsQuestion != null) {
                if (!dnsQuestion.equals(dnsQuestion2)) return false;
                return true;
            }
            if (dnsQuestion2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof DropRequest;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "DropRequest";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "question";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DnsQuestion question() {
            return this.question;
        }

        public DropRequest copy(DnsQuestion question) {
            return new DropRequest(question);
        }

        public DnsQuestion copy$default$1() {
            return this.question();
        }

        public DnsQuestion _1() {
            return this.question();
        }
    }

    public static final class DuplicateId
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final short id;

        public static DuplicateId apply(short s2) {
            return DnsClient$DuplicateId$.MODULE$.apply(s2);
        }

        public static DuplicateId fromProduct(Product product) {
            return DnsClient$DuplicateId$.MODULE$.fromProduct(product);
        }

        public static DuplicateId unapply(DuplicateId duplicateId) {
            return DnsClient$DuplicateId$.MODULE$.unapply(duplicateId);
        }

        public DuplicateId(short id) {
            this.id = id;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.id());
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DuplicateId)) return false;
            DuplicateId duplicateId = (DuplicateId)object;
            if (this.id() != duplicateId.id()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof DuplicateId;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "DuplicateId";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToShort(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public short id() {
            return this.id;
        }

        public DuplicateId copy(short id) {
            return new DuplicateId(id);
        }

        public short copy$default$1() {
            return this.id();
        }

        public short _1() {
            return this.id();
        }
    }

    public static final class Question4
    implements DnsQuestion,
    Product,
    Serializable {
        private final short id;
        private final String name;

        public static Question4 apply(short s2, String string2) {
            return DnsClient$Question4$.MODULE$.apply(s2, string2);
        }

        public static Question4 fromProduct(Product product) {
            return DnsClient$Question4$.MODULE$.fromProduct(product);
        }

        public static Question4 unapply(Question4 question4) {
            return DnsClient$Question4$.MODULE$.unapply(question4);
        }

        public Question4(short id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.id());
            n = Statics.mix(n, Statics.anyHash(this.name()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Question4)) return false;
            Question4 question4 = (Question4)object;
            if (this.id() != question4.id()) return false;
            String string2 = this.name();
            String string3 = question4.name();
            if (string2 != null) {
                if (!string2.equals(string3)) return false;
                return true;
            }
            if (string3 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Question4;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Question4";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToShort(this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public String name() {
            return this.name;
        }

        public Question4 copy(short id, String name) {
            return new Question4(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public short _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }
    }

    public static final class Question6
    implements DnsQuestion,
    Product,
    Serializable {
        private final short id;
        private final String name;

        public static Question6 apply(short s2, String string2) {
            return DnsClient$Question6$.MODULE$.apply(s2, string2);
        }

        public static Question6 fromProduct(Product product) {
            return DnsClient$Question6$.MODULE$.fromProduct(product);
        }

        public static Question6 unapply(Question6 question6) {
            return DnsClient$Question6$.MODULE$.unapply(question6);
        }

        public Question6(short id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.id());
            n = Statics.mix(n, Statics.anyHash(this.name()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Question6)) return false;
            Question6 question6 = (Question6)object;
            if (this.id() != question6.id()) return false;
            String string2 = this.name();
            String string3 = question6.name();
            if (string2 != null) {
                if (!string2.equals(string3)) return false;
                return true;
            }
            if (string3 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Question6;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Question6";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToShort(this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public String name() {
            return this.name;
        }

        public Question6 copy(short id, String name) {
            return new Question6(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public short _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }
    }

    public static final class SrvQuestion
    implements DnsQuestion,
    Product,
    Serializable {
        private final short id;
        private final String name;

        public static SrvQuestion apply(short s2, String string2) {
            return DnsClient$SrvQuestion$.MODULE$.apply(s2, string2);
        }

        public static SrvQuestion fromProduct(Product product) {
            return DnsClient$SrvQuestion$.MODULE$.fromProduct(product);
        }

        public static SrvQuestion unapply(SrvQuestion srvQuestion) {
            return DnsClient$SrvQuestion$.MODULE$.unapply(srvQuestion);
        }

        public SrvQuestion(short id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.id());
            n = Statics.mix(n, Statics.anyHash(this.name()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SrvQuestion)) return false;
            SrvQuestion srvQuestion = (SrvQuestion)object;
            if (this.id() != srvQuestion.id()) return false;
            String string2 = this.name();
            String string3 = srvQuestion.name();
            if (string2 != null) {
                if (!string2.equals(string3)) return false;
                return true;
            }
            if (string3 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof SrvQuestion;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "SrvQuestion";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToShort(this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public String name() {
            return this.name;
        }

        public SrvQuestion copy(short id, String name) {
            return new SrvQuestion(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public short _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }
    }
}

