/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.io.dns.internal.AsyncDnsResolver$ResolveFailedException$;
import org.apache.pekko.io.dns.internal.DnsClient;
import org.apache.pekko.io.dns.internal.DnsClient$Answer$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

@InternalApi
public final class AsyncDnsResolver$
implements Serializable {
    private static final Regex ipv4Address;
    private static final Regex ipv6Address;
    public static final Future<DnsClient.Answer> org$apache$pekko$io$dns$internal$AsyncDnsResolver$$$Empty;
    public static final AsyncDnsResolver$ResolveFailedException$ ResolveFailedException;
    public static final AsyncDnsResolver$ MODULE$;

    private AsyncDnsResolver$() {
    }

    static {
        MODULE$ = new AsyncDnsResolver$();
        ipv4Address = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}$"));
        ipv6Address = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$"));
        org$apache$pekko$io$dns$internal$AsyncDnsResolver$$$Empty = Future$.MODULE$.successful(DnsClient$Answer$.MODULE$.apply((short)-1, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AsyncDnsResolver$.class);
    }

    public boolean isIpv4Address(String name) {
        return ipv4Address.findAllMatchIn(name).nonEmpty();
    }

    public boolean isIpv6Address(String name) {
        return ipv6Address.findAllMatchIn(name).nonEmpty();
    }

    public boolean org$apache$pekko$io$dns$internal$AsyncDnsResolver$$$isInetAddress(String name) {
        return this.isIpv4Address(name) || this.isIpv6Address(name);
    }
}

