/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.io.dns.AAAARecord;
import org.apache.pekko.io.dns.AAAARecord$;
import org.apache.pekko.io.dns.ARecord;
import org.apache.pekko.io.dns.ARecord$;
import org.apache.pekko.io.dns.CNameRecord;
import org.apache.pekko.io.dns.CNameRecord$;
import org.apache.pekko.io.dns.CachePolicy;
import org.apache.pekko.io.dns.CachePolicy$Ttl$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.SRVRecord;
import org.apache.pekko.io.dns.SRVRecord$;
import org.apache.pekko.io.dns.UnknownRecord;
import org.apache.pekko.io.dns.UnknownRecord$;
import org.apache.pekko.io.dns.internal.DomainName$;
import org.apache.pekko.io.dns.internal.package$;
import org.apache.pekko.util.ByteIterator;
import org.apache.pekko.util.ByteString;
import scala.MatchError;
import scala.Short$;
import scala.concurrent.duration.package;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class ResourceRecord$
implements Mirror.Sum,
Serializable {
    public static final ResourceRecord$ MODULE$ = new ResourceRecord$();

    private ResourceRecord$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResourceRecord$.class);
    }

    @InternalApi
    public ResourceRecord parse(ByteIterator it, ByteString msg) {
        ResourceRecord resourceRecord;
        CachePolicy.Ttl ttl;
        String name = DomainName$.MODULE$.parse(it, msg);
        short recType = it.getShort(package$.MODULE$.networkByteOrder());
        short recClass = it.getShort(package$.MODULE$.networkByteOrder());
        int n = it.getInt(package$.MODULE$.networkByteOrder());
        if (0 == n) {
            ttl = CachePolicy$Ttl$.MODULE$.never();
        } else {
            int nonZero = n;
            ttl = CachePolicy$Ttl$.MODULE$.fromPositive(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(nonZero)).seconds());
        }
        CachePolicy.Ttl ttl2 = ttl;
        short rdLength = it.getShort(package$.MODULE$.networkByteOrder());
        ByteIterator data = it.clone().take(Short$.MODULE$.short2int(rdLength));
        it.drop(Short$.MODULE$.short2int(rdLength));
        short s2 = recType;
        switch (s2) {
            case 1: {
                resourceRecord = ARecord$.MODULE$.parseBody(name, ttl2, rdLength, data);
                break;
            }
            case 5: {
                resourceRecord = CNameRecord$.MODULE$.parseBody(name, ttl2, rdLength, data, msg);
                break;
            }
            case 28: {
                resourceRecord = AAAARecord$.MODULE$.parseBody(name, ttl2, rdLength, data);
                break;
            }
            case 33: {
                resourceRecord = SRVRecord$.MODULE$.parseBody(name, ttl2, rdLength, data, msg);
                break;
            }
            default: {
                resourceRecord = UnknownRecord$.MODULE$.parseBody(name, ttl2, recType, recClass, rdLength, data);
                break;
            }
        }
        return resourceRecord;
    }

    public int ordinal(ResourceRecord x$0) {
        ResourceRecord resourceRecord = x$0;
        if (resourceRecord instanceof ARecord) {
            return 0;
        }
        if (resourceRecord instanceof AAAARecord) {
            return 1;
        }
        if (resourceRecord instanceof CNameRecord) {
            return 2;
        }
        if (resourceRecord instanceof SRVRecord) {
            return 3;
        }
        if (resourceRecord instanceof UnknownRecord) {
            return 4;
        }
        throw new MatchError(resourceRecord);
    }
}

