/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.dns.CachePolicy;
import org.apache.pekko.io.dns.CachePolicy$Forever$;
import org.apache.pekko.io.dns.CachePolicy$Never$;
import org.apache.pekko.io.dns.CachePolicy$Ttl$;
import org.apache.pekko.io.dns.DnsSettings$;
import org.apache.pekko.io.dns.IdGenerator;
import org.apache.pekko.io.dns.IdGenerator$Policy$EnhancedDoubleHashRandom$;
import org.apache.pekko.io.dns.IdGenerator$Policy$SecureRandom$;
import org.apache.pekko.io.dns.IdGenerator$Policy$ThreadLocalRandom$;
import org.apache.pekko.io.dns.internal.ResolvConf;
import org.apache.pekko.io.dns.internal.ResolvConfParser$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$Requiring$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableFactory$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class DnsSettings {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DnsSettings.class.getDeclaredField("resolvConf$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DnsSettings.class.getDeclaredField("IdGeneratorPolicy$lzy1"));
    private final ExtendedActorSystem system;
    private final Config c;
    private final List NameServers;
    private final FiniteDuration ResolveTimeout;
    private final CachePolicy.CachePolicy PositiveCachePolicy;
    private final CachePolicy.CachePolicy NegativeCachePolicy;
    private volatile Object IdGeneratorPolicy$lzy1;
    private volatile Object resolvConf$lzy1;
    private final List SearchDomains;
    private final int NDots;

    public static Try<List<InetSocketAddress>> getDefaultNameServers(ExtendedActorSystem extendedActorSystem) {
        return DnsSettings$.MODULE$.getDefaultNameServers(extendedActorSystem);
    }

    @InternalApi
    public static InetSocketAddress parseNameserverAddress(String string2) {
        return DnsSettings$.MODULE$.parseNameserverAddress(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DnsSettings(ExtendedActorSystem system, Config c) {
        int n;
        List list;
        List list2;
        this.system = system;
        this.c = c;
        ConfigValueType configValueType = c.getValue("nameservers").valueType();
        ConfigValueType configValueType2 = ConfigValueType.STRING;
        ConfigValueType configValueType3 = configValueType;
        if (!(configValueType2 != null ? !((Object)((Object)configValueType2)).equals((Object)configValueType3) : configValueType3 != null)) {
            String string2 = c.getString("nameservers");
            if ("default".equals(string2)) {
                List osAddresses = (List)DnsSettings$.MODULE$.getDefaultNameServers(system).getOrElse(this::$anonfun$1);
                if (osAddresses.isEmpty()) {
                    throw this.failUnableToDetermineDefaultNameservers();
                }
                list2 = osAddresses;
            } else {
                String other = string2;
                InetSocketAddress inetSocketAddress = DnsSettings$.MODULE$.parseNameserverAddress(other);
                list2 = package$.MODULE$.Nil().$colon$colon(inetSocketAddress);
            }
        } else {
            ConfigValueType configValueType4 = ConfigValueType.LIST;
            ConfigValueType configValueType5 = configValueType;
            if (configValueType4 != null ? !((Object)((Object)configValueType4)).equals((Object)configValueType5) : configValueType5 != null) throw new IllegalArgumentException("Invalid type for nameservers. Must be a string or string list");
            IndexedSeq userAddresses = package$JavaConverters$.MODULE$.ListHasAsScala(c.getStringList("nameservers")).asScala().iterator().map((Function1<String, InetSocketAddress> & Serializable)str -> DnsSettings$.MODULE$.parseNameserverAddress((String)str)).to(IterableFactory$.MODULE$.toFactory(IndexedSeq$.MODULE$));
            Predef$.MODULE$.require(userAddresses.nonEmpty(), DnsSettings::$init$$$anonfun$1);
            list2 = userAddresses.toList();
        }
        this.NameServers = list2;
        this.ResolveTimeout = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c.getDuration("resolve-timeout")));
        this.PositiveCachePolicy = this.getTtl("positive-ttl");
        this.NegativeCachePolicy = this.getTtl("negative-ttl");
        ConfigValueType configValueType6 = c.getValue("search-domains").valueType();
        ConfigValueType configValueType7 = ConfigValueType.STRING;
        ConfigValueType configValueType8 = configValueType6;
        if (!(configValueType7 != null ? !((Object)((Object)configValueType7)).equals((Object)configValueType8) : configValueType8 != null)) {
            String string3 = c.getString("search-domains");
            if ("default".equals(string3)) {
                list = (List)this.resolvConf().map((Function1<ResolvConf, List> & Serializable)_$2 -> _$2.search()).getOrElse(DnsSettings::$init$$$anonfun$3);
            } else {
                String single = string3;
                list = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)single), Nil$.MODULE$));
            }
        } else {
            ConfigValueType configValueType9 = ConfigValueType.LIST;
            ConfigValueType configValueType10 = configValueType6;
            if (configValueType9 != null ? !((Object)((Object)configValueType9)).equals((Object)configValueType10) : configValueType10 != null) throw new IllegalArgumentException("Invalid type for search-domains. Must be a string or string list.");
            list = package$JavaConverters$.MODULE$.ListHasAsScala(c.getStringList("search-domains")).asScala().toList();
        }
        this.SearchDomains = list;
        ConfigValueType configValueType11 = c.getValue("ndots").valueType();
        ConfigValueType configValueType12 = ConfigValueType.STRING;
        ConfigValueType configValueType13 = configValueType11;
        if (!(configValueType12 != null ? !((Object)((Object)configValueType12)).equals((Object)configValueType13) : configValueType13 != null)) {
            String string4 = c.getString("ndots");
            if (!"default".equals(string4)) throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            n = BoxesRunTime.unboxToInt(this.resolvConf().map((Function1<ResolvConf, int> & Serializable)_$3 -> _$3.ndots()).getOrElse(DnsSettings::$init$$$anonfun$5));
        } else {
            ConfigValueType configValueType14 = ConfigValueType.NUMBER;
            ConfigValueType configValueType15 = configValueType11;
            if (configValueType14 != null ? !((Object)((Object)configValueType14)).equals((Object)configValueType15) : configValueType15 != null) throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            int ndots = c.getInt("ndots");
            if (ndots < 0) {
                throw new IllegalArgumentException("Invalid value for ndots, ndots must not be negative.");
            }
            n = ndots;
        }
        this.NDots = n;
    }

    public List<InetSocketAddress> NameServers() {
        return this.NameServers;
    }

    public FiniteDuration ResolveTimeout() {
        return this.ResolveTimeout;
    }

    public CachePolicy.CachePolicy PositiveCachePolicy() {
        return this.PositiveCachePolicy;
    }

    public CachePolicy.CachePolicy NegativeCachePolicy() {
        return this.NegativeCachePolicy;
    }

    public IdGenerator.Policy IdGeneratorPolicy() {
        Object object = this.IdGeneratorPolicy$lzy1;
        if (object instanceof IdGenerator.Policy) {
            return (IdGenerator.Policy)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (IdGenerator.Policy)this.IdGeneratorPolicy$lzyINIT1();
    }

    private Object IdGeneratorPolicy$lzyINIT1() {
        Object object;
        block14: {
            while (true) {
                if ((object = this.IdGeneratorPolicy$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IdGenerator.Policy policy = null;
                    try {
                        IdGenerator.Policy policy2;
                        String string2 = this.c.getString("id-generator-policy");
                        if ("thread-local-random".equals(string2)) {
                            policy2 = IdGenerator$Policy$ThreadLocalRandom$.MODULE$;
                        } else if ("secure-random".equals(string2)) {
                            policy2 = IdGenerator$Policy$SecureRandom$.MODULE$;
                        } else {
                            String s2 = string2;
                            String string3 = s2;
                            String string4 = "enhanced-double-hash-random";
                            if (s2.isEmpty() | !(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                policy2 = IdGenerator$Policy$EnhancedDoubleHashRandom$.MODULE$;
                            } else {
                                throw new IllegalArgumentException(new StringBuilder(137).append("Invalid value for id-generator-policy, id-generator-policy must be 'thread-local-random', 'secure-random' or").append("`enhanced-double-hash-random`").toString());
                            }
                        }
                        policy = policy2;
                        object2 = policy == null ? LazyVals$NullValue$.MODULE$ : policy;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.IdGeneratorPolicy$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return policy;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block14;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private CachePolicy.CachePolicy getTtl(String path) {
        CachePolicy.CachePolicy cachePolicy;
        String string2 = this.c.getString(path);
        if ("forever".equals(string2)) {
            cachePolicy = CachePolicy$Forever$.MODULE$;
        } else if ("never".equals(string2)) {
            cachePolicy = CachePolicy$Never$.MODULE$;
        } else {
            Duration duration = (Duration)Helpers$.MODULE$.Requiring(this.c.getDuration(path));
            Duration finiteTtl = (Duration)Helpers$Requiring$.MODULE$.requiring$extension((Object)duration, (Function1<Duration, boolean> & Serializable)_$1 -> !_$1.isNegative(), () -> DnsSettings.$anonfun$4(path));
            cachePolicy = CachePolicy$Ttl$.MODULE$.fromPositive(finiteTtl);
        }
        return cachePolicy;
    }

    private Option<ResolvConf> resolvConf() {
        Object object = this.resolvConf$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.resolvConf$lzyINIT1();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object resolvConf$lzyINIT1() {
        while (true) {
            Object object;
            if ((object = this.resolvConf$lzy1) == null) {
                void var2_5;
                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                Object var2_2 = null;
                None$ none$ = null;
                try {
                    Option option;
                    File etcResolvConf = new File("/etc/resolv.conf");
                    if (Helpers$.MODULE$.isWindows()) {
                        option = None$.MODULE$;
                    } else if (etcResolvConf.exists()) {
                        Try<ResolvConf> parsed = ResolvConfParser$.MODULE$.parseFile(etcResolvConf);
                        Try<ResolvConf> try_ = parsed;
                        if (try_ instanceof Success) {
                            ResolvConf value = (ResolvConf)((Success)try_).value();
                            option = Some$.MODULE$.apply(value);
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError(try_);
                            Throwable exception = ((Failure)try_).exception();
                            LoggingAdapter log = Logging$.MODULE$.apply(this.system, DnsSettings.class, LogSource$.MODULE$.fromAnyClass());
                            if (log.isWarningEnabled()) {
                                log.error(exception, "Error parsing /etc/resolv.conf, ignoring.");
                            }
                            option = None$.MODULE$;
                        }
                    } else {
                        option = none$ = None$.MODULE$;
                    }
                    if (none$ == null) {
                        LazyVals$NullValue$ lazyVals$NullValue$ = LazyVals$NullValue$.MODULE$;
                    } else {
                        None$ none$2 = none$;
                    }
                }
                catch (Throwable throwable) {
                    if (LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, var2_2)) throw throwable;
                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.resolvConf$lzy1;
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, var2_2);
                    waiting.countDown();
                    throw throwable;
                }
                if (LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, var2_5)) return none$;
                LazyVals.Waiting waiting = (LazyVals.Waiting)this.resolvConf$lzy1;
                LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, var2_5);
                waiting.countDown();
                return none$;
            }
            if (!(object instanceof LazyVals.LazyValControlState)) return object;
            if (object == LazyVals$Evaluating$.MODULE$) {
                LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                continue;
            }
            if (!(object instanceof LazyVals.Waiting)) return null;
            ((LazyVals.Waiting)object).await();
        }
    }

    public List<String> SearchDomains() {
        return this.SearchDomains;
    }

    public int NDots() {
        return this.NDots;
    }

    public Nothing$ failUnableToDetermineDefaultNameservers() {
        throw new IllegalStateException("Unable to obtain default nameservers from JNDI or via reflection. Please set `pekko.io.dns.async-dns.nameservers` explicitly in order to be able to resolve domain names. ");
    }

    private final List $anonfun$1() {
        throw this.failUnableToDetermineDefaultNameservers();
    }

    private static final Object $init$$$anonfun$1() {
        return "nameservers can not be empty";
    }

    private static final List $init$$$anonfun$3() {
        return package$.MODULE$.Nil();
    }

    private static final int $init$$$anonfun$5() {
        return 1;
    }

    private static final Object $anonfun$4(String path$1) {
        return new StringBuilder(72).append("pekko.io.dns.").append(path$1).append(" must be 'default', 'forever', 'never' or positive duration").toString();
    }
}

