/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Hashtable;
import javax.naming.directory.InitialDirContext;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class DnsSettings$
implements Serializable {
    private static final Regex inetSocketAddress;
    public static final DnsSettings$ MODULE$;

    private DnsSettings$() {
    }

    static {
        MODULE$ = new DnsSettings$();
        int DnsFallbackPort = 53;
        inetSocketAddress = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(.*?)(?::(\\d+))?"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DnsSettings$.class);
    }

    @InternalApi
    public InetSocketAddress parseNameserverAddress(String str) {
        List<String> list;
        Option<List<String>> option;
        String string2 = str;
        if (string2 != null && !(option = inetSocketAddress.unapplySeq(string2)).isEmpty() && (list = option.get()).lengthCompare(2) == 0) {
            String string3 = list.apply(0);
            String string4 = list.apply(1);
            String host = string3;
            String port = string4;
            return new InetSocketAddress(host, BoxesRunTime.unboxToInt(Option$.MODULE$.apply(port).fold(DnsSettings$::parseNameserverAddress$$anonfun$1, (Function1<String, int> & Serializable)_$4 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)_$4)))));
        }
        String unexpected = string2;
        throw new IllegalArgumentException(new StringBuilder(28).append("Unparseable address string: ").append(unexpected).toString());
    }

    public Try<List<InetSocketAddress>> getDefaultNameServers(ExtendedActorSystem system) {
        return this.getNameserversUsingJNDI$1().orElse(() -> this.getDefaultNameServers$$anonfun$1(system));
    }

    private static final int parseNameserverAddress$$anonfun$1() {
        return 53;
    }

    private static final InetSocketAddress asInetSocketAddress$1$$anonfun$1(String server$1) {
        int selected;
        URI uri = new URI(server$1);
        String host = uri.getHost();
        int n = uri.getPort();
        int port = -1 == n ? 53 : (selected = n);
        return new InetSocketAddress(host, port);
    }

    private final Try asInetSocketAddress$1(String server) {
        return Try$.MODULE$.apply(() -> DnsSettings$.asInetSocketAddress$1$$anonfun$1(server));
    }

    private final List getNameserversUsingJNDI$1$$anonfun$1(Hashtable env$1) {
        InitialDirContext ctx = new InitialDirContext(env$1);
        String dnsUrls = (String)ctx.getEnvironment().get("java.naming.provider.url");
        if (dnsUrls != null && !dnsUrls.isEmpty()) {
            Object[] servers = dnsUrls.split(" ");
            Object object = Predef$.MODULE$.refArrayOps(servers);
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1<String, Option> & Serializable)server -> this.asInetSocketAddress$1((String)server).toOption(), ClassTag$.MODULE$.apply(InetSocketAddress.class))).toList();
        }
        return package$.MODULE$.Nil();
    }

    private final Try getNameserversUsingJNDI$1() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns://");
        return Try$.MODULE$.apply(() -> this.getNameserversUsingJNDI$1$$anonfun$1(env));
    }

    private final List getNameserversUsingReflection$1$$anonfun$1$$anonfun$1(Class c$1) {
        Object instance;
        Method open = c$1.getMethod("open", new Class[0]);
        Method nameservers = c$1.getMethod("nameservers", new Class[0]);
        java.util.List ns = (java.util.List)nameservers.invoke(instance = open.invoke(null, new Object[0]), new Object[0]);
        if (ns.isEmpty()) {
            throw new IllegalStateException("Empty nameservers list discovered using reflection. Consider configuring default nameservers manually!");
        }
        List res = package$JavaConverters$.MODULE$.ListHasAsScala(ns).asScala().toList();
        return res.flatMap((Function1<String, IterableOnce> & Serializable)s2 -> this.asInetSocketAddress$1((String)s2).toOption());
    }

    private final Try getNameserversUsingReflection$1(ExtendedActorSystem system$1) {
        return system$1.dynamicAccess().getClassFor("sun.net.dns.ResolverConfiguration", ClassTag$.MODULE$.Any()).flatMap((Function1<Class, Try> & Serializable)c -> Try$.MODULE$.apply(() -> this.getNameserversUsingReflection$1$$anonfun$1$$anonfun$1(c)));
    }

    private final Try getDefaultNameServers$$anonfun$1(ExtendedActorSystem system$2) {
        return this.getNameserversUsingReflection$1(system$2);
    }
}

