/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.io.IpVersionSelector$;
import org.apache.pekko.io.dns.AAAARecord;
import org.apache.pekko.io.dns.AAAARecord$;
import org.apache.pekko.io.dns.ARecord;
import org.apache.pekko.io.dns.ARecord$;
import org.apache.pekko.io.dns.CachePolicy;
import org.apache.pekko.io.dns.DnsProtocol$;
import org.apache.pekko.io.dns.DnsProtocol$Ip$;
import org.apache.pekko.io.dns.DnsProtocol$Resolve$;
import org.apache.pekko.io.dns.DnsProtocol$Resolved$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.routing.ConsistentHashingRouter;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class DnsProtocol {
    public static RequestType ipRequestType() {
        return DnsProtocol$.MODULE$.ipRequestType();
    }

    public static RequestType ipRequestType(boolean bl, boolean bl2) {
        return DnsProtocol$.MODULE$.ipRequestType(bl, bl2);
    }

    public static Resolve resolve(String string2) {
        return DnsProtocol$.MODULE$.resolve(string2);
    }

    public static Resolve resolve(String string2, RequestType requestType) {
        return DnsProtocol$.MODULE$.resolve(string2, requestType);
    }

    public static RequestType srvRequestType() {
        return DnsProtocol$.MODULE$.srvRequestType();
    }

    public static final class Ip
    implements RequestType,
    Product,
    Serializable {
        private final boolean ipv4;
        private final boolean ipv6;

        public static Ip apply(boolean bl, boolean bl2) {
            return DnsProtocol$Ip$.MODULE$.apply(bl, bl2);
        }

        public static Ip fromProduct(Product product) {
            return DnsProtocol$Ip$.MODULE$.fromProduct(product);
        }

        public static Ip unapply(Ip ip) {
            return DnsProtocol$Ip$.MODULE$.unapply(ip);
        }

        public static boolean $lessinit$greater$default$1() {
            return DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1();
        }

        public static boolean $lessinit$greater$default$2() {
            return DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2();
        }

        public Ip(boolean ipv4, boolean ipv6) {
            this.ipv4 = ipv4;
            this.ipv6 = ipv6;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.ipv4() ? 1231 : 1237);
            n = Statics.mix(n, this.ipv6() ? 1231 : 1237);
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ip)) return false;
            Ip ip = (Ip)object;
            if (this.ipv4() != ip.ipv4()) return false;
            if (this.ipv6() != ip.ipv6()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Ip;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Ip";
        }

        @Override
        public Object productElement(int n) {
            boolean bl;
            int n2 = n;
            if (0 == n2) {
                bl = this._1();
            } else if (1 == n2) {
                bl = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToBoolean(bl);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ipv4";
            }
            if (1 == n2) {
                return "ipv6";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public boolean ipv4() {
            return this.ipv4;
        }

        public boolean ipv6() {
            return this.ipv6;
        }

        public Ip copy(boolean ipv4, boolean ipv6) {
            return new Ip(ipv4, ipv6);
        }

        public boolean copy$default$1() {
            return this.ipv4();
        }

        public boolean copy$default$2() {
            return this.ipv6();
        }

        public boolean _1() {
            return this.ipv4();
        }

        public boolean _2() {
            return this.ipv6();
        }
    }

    public static interface RequestType {
    }

    public static final class Resolve
    implements ConsistentHashingRouter.ConsistentHashable,
    Product,
    Serializable {
        private final String name;
        private final RequestType requestType;

        public static Resolve apply(String string2) {
            return DnsProtocol$Resolve$.MODULE$.apply(string2);
        }

        public static Resolve apply(String string2, RequestType requestType) {
            return DnsProtocol$Resolve$.MODULE$.apply(string2, requestType);
        }

        public static Resolve fromProduct(Product product) {
            return DnsProtocol$Resolve$.MODULE$.fromProduct(product);
        }

        public static Resolve unapply(Resolve resolve) {
            return DnsProtocol$Resolve$.MODULE$.unapply(resolve);
        }

        public Resolve(String name, RequestType requestType) {
            this.name = name;
            this.requestType = requestType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Resolve)) return false;
            Resolve resolve = (Resolve)object;
            String string2 = this.name();
            String string3 = resolve.name();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            RequestType requestType = this.requestType();
            RequestType requestType2 = resolve.requestType();
            if (requestType == null) {
                if (requestType2 == null) return true;
                return false;
            } else {
                if (!requestType.equals(requestType2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Resolve;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Resolve";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "requestType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String name() {
            return this.name;
        }

        public RequestType requestType() {
            return this.requestType;
        }

        @Override
        public Object consistentHashKey() {
            return this.name();
        }

        public Resolve copy(String name, RequestType requestType) {
            return new Resolve(name, requestType);
        }

        public String copy$default$1() {
            return this.name();
        }

        public RequestType copy$default$2() {
            return this.requestType();
        }

        public String _1() {
            return this.name();
        }

        public RequestType _2() {
            return this.requestType();
        }
    }

    public static final class Resolved
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final String name;
        private final scala.collection.immutable.Seq records;
        private final scala.collection.immutable.Seq additionalRecords;
        private final Option<InetAddress> _address;

        public static Resolved apply(String string2, scala.collection.immutable.Seq<ResourceRecord> seq) {
            return DnsProtocol$Resolved$.MODULE$.apply(string2, seq);
        }

        public static Resolved apply(String string2, scala.collection.immutable.Seq<ResourceRecord> seq, scala.collection.immutable.Seq<ResourceRecord> seq2) {
            return DnsProtocol$Resolved$.MODULE$.apply(string2, seq, seq2);
        }

        public static Resolved fromProduct(Product product) {
            return DnsProtocol$Resolved$.MODULE$.fromProduct(product);
        }

        public static Resolved unapply(Resolved resolved) {
            return DnsProtocol$Resolved$.MODULE$.unapply(resolved);
        }

        public Resolved(String name, scala.collection.immutable.Seq<ResourceRecord> records, scala.collection.immutable.Seq<ResourceRecord> additionalRecords) {
            this.name = name;
            this.records = records;
            this.additionalRecords = additionalRecords;
            Option<Inet4Address> ipv4 = records.collectFirst(new Serializable(){

                public final boolean isDefinedAt(ResourceRecord x) {
                    ResourceRecord resourceRecord = x;
                    if (resourceRecord instanceof ARecord) {
                        ARecord aRecord = ARecord$.MODULE$.unapply((ARecord)resourceRecord);
                        String string2 = aRecord._1();
                        CachePolicy.Ttl ttl = aRecord._2();
                        InetAddress inetAddress = aRecord._3();
                        if (inetAddress instanceof Inet4Address) {
                            Inet4Address ip = (Inet4Address)inetAddress;
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                    ResourceRecord resourceRecord = x;
                    if (resourceRecord instanceof ARecord) {
                        ARecord aRecord = ARecord$.MODULE$.unapply((ARecord)resourceRecord);
                        String string2 = aRecord._1();
                        CachePolicy.Ttl ttl = aRecord._2();
                        InetAddress inetAddress = aRecord._3();
                        if (inetAddress instanceof Inet4Address) {
                            Inet4Address ip = (Inet4Address)inetAddress;
                            return ip;
                        }
                    }
                    return function1.apply(x);
                }
            });
            Option<Inet6Address> ipv6 = records.collectFirst(new Serializable(){

                public final boolean isDefinedAt(ResourceRecord x) {
                    ResourceRecord resourceRecord = x;
                    if (resourceRecord instanceof AAAARecord) {
                        Inet6Address inet6Address;
                        AAAARecord aAAARecord = AAAARecord$.MODULE$.unapply((AAAARecord)resourceRecord);
                        String string2 = aAAARecord._1();
                        CachePolicy.Ttl ttl = aAAARecord._2();
                        Inet6Address ip = inet6Address = aAAARecord._3();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                    ResourceRecord resourceRecord = x;
                    if (resourceRecord instanceof AAAARecord) {
                        Inet6Address inet6Address;
                        AAAARecord aAAARecord = AAAARecord$.MODULE$.unapply((AAAARecord)resourceRecord);
                        String string2 = aAAARecord._1();
                        CachePolicy.Ttl ttl = aAAARecord._2();
                        Inet6Address ip = inet6Address = aAAARecord._3();
                        return ip;
                    }
                    return function1.apply(x);
                }
            });
            this._address = IpVersionSelector$.MODULE$.getInetAddress(ipv4, ipv6);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Resolved)) return false;
            Resolved resolved = (Resolved)object;
            String string2 = this.name();
            String string3 = resolved.name();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            scala.collection.immutable.Seq<ResourceRecord> seq = this.records();
            scala.collection.immutable.Seq<ResourceRecord> seq2 = resolved.records();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            scala.collection.immutable.Seq<ResourceRecord> seq3 = this.additionalRecords();
            scala.collection.immutable.Seq<ResourceRecord> seq4 = resolved.additionalRecords();
            if (seq3 == null) {
                if (seq4 == null) return true;
                return false;
            } else {
                if (!seq3.equals(seq4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Resolved;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Resolved";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "records";
                }
                case 2: {
                    return "additionalRecords";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String name() {
            return this.name;
        }

        public scala.collection.immutable.Seq<ResourceRecord> records() {
            return this.records;
        }

        public scala.collection.immutable.Seq<ResourceRecord> additionalRecords() {
            return this.additionalRecords;
        }

        public List<ResourceRecord> getRecords() {
            return package$JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.records()).asJava();
        }

        public List<ResourceRecord> getAdditionalRecords() {
            return package$JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.additionalRecords()).asJava();
        }

        public InetAddress address() throws UnknownHostException {
            Option<InetAddress> option = this._address;
            if (None$.MODULE$.equals(option)) {
                throw new UnknownHostException(this.name());
            }
            if (option instanceof Some) {
                InetAddress ipAddress = (InetAddress)((Some)option).value();
                return ipAddress;
            }
            throw new MatchError(option);
        }

        public Resolved copy(String name, scala.collection.immutable.Seq<ResourceRecord> records, scala.collection.immutable.Seq<ResourceRecord> additionalRecords) {
            return new Resolved(name, records, additionalRecords);
        }

        public String copy$default$1() {
            return this.name();
        }

        public scala.collection.immutable.Seq<ResourceRecord> copy$default$2() {
            return this.records();
        }

        public scala.collection.immutable.Seq<ResourceRecord> copy$default$3() {
            return this.additionalRecords();
        }

        public String _1() {
            return this.name();
        }

        public scala.collection.immutable.Seq<ResourceRecord> _2() {
            return this.records();
        }

        public scala.collection.immutable.Seq<ResourceRecord> _3() {
            return this.additionalRecords();
        }
    }
}

