/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Status;
import org.apache.pekko.actor.Status$Failure$;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.ChannelRegistration;
import org.apache.pekko.io.ChannelRegistry;
import org.apache.pekko.io.Dns$;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.SelectionHandler$ChannelReadable$;
import org.apache.pekko.io.SelectionHandler$ChannelWritable$;
import org.apache.pekko.io.UdpConnected;
import org.apache.pekko.io.UdpConnected$CommandFailed$;
import org.apache.pekko.io.UdpConnected$Connected$;
import org.apache.pekko.io.UdpConnected$Disconnect$;
import org.apache.pekko.io.UdpConnected$Disconnected$;
import org.apache.pekko.io.UdpConnected$Received$;
import org.apache.pekko.io.UdpConnected$ResumeReading$;
import org.apache.pekko.io.UdpConnected$SuspendReading$;
import org.apache.pekko.io.UdpConnectedExt;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.io.dns.DnsProtocol$Resolve$;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public class UdpConnection
implements Actor,
ActorLogging,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    public final UdpConnectedExt org$apache$pekko$io$UdpConnection$$udpConn;
    private final ChannelRegistry channelRegistry;
    public final ActorRef org$apache$pekko$io$UdpConnection$$commander;
    public final UdpConnected.Connect org$apache$pekko$io$UdpConnection$$connect;
    private Tuple2 pendingSend;
    private DatagramChannel channel;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UdpConnection(UdpConnectedExt udpConn, ChannelRegistry channelRegistry, ActorRef commander, UdpConnected.Connect connect) {
        this.org$apache$pekko$io$UdpConnection$$udpConn = udpConn;
        this.channelRegistry = channelRegistry;
        this.org$apache$pekko$io$UdpConnection$$commander = commander;
        this.org$apache$pekko$io$UdpConnection$$connect = connect;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.pendingSend = null;
        this.context().watch(connect.handler());
        this.channel = null;
        if (connect.remoteAddress().isUnresolved()) {
            Option<DnsProtocol.Resolved> option = Dns$.MODULE$.resolve(DnsProtocol$Resolve$.MODULE$.apply(connect.remoteAddress().getHostName()), this.context().system(), this.self());
            if (option instanceof Some) {
                DnsProtocol.Resolved r = (DnsProtocol.Resolved)((Some)option).value();
                this.org$apache$pekko$io$UdpConnection$$reportConnectFailure((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                    this.$init$$$anonfun$1(r, connect);
                    return BoxedUnit.UNIT;
                });
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                this.context().become(this.resolving());
            }
        } else {
            this.org$apache$pekko$io$UdpConnection$$reportConnectFailure((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                this.$init$$$anonfun$2(connect);
                return BoxedUnit.UNIT;
            });
        }
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Tuple2<UdpConnected.Send, ActorRef> pendingSend() {
        return this.pendingSend;
    }

    public void pendingSend_$eq(Tuple2<UdpConnected.Send, ActorRef> x$1) {
        this.pendingSend = x$1;
    }

    public boolean writePending() {
        return this.pendingSend() != null;
    }

    public DatagramChannel channel() {
        return this.channel;
    }

    public void channel_$eq(DatagramChannel x$1) {
        this.channel = x$1;
    }

    public PartialFunction<Object, BoxedUnit> resolving() {
        return new Serializable(this){
            private final /* synthetic */ UdpConnection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof DnsProtocol.Resolved) {
                    DnsProtocol.Resolved r = (DnsProtocol.Resolved)object;
                    return true;
                }
                if (object instanceof Status.Failure) {
                    Throwable throwable;
                    Status.Failure failure = Status$Failure$.MODULE$.unapply((Status.Failure)object);
                    Throwable ex = throwable = failure._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof DnsProtocol.Resolved) {
                    DnsProtocol.Resolved r = (DnsProtocol.Resolved)object;
                    this.$outer.org$apache$pekko$io$UdpConnection$$reportConnectFailure((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                        this.applyOrElse$$anonfun$1(r);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Status.Failure) {
                    Throwable throwable;
                    Status.Failure failure = Status$Failure$.MODULE$.unapply((Status.Failure)object);
                    Throwable ex = throwable = failure._1();
                    this.$outer.org$apache$pekko$io$UdpConnection$$reportConnectFailure((Function0<BoxedUnit>)((Function0<Object> & Serializable)() -> UdpConnection.org$apache$pekko$io$UdpConnection$$anon$1$$_$applyOrElse$$anonfun$adapted$2(ex)));
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private final void applyOrElse$$anonfun$1(DnsProtocol.Resolved r$2) {
                this.$outer.doConnect(new InetSocketAddress(r$2.address(), this.$outer.org$apache$pekko$io$UdpConnection$$connect.remoteAddress().getPort()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$adapted$1(org.apache.pekko.io.dns.DnsProtocol$Resolved ), org$apache$pekko$io$UdpConnection$$anon$1$$_$applyOrElse$$anonfun$adapted$2(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public void doConnect(InetSocketAddress address) {
        this.channel_$eq(DatagramChannel.open());
        this.channel().configureBlocking(false);
        DatagramSocket socket = this.channel().socket();
        this.org$apache$pekko$io$UdpConnection$$connect.options().foreach(_$1 -> _$1.beforeDatagramBind(socket));
        this.org$apache$pekko$io$UdpConnection$$connect.localAddress().foreach(x$0 -> socket.bind((SocketAddress)x$0));
        this.channel().connect(this.org$apache$pekko$io$UdpConnection$$connect.remoteAddress());
        this.channelRegistry.register(this.channel(), 1, this.self());
        this.log().debug("Successfully connected to [{}]", this.org$apache$pekko$io$UdpConnection$$connect.remoteAddress());
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ UdpConnection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    this.$outer.org$apache$pekko$io$UdpConnection$$connect.options().foreach(x$1 -> {
                        Inet.SocketOption socketOption = x$1;
                        if (socketOption instanceof Inet.SocketOptionV2) {
                            Inet.SocketOptionV2 v2 = (Inet.SocketOptionV2)socketOption;
                            v2.afterConnect(this.$outer.channel().socket());
                            return;
                        }
                    });
                    this.$outer.org$apache$pekko$io$UdpConnection$$commander.$bang(UdpConnected$Connected$.MODULE$, this.$outer.self());
                    this.$outer.context().become(this.$outer.connected(registration), true);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(org.apache.pekko.io.Inet$SocketOption )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> connected(ChannelRegistration registration) {
        return new Serializable(registration, this){
            private final ChannelRegistration registration$1;
            private final /* synthetic */ UdpConnection $outer;
            {
                this.registration$1 = registration$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (UdpConnected$SuspendReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (UdpConnected$ResumeReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    return true;
                }
                if (UdpConnected$Disconnect$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof UdpConnected.Send) {
                    UdpConnected.Send send;
                    UdpConnected.Send send2 = send = (UdpConnected.Send)object;
                    if (this.$outer.writePending()) {
                        return true;
                    }
                    UdpConnected.Send send3 = send;
                    if (send3.payload().isEmpty()) {
                        return true;
                    }
                    UdpConnected.Send send4 = send;
                    return true;
                }
                return SelectionHandler$ChannelWritable$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (UdpConnected$SuspendReading$.MODULE$.equals(object)) {
                    this.registration$1.disableInterest(1);
                    return BoxedUnit.UNIT;
                }
                if (UdpConnected$ResumeReading$.MODULE$.equals(object)) {
                    this.registration$1.enableInterest(1);
                    return BoxedUnit.UNIT;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    this.$outer.doRead(this.registration$1, this.$outer.org$apache$pekko$io$UdpConnection$$connect.handler());
                    return BoxedUnit.UNIT;
                }
                if (UdpConnected$Disconnect$.MODULE$.equals(object)) {
                    this.$outer.log().debug("Closing UDP connection to [{}]", this.$outer.org$apache$pekko$io$UdpConnection$$connect.remoteAddress());
                    this.$outer.channel().close();
                    this.$outer.sender().$bang(UdpConnected$Disconnected$.MODULE$, this.$outer.self());
                    this.$outer.log().debug("Connection closed to [{}], stopping listener", this.$outer.org$apache$pekko$io$UdpConnection$$connect.remoteAddress());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof UdpConnected.Send) {
                    UdpConnected.Send send;
                    UdpConnected.Send send2 = send = (UdpConnected.Send)object;
                    if (this.$outer.writePending()) {
                        if (this.$outer.org$apache$pekko$io$UdpConnection$$udpConn.settings().TraceLogging()) {
                            this.$outer.log().debug("Dropping write because queue is full");
                        }
                        this.$outer.sender().$bang(UdpConnected$CommandFailed$.MODULE$.apply(send2), this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    UdpConnected.Send send3 = send;
                    if (send3.payload().isEmpty()) {
                        if (send3.wantsAck()) {
                            this.$outer.sender().$bang(send3.ack(), this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    UdpConnected.Send send4 = send;
                    this.$outer.pendingSend_$eq(Tuple2$.MODULE$.apply(send4, this.$outer.sender()));
                    this.registration$1.enableInterest(4);
                    return BoxedUnit.UNIT;
                }
                if (SelectionHandler$ChannelWritable$.MODULE$.equals(object)) {
                    this.$outer.doWrite();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void doRead(ChannelRegistration registration, ActorRef handler) {
        ByteBuffer buffer = this.org$apache$pekko$io$UdpConnection$$udpConn.bufferPool().acquire();
        try {
            try {
                this.innerRead$1(handler, this.org$apache$pekko$io$UdpConnection$$udpConn.settings().BatchReceiveLimit(), buffer);
            }
            catch (PortUnreachableException portUnreachableException) {
                if (this.org$apache$pekko$io$UdpConnection$$udpConn.settings().TraceLogging()) {
                    this.log().debug("Ignoring PortUnreachableException in doRead");
                }
            }
        }
        finally {
            registration.enableInterest(1);
            this.org$apache$pekko$io$UdpConnection$$udpConn.bufferPool().release(buffer);
        }
    }

    public final void doWrite() {
        ByteBuffer buffer = this.org$apache$pekko$io$UdpConnection$$udpConn.bufferPool().acquire();
        try {
            Tuple2<UdpConnected.Send, ActorRef> tuple2 = this.pendingSend();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            UdpConnected.Send send = tuple2._1();
            ActorRef commander = tuple2._2();
            Tuple2<UdpConnected.Send, ActorRef> tuple22 = Tuple2$.MODULE$.apply(send, commander);
            UdpConnected.Send send2 = tuple22._1();
            ActorRef commander2 = tuple22._2();
            buffer.clear();
            send2.payload().copyToBuffer(buffer);
            buffer.flip();
            int writtenBytes = this.channel().write(buffer);
            if (this.org$apache$pekko$io$UdpConnection$$udpConn.settings().TraceLogging()) {
                this.log().debug("Wrote [{}] bytes to channel", BoxesRunTime.boxToInteger(writtenBytes));
            }
            if (writtenBytes == 0) {
                commander2.$bang(UdpConnected$CommandFailed$.MODULE$.apply(send2), this.self());
            } else if (send2.wantsAck()) {
                commander2.$bang(send2.ack(), this.self());
            }
        }
        finally {
            this.org$apache$pekko$io$UdpConnection$$udpConn.bufferPool().release(buffer);
            this.pendingSend_$eq(null);
        }
    }

    @Override
    public void postStop() {
        if (this.channel() != null && this.channel().isOpen()) {
            this.log().debug("Closing DatagramChannel after being stopped");
            try {
                this.channel().close();
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    this.log().debug("Error closing DatagramChannel: {}", e);
                }
                throw throwable;
            }
            return;
        }
    }

    public void org$apache$pekko$io$UdpConnection$$reportConnectFailure(Function0<BoxedUnit> thunk) {
        try {
            thunk.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                this.log().debug("Failure while connecting UDP channel to remote address [{}] local address [{}]: {}", this.org$apache$pekko$io$UdpConnection$$connect.remoteAddress(), this.org$apache$pekko$io$UdpConnection$$connect.localAddress().getOrElse(UdpConnection::reportConnectFailure$$anonfun$1), e);
                this.org$apache$pekko$io$UdpConnection$$commander.$bang(UdpConnected$CommandFailed$.MODULE$.apply(this.org$apache$pekko$io$UdpConnection$$connect), this.self());
                this.context().stop(this.self());
            }
            throw throwable;
        }
    }

    private final void $init$$$anonfun$1(DnsProtocol.Resolved r$1, UdpConnected.Connect connect$1) {
        this.doConnect(new InetSocketAddress(r$1.address(), connect$1.remoteAddress().getPort()));
    }

    private final void $init$$$anonfun$2(UdpConnected.Connect connect$2) {
        this.doConnect(connect$2.remoteAddress());
    }

    private static final void applyOrElse$$anonfun$2(Throwable ex$1) {
        throw new RuntimeException(ex$1);
    }

    public static /* bridge */ /* synthetic */ Object org$apache$pekko$io$UdpConnection$$anon$1$$_$applyOrElse$$anonfun$adapted$2(Throwable ex$2) {
        UdpConnection.applyOrElse$$anonfun$2(ex$2);
        return BoxedUnit.UNIT;
    }

    private final void innerRead$1(ActorRef handler$1, int readsLeft, ByteBuffer buffer) {
        while (true) {
            buffer.clear();
            buffer.limit(this.org$apache$pekko$io$UdpConnection$$udpConn.settings().DirectBufferSize());
            if (this.channel().read(buffer) <= 0) break;
            buffer.flip();
            handler$1.$bang(UdpConnected$Received$.MODULE$.apply(ByteString$.MODULE$.apply(buffer)), this.self());
            --readsLeft;
        }
    }

    private static final Serializable reportConnectFailure$$anonfun$1() {
        return "undefined";
    }
}

