/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.ChannelRegistration;
import org.apache.pekko.io.ChannelRegistry;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.SelectionHandler;
import org.apache.pekko.io.SelectionHandler$;
import org.apache.pekko.io.SelectionHandler$ChannelAcceptable$;
import org.apache.pekko.io.SelectionHandler$WorkerForCommand$;
import org.apache.pekko.io.Tcp;
import org.apache.pekko.io.Tcp$Bound$;
import org.apache.pekko.io.Tcp$CommandFailed$;
import org.apache.pekko.io.Tcp$ResumeAccepting$;
import org.apache.pekko.io.Tcp$Unbind$;
import org.apache.pekko.io.Tcp$Unbound$;
import org.apache.pekko.io.TcpExt;
import org.apache.pekko.io.TcpIncomingConnection;
import org.apache.pekko.io.TcpListener$FailedRegisterIncoming$;
import org.apache.pekko.io.TcpListener$RegisterIncoming$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public class TcpListener
implements Actor,
ActorLogging,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final ActorRef selectorRouter;
    private final TcpExt tcp;
    public final ActorRef org$apache$pekko$io$TcpListener$$bindCommander;
    private final Tcp.Bind bind;
    private final ServerSocketChannel channel;
    private int acceptLimit;
    private final Object localAddress;

    public TcpListener(ActorRef selectorRouter, TcpExt tcp, ChannelRegistry channelRegistry, ActorRef bindCommander, Tcp.Bind bind) {
        Serializable serializable;
        this.selectorRouter = selectorRouter;
        this.tcp = tcp;
        this.org$apache$pekko$io$TcpListener$$bindCommander = bindCommander;
        this.bind = bind;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.context().watch(bind.handler());
        this.channel = ServerSocketChannel.open();
        this.channel().configureBlocking(false);
        this.acceptLimit = bind.pullMode() ? 0 : tcp.Settings().BatchAcceptLimit();
        TcpListener tcpListener = this;
        try {
            ServerSocket socket = this.channel().socket();
            bind.options().foreach(_$1 -> _$1.beforeServerSocketBind(socket));
            socket.bind(bind.localAddress(), bind.backlog());
            SocketAddress socketAddress = socket.getLocalSocketAddress();
            if (!(socketAddress instanceof InetSocketAddress)) {
                SocketAddress x = socketAddress;
                throw new IllegalArgumentException(new StringBuilder(33).append("bound to unknown SocketAddress [").append(x).append("]").toString());
            }
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            InetSocketAddress ret = isa;
            channelRegistry.register(this.channel(), bind.pullMode() ? 0 : 16, this.self());
            this.log().debug("Successfully bound to {}", ret);
            bind.options().foreach(x$1 -> {
                Inet.SocketOption socketOption = x$1;
                if (socketOption instanceof Inet.SocketOptionV2) {
                    Inet.SocketOptionV2 o = (Inet.SocketOptionV2)socketOption;
                    o.afterBind(this.channel().socket());
                    return;
                }
            });
            serializable = ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Option<Throwable> option;
            Throwable throwable3 = throwable;
            if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                Throwable throwable4 = option.get();
                Throwable e = throwable4;
                if (e instanceof BindException) {
                    BindException newException = new BindException(new StringBuilder(3).append("[").append(bind.localAddress()).append("] ").append(e.getMessage()).toString());
                    newException.setStackTrace(e.getStackTrace());
                    throwable2 = newException;
                } else {
                    throwable2 = e;
                }
            } else {
                throw throwable;
            }
            Throwable exception = throwable2;
            bindCommander.$bang(Tcp$CommandFailed$.MODULE$.apply(bind).withCause(exception), this.self());
            this.log().error(exception, "Bind failed for TCP channel on endpoint [{}]", (Object)bind.localAddress());
            this.context().stop(this.self());
            serializable = BoxedUnit.UNIT;
        }
        Serializable serializable2 = serializable;
        TcpListener tcpListener2 = tcpListener;
        tcpListener = null;
        Serializable serializable3 = serializable2;
        serializable2 = null;
        tcpListener2.localAddress = serializable3;
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public ServerSocketChannel channel() {
        return this.channel;
    }

    public int acceptLimit() {
        return this.acceptLimit;
    }

    public void acceptLimit_$eq(int x$1) {
        this.acceptLimit = x$1;
    }

    public Object localAddress() {
        return this.localAddress;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return SelectionHandler$.MODULE$.connectionSupervisorStrategy();
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ TcpListener $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    this.$outer.org$apache$pekko$io$TcpListener$$bindCommander.$bang(Tcp$Bound$.MODULE$.apply((InetSocketAddress)this.$outer.channel().socket().getLocalSocketAddress()), this.$outer.self());
                    this.$outer.context().become(this.$outer.bound(registration));
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> bound(ChannelRegistration registration) {
        return new Serializable(registration, this){
            private final ChannelRegistration registration$1;
            private final /* synthetic */ TcpListener $outer;
            {
                this.registration$1 = registration$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (SelectionHandler$ChannelAcceptable$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Tcp.ResumeAccepting) {
                    int n;
                    Tcp.ResumeAccepting resumeAccepting = Tcp$ResumeAccepting$.MODULE$.unapply((Tcp.ResumeAccepting)object);
                    int batchSize = n = resumeAccepting._1();
                    return true;
                }
                if (object instanceof FailedRegisterIncoming) {
                    SocketChannel socketChannel;
                    FailedRegisterIncoming failedRegisterIncoming = TcpListener$FailedRegisterIncoming$.MODULE$.unapply((FailedRegisterIncoming)object);
                    SocketChannel socketChannel2 = socketChannel = failedRegisterIncoming._1();
                    return true;
                }
                return Tcp$Unbind$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (SelectionHandler$ChannelAcceptable$.MODULE$.equals(object)) {
                    this.$outer.acceptLimit_$eq(this.$outer.acceptAllPending(this.registration$1, this.$outer.acceptLimit()));
                    if (this.$outer.acceptLimit() > 0) {
                        this.registration$1.enableInterest(16);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Tcp.ResumeAccepting) {
                    int n;
                    Tcp.ResumeAccepting resumeAccepting = Tcp$ResumeAccepting$.MODULE$.unapply((Tcp.ResumeAccepting)object);
                    int batchSize = n = resumeAccepting._1();
                    this.$outer.acceptLimit_$eq(batchSize);
                    this.registration$1.enableInterest(16);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof FailedRegisterIncoming) {
                    BoxedUnit boxedUnit;
                    SocketChannel socketChannel;
                    FailedRegisterIncoming failedRegisterIncoming = TcpListener$FailedRegisterIncoming$.MODULE$.unapply((FailedRegisterIncoming)object);
                    SocketChannel socketChannel2 = socketChannel = failedRegisterIncoming._1();
                    this.$outer.log().warning("Could not register incoming connection since selector capacity limit is reached, closing connection");
                    try {
                        socketChannel2.close();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Option<Throwable> option;
                        Throwable throwable3 = throwable;
                        if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = throwable2 = option.get();
                        this.$outer.log().debug("Error closing socket channel: {}", e);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                if (Tcp$Unbind$.MODULE$.equals(object)) {
                    this.$outer.log().debug("Unbinding endpoint {}", this.$outer.localAddress());
                    this.registration$1.cancelAndClose(() -> this.$outer.self().$bang(Tcp$Unbound$.MODULE$, this.$outer.self()));
                    this.$outer.context().become(this.$outer.unregistering(this.$outer.sender()));
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> unregistering(ActorRef requester) {
        return new Serializable(requester, this){
            private final ActorRef requester$1;
            private final /* synthetic */ TcpListener $outer;
            {
                this.requester$1 = requester$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return Tcp$Unbound$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (Tcp$Unbound$.MODULE$.equals(object)) {
                    this.requester$1.$bang(Tcp$Unbound$.MODULE$, this.$outer.self());
                    this.$outer.log().debug("Unbound endpoint {}, stopping listener", this.$outer.localAddress());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public final int acceptAllPending(ChannelRegistration registration, int limit) {
        while (true) {
            SocketChannel socketChannel;
            SocketChannel socketChannel2;
            if (limit > 0) {
                try {
                    socketChannel2 = this.channel().accept();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Option<Throwable> option;
                    Throwable throwable3 = throwable;
                    if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = throwable2 = option.get();
                    this.log().error(e, "Accept error: could not accept new connection");
                    socketChannel2 = null;
                }
            } else {
                socketChannel2 = null;
            }
            if ((socketChannel = socketChannel2) == null) break;
            this.log().debug("New connection accepted");
            socketChannel.configureBlocking(false);
            this.selectorRouter.$bang(SelectionHandler$WorkerForCommand$.MODULE$.apply(TcpListener$RegisterIncoming$.MODULE$.apply(socketChannel), this.self(), (Function1<ChannelRegistry, Props> & Serializable)registry -> this.props$1(socketChannel, (ChannelRegistry)registry)), this.self());
            --limit;
        }
        if (this.bind.pullMode()) {
            return limit;
        }
        return this.tcp.Settings().BatchAcceptLimit();
    }

    @Override
    public void postStop() {
        try {
            if (this.channel().isOpen()) {
                this.log().debug("Closing serverSocketChannel after being stopped");
                this.channel().close();
            }
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                this.log().debug("Error closing ServerSocketChannel: {}", e);
            }
            throw throwable;
        }
    }

    private final Props props$1(SocketChannel socketChannel$1, ChannelRegistry registry) {
        return Props$.MODULE$.apply(TcpIncomingConnection.class, ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.tcp, socketChannel$1, registry, this.bind.handler(), this.bind.options(), BoxesRunTime.boxToBoolean(this.bind.pullMode())}));
    }

    public static final class FailedRegisterIncoming
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final SocketChannel channel;

        public static FailedRegisterIncoming apply(SocketChannel socketChannel) {
            return TcpListener$FailedRegisterIncoming$.MODULE$.apply(socketChannel);
        }

        public static FailedRegisterIncoming fromProduct(Product product) {
            return TcpListener$FailedRegisterIncoming$.MODULE$.fromProduct(product);
        }

        public static FailedRegisterIncoming unapply(FailedRegisterIncoming failedRegisterIncoming) {
            return TcpListener$FailedRegisterIncoming$.MODULE$.unapply(failedRegisterIncoming);
        }

        public FailedRegisterIncoming(SocketChannel channel) {
            this.channel = channel;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedRegisterIncoming)) return false;
            FailedRegisterIncoming failedRegisterIncoming = (FailedRegisterIncoming)object;
            SocketChannel socketChannel = this.channel();
            SocketChannel socketChannel2 = failedRegisterIncoming.channel();
            if (socketChannel != null) {
                if (!socketChannel.equals(socketChannel2)) return false;
                return true;
            }
            if (socketChannel2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof FailedRegisterIncoming;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "FailedRegisterIncoming";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "channel";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public SocketChannel channel() {
            return this.channel;
        }

        public FailedRegisterIncoming copy(SocketChannel channel) {
            return new FailedRegisterIncoming(channel);
        }

        public SocketChannel copy$default$1() {
            return this.channel();
        }

        public SocketChannel _1() {
            return this.channel();
        }
    }

    public static final class RegisterIncoming
    implements SelectionHandler.HasFailureMessage,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final SocketChannel channel;

        public static RegisterIncoming apply(SocketChannel socketChannel) {
            return TcpListener$RegisterIncoming$.MODULE$.apply(socketChannel);
        }

        public static RegisterIncoming fromProduct(Product product) {
            return TcpListener$RegisterIncoming$.MODULE$.fromProduct(product);
        }

        public static RegisterIncoming unapply(RegisterIncoming registerIncoming) {
            return TcpListener$RegisterIncoming$.MODULE$.unapply(registerIncoming);
        }

        public RegisterIncoming(SocketChannel channel) {
            this.channel = channel;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegisterIncoming)) return false;
            RegisterIncoming registerIncoming = (RegisterIncoming)object;
            SocketChannel socketChannel = this.channel();
            SocketChannel socketChannel2 = registerIncoming.channel();
            if (socketChannel != null) {
                if (!socketChannel.equals(socketChannel2)) return false;
                return true;
            }
            if (socketChannel2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof RegisterIncoming;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "RegisterIncoming";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "channel";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public SocketChannel channel() {
            return this.channel;
        }

        @Override
        public Object failureMessage() {
            return TcpListener$FailedRegisterIncoming$.MODULE$.apply(this.channel());
        }

        public RegisterIncoming copy(SocketChannel channel) {
            return new RegisterIncoming(channel);
        }

        public SocketChannel copy$default$1() {
            return this.channel();
        }

        public SocketChannel _1() {
            return this.channel();
        }
    }
}

