/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.io.BufferPool;
import org.apache.pekko.io.DirectByteBufferPool;
import org.apache.pekko.io.IO;
import org.apache.pekko.io.SelectionHandlerSettings;
import org.apache.pekko.io.TcpManager;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import org.apache.pekko.util.Helpers$Requiring$;
import scala.Predef$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TcpExt
implements IO.Extension {
    private final Settings Settings;
    private final ActorRef manager;
    private final BufferPool bufferPool;
    private final MessageDispatcher fileIoDispatcher;

    public TcpExt(ExtendedActorSystem system) {
        this.Settings = new Settings(this, system.settings().config().getConfig("pekko.io.tcp"));
        this.manager = system.systemActorOf(Props$.MODULE$.apply(TcpManager.class, ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this})).withDispatcher(this.Settings().ManagementDispatcher()).withDeploy(Deploy$.MODULE$.local()), "IO-TCP");
        this.bufferPool = new DirectByteBufferPool(this.Settings().DirectBufferSize(), this.Settings().MaxDirectBufferPoolSize());
        this.fileIoDispatcher = system.dispatchers().lookup(this.Settings().FileIODispatcher());
    }

    public Settings Settings() {
        return this.Settings;
    }

    @Override
    public ActorRef manager() {
        return this.manager;
    }

    public ActorRef getManager() {
        return this.manager();
    }

    public BufferPool bufferPool() {
        return this.bufferPool;
    }

    public MessageDispatcher fileIoDispatcher() {
        return this.fileIoDispatcher;
    }

    public static final /* synthetic */ boolean org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$6(int _$1) {
        return _$1 > 0;
    }

    public static final Object org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$7() {
        return "nr-of-selectors must be > 0";
    }

    public static final /* synthetic */ boolean org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$8(int _$2) {
        return _$2 > 0;
    }

    public static final Object org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$9() {
        return "batch-accept-limit must be > 0";
    }

    public static final /* synthetic */ boolean org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$10(int _$3) {
        return _$3 > 0;
    }

    public static final Object org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$11() {
        return "finish-connect-retries must be > 0";
    }

    public static final Object org$apache$pekko$io$TcpExt$Settings$$_$getIntBytes$$anonfun$1(String path$1) {
        return new StringBuilder(16).append(path$1).append(" must be < 2 GiB").toString();
    }

    public static final Object org$apache$pekko$io$TcpExt$Settings$$_$getIntBytes$$anonfun$2(String path$2) {
        return new StringBuilder(21).append(path$2).append(" must be non-negative").toString();
    }

    public class Settings
    extends SelectionHandlerSettings {
        private final Config _config;
        private final int NrOfSelectors;
        private final int BatchAcceptLimit;
        private final int DirectBufferSize;
        private final int MaxDirectBufferPoolSize;
        private final Duration RegisterTimeout;
        private final int ReceivedMessageSizeLimit;
        private final String ManagementDispatcher;
        private final String FileIODispatcher;
        private final int TransferToLimit;
        private final int MaxChannelsPerSelector;
        private final int FinishConnectRetries;
        private final boolean WindowsConnectionAbortWorkaroundEnabled;
        private final /* synthetic */ TcpExt $outer;

        public Settings(TcpExt $outer, Config _config) {
            this._config = _config;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(_config);
            Integer n = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(_config.getInt("nr-of-selectors")));
            this.NrOfSelectors = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n, TcpExt::org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$6, TcpExt::org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$7));
            Integer n2 = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(_config.getInt("batch-accept-limit")));
            this.BatchAcceptLimit = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n2, TcpExt::org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$8, TcpExt::org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$9));
            this.DirectBufferSize = this.getIntBytes("direct-buffer-size");
            this.MaxDirectBufferPoolSize = _config.getInt("direct-buffer-pool-limit");
            String string2 = _config.getString("register-timeout");
            this.RegisterTimeout = "infinite".equals(string2) ? Duration$.MODULE$.Undefined() : Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(_config), "register-timeout");
            String string3 = _config.getString("max-received-message-size");
            this.ReceivedMessageSizeLimit = "unlimited".equals(string3) ? Integer.MAX_VALUE : this.getIntBytes("max-received-message-size");
            this.ManagementDispatcher = _config.getString("management-dispatcher");
            this.FileIODispatcher = _config.getString("file-io-dispatcher");
            String string4 = _config.getString("file-io-transferTo-limit");
            this.TransferToLimit = "unlimited".equals(string4) ? Integer.MAX_VALUE : this.getIntBytes("file-io-transferTo-limit");
            this.MaxChannelsPerSelector = this.MaxChannels() == -1 ? -1 : package$.MODULE$.max(this.MaxChannels() / this.NrOfSelectors(), 1);
            Integer n3 = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(_config.getInt("finish-connect-retries")));
            this.FinishConnectRetries = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n3, TcpExt::org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$10, TcpExt::org$apache$pekko$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$11));
            String string5 = _config.getString("windows-connection-abort-workaround-enabled");
            this.WindowsConnectionAbortWorkaroundEnabled = "auto".equals(string5) ? Helpers$.MODULE$.isWindows() : _config.getBoolean("windows-connection-abort-workaround-enabled");
        }

        public int NrOfSelectors() {
            return this.NrOfSelectors;
        }

        public int BatchAcceptLimit() {
            return this.BatchAcceptLimit;
        }

        public int DirectBufferSize() {
            return this.DirectBufferSize;
        }

        public int MaxDirectBufferPoolSize() {
            return this.MaxDirectBufferPoolSize;
        }

        public Duration RegisterTimeout() {
            return this.RegisterTimeout;
        }

        public int ReceivedMessageSizeLimit() {
            return this.ReceivedMessageSizeLimit;
        }

        public String ManagementDispatcher() {
            return this.ManagementDispatcher;
        }

        public String FileIODispatcher() {
            return this.FileIODispatcher;
        }

        public int TransferToLimit() {
            return this.TransferToLimit;
        }

        @Override
        public int MaxChannelsPerSelector() {
            return this.MaxChannelsPerSelector;
        }

        public int FinishConnectRetries() {
            return this.FinishConnectRetries;
        }

        public boolean WindowsConnectionAbortWorkaroundEnabled() {
            return this.WindowsConnectionAbortWorkaroundEnabled;
        }

        private int getIntBytes(String path) {
            Long size = this._config.getBytes(path);
            Predef$.MODULE$.require(Predef$.MODULE$.Long2long(size) < Integer.MAX_VALUE, () -> TcpExt.org$apache$pekko$io$TcpExt$Settings$$_$getIntBytes$$anonfun$1(path));
            Predef$.MODULE$.require(Predef$.MODULE$.Long2long(size) >= 0L, () -> TcpExt.org$apache$pekko$io$TcpExt$Settings$$_$getIntBytes$$anonfun$2(path));
            return (int)Predef$.MODULE$.Long2long(size);
        }

        public final /* synthetic */ TcpExt org$apache$pekko$io$TcpExt$Settings$$$outer() {
            return this.$outer;
        }
    }
}

