/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.io.Dns;
import org.apache.pekko.io.Dns$Resolved$;
import org.apache.pekko.io.PeriodicCacheCleanup;
import org.apache.pekko.io.SimpleDnsCache$;
import org.apache.pekko.io.SimpleDnsCache$CacheEntry$;
import org.apache.pekko.io.dns.AAAARecord;
import org.apache.pekko.io.dns.ARecord;
import org.apache.pekko.io.dns.CachePolicy;
import org.apache.pekko.io.dns.CachePolicy$Forever$;
import org.apache.pekko.io.dns.CachePolicy$Never$;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.io.dns.DnsProtocol$Ip$;
import org.apache.pekko.io.dns.ResourceRecord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterable;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class SimpleDnsCache
extends Dns
implements PeriodicCacheCleanup,
NoSerializationVerificationNeeded {
    private final AtomicReference<Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved>> cacheRef = new AtomicReference(new Cache((SortedSet)SortedSet$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new ExpiryEntry[0]), SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<Object>)(Function0<long> & Serializable)() -> this.clock()));
    private final long nanoBase = System.nanoTime();

    @InternalApi
    public static <K> Ordering<ExpiryEntry<K>> expiryEntryOrdering() {
        return SimpleDnsCache$.MODULE$.expiryEntryOrdering();
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        Object ipv4 = this.cacheRef.get().get(Tuple2$.MODULE$.apply(name, DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), false))).toList().flatMap((Function1<DnsProtocol.Resolved, IterableOnce> & Serializable)_$1 -> _$1.records());
        Object ipv6 = this.cacheRef.get().get(Tuple2$.MODULE$.apply(name, DnsProtocol$Ip$.MODULE$.apply(false, DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2()))).toList().flatMap((Function1<DnsProtocol.Resolved, IterableOnce> & Serializable)_$2 -> _$2.records());
        Object both = this.cacheRef.get().get(Tuple2$.MODULE$.apply(name, DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2()))).toList().flatMap((Function1<DnsProtocol.Resolved, IterableOnce> & Serializable)_$3 -> _$3.records());
        Object all = ((List)((IterableOps)((AbstractIterable)ipv4).$plus$plus((IterableOnce)ipv6)).$plus$plus(both)).collect((PartialFunction)((Object)new Serializable(){

            public final boolean isDefinedAt(ResourceRecord x) {
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord r = (ARecord)resourceRecord;
                    return true;
                }
                if (resourceRecord instanceof AAAARecord) {
                    AAAARecord r = (AAAARecord)resourceRecord;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord r = (ARecord)resourceRecord;
                    return r.ip();
                }
                if (resourceRecord instanceof AAAARecord) {
                    AAAARecord r = (AAAARecord)resourceRecord;
                    return r.ip();
                }
                return function1.apply(x);
            }
        }));
        if (((List)all).isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)all));
    }

    @Override
    public Option<DnsProtocol.Resolved> cached(DnsProtocol.Resolve request) {
        return this.cacheRef.get().get(Tuple2$.MODULE$.apply(request.name(), request.requestType()));
    }

    public long clock() {
        long now = System.nanoTime();
        if (now - this.nanoBase < 0L) {
            return 0L;
        }
        return (now - this.nanoBase) / 1000000L;
    }

    @InternalApi
    public final Option<DnsProtocol.Resolved> get(Tuple2<String, DnsProtocol.RequestType> key2) {
        return this.cacheRef.get().get(key2);
    }

    public final void put(Tuple2<String, DnsProtocol.RequestType> key2, DnsProtocol.Resolved records, CachePolicy.CachePolicy ttl) {
        Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved> c;
        while (!this.cacheRef.compareAndSet(c = this.cacheRef.get(), c.put(key2, records, ttl))) {
        }
    }

    @Override
    public final void cleanup() {
        Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved> c;
        while (!this.cacheRef.compareAndSet(c = this.cacheRef.get(), c.cleanup())) {
        }
    }

    @InternalApi
    public static class Cache<K, V> {
        private final SortedSet<ExpiryEntry<K>> queue;
        private final Map<K, CacheEntry<V>> cache;
        private final Function0<Object> clock;

        public Cache(SortedSet<ExpiryEntry<K>> queue, Map<K, CacheEntry<V>> cache, Function0<Object> clock) {
            this.queue = queue;
            this.cache = cache;
            this.clock = clock;
        }

        public Option<V> get(K name) {
            return this.cache.get(name).withFilter((Function1<CacheEntry, boolean> & Serializable)e -> e.isValid(this.clock.apply$mcJ$sp())).map(SimpleDnsCache$::org$apache$pekko$io$SimpleDnsCache$Cache$$_$get$$anonfun$2);
        }

        public Cache<K, V> put(K name, V answer, CachePolicy.CachePolicy ttl) {
            long l;
            CachePolicy.CachePolicy cachePolicy = ttl;
            if (CachePolicy$Forever$.MODULE$.equals(cachePolicy)) {
                l = Long.MAX_VALUE;
            } else if (CachePolicy$Never$.MODULE$.equals(cachePolicy)) {
                l = this.clock.apply$mcJ$sp() - 1L;
            } else if (cachePolicy instanceof CachePolicy.Ttl) {
                CachePolicy.Ttl ttl2 = (CachePolicy.Ttl)cachePolicy;
                l = this.clock.apply$mcJ$sp() + ttl2.value().toMillis();
            } else {
                throw new MatchError(cachePolicy);
            }
            long until = l;
            K k = Predef$.MODULE$.ArrowAssoc(name);
            return new Cache<K, V>((SortedSet)this.queue.$plus(new ExpiryEntry<K>(name, until)), (Map)this.cache.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(k, SimpleDnsCache$CacheEntry$.MODULE$.apply(answer, until))), this.clock);
        }

        public Cache<K, V> cleanup() {
            long now = this.clock.apply$mcJ$sp();
            SortedSet q = this.queue;
            Map c = this.cache;
            while (q.nonEmpty() && !((ExpiryEntry)q.head()).isValid(now)) {
                ExpiryEntry minEntry = (ExpiryEntry)q.head();
                Object name = minEntry.name();
                q = (SortedSet)q.$minus(minEntry);
                if (!c.get(name).filterNot(arg_0 -> SimpleDnsCache$.org$apache$pekko$io$SimpleDnsCache$Cache$$_$cleanup$$anonfun$1(now, arg_0)).isDefined()) continue;
                c = (Map)c.$minus(name);
            }
            return new Cache<K, V>(q, c, this.clock);
        }
    }

    public static class CacheEntry<T>
    implements Product,
    Serializable {
        private final Object answer;
        private final long until;

        public static <T> CacheEntry<T> apply(T t, long l) {
            return SimpleDnsCache$CacheEntry$.MODULE$.apply(t, l);
        }

        public static CacheEntry<?> fromProduct(Product product) {
            return SimpleDnsCache$CacheEntry$.MODULE$.fromProduct(product);
        }

        public static <T> CacheEntry<T> unapply(CacheEntry<T> cacheEntry) {
            return SimpleDnsCache$CacheEntry$.MODULE$.unapply(cacheEntry);
        }

        public CacheEntry(T answer, long until) {
            this.answer = answer;
            this.until = until;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.answer()));
            n = Statics.mix(n, Statics.longHash(this.until()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CacheEntry)) return false;
            CacheEntry cacheEntry = (CacheEntry)object;
            if (this.until() != cacheEntry.until()) return false;
            if (!BoxesRunTime.equals(this.answer(), cacheEntry.answer())) return false;
            if (!cacheEntry.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof CacheEntry;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "CacheEntry";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "answer";
            }
            if (1 == n2) {
                return "until";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public T answer() {
            return (T)this.answer;
        }

        public long until() {
            return this.until;
        }

        public boolean isValid(long clock) {
            return clock < this.until();
        }

        public <T> CacheEntry<T> copy(T answer, long until) {
            return new CacheEntry<T>(answer, until);
        }

        public <T> T copy$default$1() {
            return this.answer();
        }

        public long copy$default$2() {
            return this.until();
        }

        public T _1() {
            return this.answer();
        }

        public long _2() {
            return this.until();
        }
    }

    @InternalApi
    public static class ExpiryEntry<K>
    implements Ordered<ExpiryEntry<K>> {
        private final Object name;
        private final long until;

        public ExpiryEntry(K name, long until) {
            this.name = name;
            this.until = until;
            Ordered.$init$(this);
        }

        public K name() {
            return (K)this.name;
        }

        public long until() {
            return this.until;
        }

        public boolean isValid(long clock) {
            return clock < this.until();
        }

        @Override
        public int compare(ExpiryEntry<K> that) {
            return -Predef$.MODULE$.long2Long(this.until()).compareTo(Predef$.MODULE$.long2Long(that.until()));
        }
    }
}

