/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import com.typesafe.config.Config;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$Requiring$;
import scala.runtime.BoxesRunTime;

public abstract class SelectionHandlerSettings {
    private final int MaxChannels;
    private final int SelectorAssociationRetries;
    private final String SelectorDispatcher;
    private final String WorkerDispatcher;
    private final boolean TraceLogging;

    public SelectionHandlerSettings(Config config) {
        int n;
        String string2 = config.getString("max-channels");
        if ("unlimited".equals(string2)) {
            n = -1;
        } else {
            Integer n2 = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(config.getInt("max-channels")));
            n = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n2, _$1 -> _$1 > 0, SelectionHandlerSettings::$init$$$anonfun$2));
        }
        this.MaxChannels = n;
        Integer n3 = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(config.getInt("selector-association-retries")));
        this.SelectorAssociationRetries = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n3, _$2 -> _$2 >= 0, SelectionHandlerSettings::$init$$$anonfun$4));
        this.SelectorDispatcher = config.getString("selector-dispatcher");
        this.WorkerDispatcher = config.getString("worker-dispatcher");
        this.TraceLogging = config.getBoolean("trace-logging");
    }

    public int MaxChannels() {
        return this.MaxChannels;
    }

    public int SelectorAssociationRetries() {
        return this.SelectorAssociationRetries;
    }

    public String SelectorDispatcher() {
        return this.SelectorDispatcher;
    }

    public String WorkerDispatcher() {
        return this.WorkerDispatcher;
    }

    public boolean TraceLogging() {
        return this.TraceLogging;
    }

    public abstract int MaxChannelsPerSelector();

    private static final Object $init$$$anonfun$2() {
        return "max-channels must be > 0 or 'unlimited'";
    }

    private static final Object $init$$$anonfun$4() {
        return "selector-association-retries must be >= 0";
    }
}

