/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import com.typesafe.config.Config;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.io.Dns;
import org.apache.pekko.io.DnsProvider;
import org.apache.pekko.io.IO;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public class DnsExt
implements IO.Extension {
    private final ExtendedActorSystem system;
    private final ConcurrentHashMap<String, ActorRef> asyncDns;
    private final Settings Settings;
    private final DnsProvider provider;
    private final Dns cache;
    private final ActorRef manager;

    public DnsExt(ExtendedActorSystem system, String resolverName, String managerName) {
        this.system = system;
        this.asyncDns = new ConcurrentHashMap();
        this.Settings = new Settings(system.settings().config().getConfig("pekko.io.dns"), resolverName);
        this.provider = (DnsProvider)system.dynamicAccess().createInstanceFor(this.Settings().ProviderObjectName(), package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(DnsProvider.class)).get();
        this.cache = this.provider().cache();
        this.manager = system.systemActorOf(Props$.MODULE$.apply(this.provider().managerClass(), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this})).withDeploy(Deploy$.MODULE$.local()).withDispatcher(this.Settings().Dispatcher()), managerName);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @InternalApi
    public ActorRef loadAsyncDns(String managerName) {
        return this.asyncDns.computeIfAbsent(managerName, new Function<String, ActorRef>(managerName, this){
            private final String managerName$1;
            private final /* synthetic */ DnsExt $outer;
            {
                this.managerName$1 = managerName$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ActorRef apply(String r) {
                Settings settings = this.$outer.new Settings(this.$outer.system().settings().config().getConfig("pekko.io.dns"), "async-dns");
                DnsProvider provider = (DnsProvider)this.$outer.system().dynamicAccess().createInstanceFor(settings.ProviderObjectName(), package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(DnsProvider.class)).get();
                Logging$.MODULE$.apply(this.$outer.system(), DnsExt.class, LogSource$.MODULE$.fromAnyClass()).info("Creating async dns resolver {} with manager name {}", settings.Resolver(), this.managerName$1);
                return this.$outer.system().systemActorOf(Props$.MODULE$.apply(provider.managerClass(), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{settings.Resolver(), this.$outer.system(), settings.ResolverConfig(), provider.cache(), settings.Dispatcher(), provider})).withDeploy(Deploy$.MODULE$.local()).withDispatcher(settings.Dispatcher()), this.managerName$1);
            }
        });
    }

    @InternalApi
    public DnsExt(ExtendedActorSystem system) {
        this(system, system.settings().config().getString("pekko.io.dns.resolver"), "IO-DNS");
    }

    public Settings Settings() {
        return this.Settings;
    }

    public DnsProvider provider() {
        return this.provider;
    }

    public Dns cache() {
        return this.cache;
    }

    @Override
    public ActorRef manager() {
        return this.manager;
    }

    public ActorRef getResolver() {
        return this.manager();
    }

    public class Settings {
        private final String Dispatcher;
        private final String Resolver;
        private final Config ResolverConfig;
        private final String ProviderObjectName;

        public Settings(Config config, String resolverName) {
            if (DnsExt.this == null) {
                throw new NullPointerException();
            }
            this.Dispatcher = config.getString("dispatcher");
            this.Resolver = resolverName;
            this.ResolverConfig = config.getConfig(this.Resolver());
            this.ProviderObjectName = this.ResolverConfig().getString("provider-object");
        }

        public Settings(Config config) {
            this(config, config.getString("resolver"));
        }

        public String Dispatcher() {
            return this.Dispatcher;
        }

        public String Resolver() {
            return this.Resolver;
        }

        public Config ResolverConfig() {
            return this.ResolverConfig;
        }

        public String ProviderObjectName() {
            return this.ProviderObjectName;
        }

        public String toString() {
            return new StringBuilder(16).append("Settings(").append(this.Dispatcher()).append(", ").append(this.Resolver()).append(", ").append(this.ResolverConfig()).append(", ").append(this.ProviderObjectName()).append(")").toString();
        }

        public final /* synthetic */ DnsExt org$apache$pekko$io$DnsExt$Settings$$$outer() {
            return DnsExt.this;
        }
    }
}

