/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.io.Dns$;
import org.apache.pekko.io.Dns$Resolve$;
import org.apache.pekko.io.Dns$Resolved$;
import org.apache.pekko.io.DnsExt;
import org.apache.pekko.io.IO$;
import org.apache.pekko.io.IpVersionSelector$;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.routing.ConsistentHashingRouter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@DoNotInherit
public abstract class Dns {
    public static Extension apply(ActorSystem actorSystem) {
        return Dns$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Dns$.MODULE$.apply(classicActorSystemProvider);
    }

    public static DnsExt createExtension(ExtendedActorSystem extendedActorSystem) {
        return Dns$.MODULE$.createExtension(extendedActorSystem);
    }

    public static DnsExt get(ActorSystem actorSystem) {
        return Dns$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return Dns$.MODULE$.get(actorSystem);
    }

    public static DnsExt get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Dns$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Dns$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return Dns$.MODULE$.lookup();
    }

    public Option<Resolved> cached(String name) {
        return None$.MODULE$;
    }

    public Option<Resolved> resolve(String name, ActorSystem system, ActorRef sender) {
        Option<Resolved> ret = this.cached(name);
        if (ret.isEmpty()) {
            IO$.MODULE$.apply(Dns$.MODULE$, system).tell(Dns$Resolve$.MODULE$.apply(name), sender);
        }
        return ret;
    }

    public Option<DnsProtocol.Resolved> cached(DnsProtocol.Resolve request) {
        return None$.MODULE$;
    }

    public Option<DnsProtocol.Resolved> resolve(DnsProtocol.Resolve request, ActorSystem system, ActorRef sender) {
        Option<DnsProtocol.Resolved> ret = this.cached(request);
        if (ret.isEmpty()) {
            IO$.MODULE$.apply(Dns$.MODULE$, system).tell(request, sender);
        }
        return ret;
    }

    public static interface Command {
    }

    public static class Resolve
    implements Command,
    ConsistentHashingRouter.ConsistentHashable,
    Product,
    Serializable {
        private final String name;

        public static Resolve apply(String string2) {
            return Dns$Resolve$.MODULE$.apply(string2);
        }

        public static Resolve fromProduct(Product product) {
            return Dns$Resolve$.MODULE$.fromProduct(product);
        }

        public static Resolve unapply(Resolve resolve) {
            return Dns$Resolve$.MODULE$.unapply(resolve);
        }

        public Resolve(String name) {
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Resolve)) return false;
            Resolve resolve = (Resolve)object;
            String string2 = this.name();
            String string3 = resolve.name();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!resolve.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Resolve;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Resolve";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String name() {
            return this.name;
        }

        @Override
        public Object consistentHashKey() {
            return this.name();
        }

        public Resolve copy(String name) {
            return new Resolve(name);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String _1() {
            return this.name();
        }
    }

    public static class Resolved
    implements Command,
    Product,
    Serializable {
        private final String name;
        private final Seq ipv4;
        private final Seq ipv6;
        private final Option addrOption;

        public static Resolved apply(DnsProtocol.Resolved resolved) {
            return Dns$Resolved$.MODULE$.apply(resolved);
        }

        public static Resolved apply(String string2, Iterable<InetAddress> iterable) {
            return Dns$Resolved$.MODULE$.apply(string2, iterable);
        }

        public static Resolved apply(String string2, Seq<Inet4Address> seq, Seq<Inet6Address> seq2) {
            return Dns$Resolved$.MODULE$.apply(string2, seq, seq2);
        }

        public static Resolved fromProduct(Product product) {
            return Dns$Resolved$.MODULE$.fromProduct(product);
        }

        public static Resolved unapply(Resolved resolved) {
            return Dns$Resolved$.MODULE$.unapply(resolved);
        }

        public Resolved(String name, Seq<Inet4Address> ipv4, Seq<Inet6Address> ipv6) {
            this.name = name;
            this.ipv4 = ipv4;
            this.ipv6 = ipv6;
            this.addrOption = IpVersionSelector$.MODULE$.getInetAddress(ipv4.headOption(), ipv6.headOption());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Resolved)) return false;
            Resolved resolved = (Resolved)object;
            String string2 = this.name();
            String string3 = resolved.name();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            Seq<Inet4Address> seq = this.ipv4();
            Seq<Inet4Address> seq2 = resolved.ipv4();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<Inet6Address> seq3 = this.ipv6();
            Seq<Inet6Address> seq4 = resolved.ipv6();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            if (!resolved.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Resolved;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Resolved";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "ipv4";
                }
                case 2: {
                    return "ipv6";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String name() {
            return this.name;
        }

        public Seq<Inet4Address> ipv4() {
            return this.ipv4;
        }

        public Seq<Inet6Address> ipv6() {
            return this.ipv6;
        }

        public Option<InetAddress> addrOption() {
            return this.addrOption;
        }

        public InetAddress addr() throws UnknownHostException {
            Option<InetAddress> option = this.addrOption();
            if (option instanceof Some) {
                InetAddress ipAddress = (InetAddress)((Some)option).value();
                return ipAddress;
            }
            if (None$.MODULE$.equals(option)) {
                throw new UnknownHostException(this.name());
            }
            throw new MatchError(option);
        }

        public Resolved copy(String name, Seq<Inet4Address> ipv4, Seq<Inet6Address> ipv6) {
            return new Resolved(name, ipv4, ipv6);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Seq<Inet4Address> copy$default$2() {
            return this.ipv4();
        }

        public Seq<Inet6Address> copy$default$3() {
            return this.ipv6();
        }

        public String _1() {
            return this.name();
        }

        public Seq<Inet4Address> _2() {
            return this.ipv4();
        }

        public Seq<Inet6Address> _3() {
            return this.ipv6();
        }
    }
}

