/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.shaded.com.twitter.hpack;

import java.io.IOException;
import java.io.OutputStream;

final class HuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;

    HuffmanEncoder(int[] nArray, byte[] byArray) {
        this.codes = nArray;
        this.lengths = byArray;
    }

    public void encode(OutputStream outputStream, String string2) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        if (string2 == null) {
            throw new NullPointerException("string");
        }
        long l = 0L;
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = string2.charAt(i) & 0xFF;
            int n4 = this.codes[n3];
            byte by = this.lengths[n3];
            l <<= by;
            l |= (long)n4;
            n += by;
            while (n >= 8) {
                outputStream.write((int)(l >> (n -= 8)));
            }
        }
        if (n > 0) {
            l <<= 8 - n;
            outputStream.write((int)(l |= (long)(255 >>> n)));
        }
    }

    public int getEncodedLength(String string2) {
        if (string2 == null) {
            throw new NullPointerException("data");
        }
        long l = 0L;
        for (int i = 0; i < string2.length(); ++i) {
            l += (long)this.lengths[string2.charAt(i) & 0xFF];
        }
        return (int)(l + 7L >> 3);
    }
}

