/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.shaded.com.twitter.hpack;

import org.apache.pekko.http.shaded.com.twitter.hpack.HpackUtil;

class HeaderField
implements Comparable<HeaderField> {
    static final int HEADER_ENTRY_OVERHEAD = 32;
    final String name;
    final String value;
    Object parsedValue = null;

    static int sizeOf(String string2, String string3) {
        return string2.length() + string3.length() + 32;
    }

    HeaderField(String string2, String string3) {
        this.name = HpackUtil.requireNonNull(string2);
        this.value = HpackUtil.requireNonNull(string3);
    }

    HeaderField(String string2, String string3, Object object) {
        this.name = HpackUtil.requireNonNull(string2);
        this.value = HpackUtil.requireNonNull(string3);
        this.parsedValue = object;
    }

    int size() {
        return this.name.length() + this.value.length() + 32;
    }

    @Override
    public int compareTo(HeaderField headerField) {
        int n = this.compareTo(this.name, headerField.name);
        if (n == 0) {
            n = this.compareTo(this.value, headerField.value);
        }
        return n;
    }

    private int compareTo(String string2, String string3) {
        return string2.compareTo(string3);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HeaderField)) {
            return false;
        }
        HeaderField headerField = (HeaderField)object;
        return this.name.equals(headerField.name) && this.value.equals(headerField.value);
    }

    public String toString() {
        return this.name + ": " + this.value;
    }
}

