/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.shaded.com.twitter.hpack;

import java.io.IOException;
import java.io.InputStream;
import org.apache.pekko.http.impl.util.StringTools;
import org.apache.pekko.http.shaded.com.twitter.hpack.DynamicTable;
import org.apache.pekko.http.shaded.com.twitter.hpack.HeaderField;
import org.apache.pekko.http.shaded.com.twitter.hpack.HeaderListener;
import org.apache.pekko.http.shaded.com.twitter.hpack.HpackUtil;
import org.apache.pekko.http.shaded.com.twitter.hpack.Huffman;
import org.apache.pekko.http.shaded.com.twitter.hpack.StaticTable;

public final class Decoder {
    private static final IOException DECOMPRESSION_EXCEPTION = new IOException("decompression failure");
    private static final IOException ILLEGAL_INDEX_VALUE = new IOException("illegal index value");
    private static final IOException INVALID_MAX_DYNAMIC_TABLE_SIZE = new IOException("invalid max dynamic table size");
    private static final IOException MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = new IOException("max dynamic table size change required");
    private static final String EMPTY = "";
    private final DynamicTable dynamicTable;
    private int maxHeaderSize;
    private int maxDynamicTableSize;
    private int encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;
    private long headerSize;
    private State state;
    private HpackUtil.IndexType indexType;
    private int index;
    private boolean huffmanEncoded;
    private int skipLength;
    private int nameLength;
    private int valueLength;
    private String name;

    public Decoder(int n, int n2) {
        this.dynamicTable = new DynamicTable(n2);
        this.maxHeaderSize = n;
        this.maxDynamicTableSize = n2;
        this.encoderMaxDynamicTableSize = n2;
        this.maxDynamicTableSizeChangeRequired = false;
        this.reset();
    }

    private void reset() {
        this.headerSize = 0L;
        this.state = State.READ_HEADER_REPRESENTATION;
        this.indexType = HpackUtil.IndexType.NONE;
    }

    public void decode(InputStream inputStream, HeaderListener headerListener) throws IOException {
        block14: while (inputStream.available() > 0) {
            switch (this.state) {
                case READ_HEADER_REPRESENTATION: {
                    byte by = (byte)inputStream.read();
                    if (this.maxDynamicTableSizeChangeRequired && (by & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (by < 0) {
                        this.index = by & 0x7F;
                        if (this.index == 0) {
                            throw ILLEGAL_INDEX_VALUE;
                        }
                        if (this.index == 127) {
                            this.state = State.READ_INDEXED_HEADER;
                            continue block14;
                        }
                        this.indexHeader(this.index, headerListener);
                        continue block14;
                    }
                    if ((by & 0x40) == 64) {
                        this.indexType = HpackUtil.IndexType.INCREMENTAL;
                        this.index = by & 0x3F;
                        if (this.index == 0) {
                            this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                            continue block14;
                        }
                        if (this.index == 63) {
                            this.state = State.READ_INDEXED_HEADER_NAME;
                            continue block14;
                        }
                        this.readName(this.index);
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                        continue block14;
                    }
                    if ((by & 0x20) == 32) {
                        this.index = by & 0x1F;
                        if (this.index == 31) {
                            this.state = State.READ_MAX_DYNAMIC_TABLE_SIZE;
                            continue block14;
                        }
                        this.setDynamicTableSize(this.index);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        continue block14;
                    }
                    this.indexType = (by & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    this.index = by & 0xF;
                    if (this.index == 0) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                        continue block14;
                    }
                    if (this.index == 15) {
                        this.state = State.READ_INDEXED_HEADER_NAME;
                        continue block14;
                    }
                    this.readName(this.index);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_MAX_DYNAMIC_TABLE_SIZE: {
                    int n = Decoder.decodeULE128(inputStream);
                    if (n == -1) {
                        return;
                    }
                    if (n > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.setDynamicTableSize(this.index + n);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case READ_INDEXED_HEADER: {
                    int n = Decoder.decodeULE128(inputStream);
                    if (n == -1) {
                        return;
                    }
                    if (n > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.indexHeader(this.index + n, headerListener);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case READ_INDEXED_HEADER_NAME: {
                    int n = Decoder.decodeULE128(inputStream);
                    if (n == -1) {
                        return;
                    }
                    if (n > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.readName(this.index + n);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH_PREFIX: {
                    byte by = (byte)inputStream.read();
                    this.huffmanEncoded = (by & 0x80) == 128;
                    this.index = by & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH;
                        continue block14;
                    }
                    this.nameLength = this.index;
                    if (this.nameLength == 0) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                        if (this.nameLength + 32 > this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH: {
                    this.nameLength = Decoder.decodeULE128(inputStream);
                    if (this.nameLength == -1) {
                        return;
                    }
                    if (this.nameLength > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.nameLength += this.index;
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                        if (this.nameLength + 32 > this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME: {
                    if (inputStream.available() < this.nameLength) {
                        return;
                    }
                    this.name = this.readStringLiteral(inputStream, this.nameLength);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case SKIP_LITERAL_HEADER_NAME: {
                    this.skipLength = (int)((long)this.skipLength - inputStream.skip(this.skipLength));
                    if (this.skipLength != 0) continue block14;
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX: {
                    byte by = (byte)inputStream.read();
                    this.huffmanEncoded = (by & 0x80) == 128;
                    this.index = by & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH;
                        continue block14;
                    }
                    this.valueLength = this.index;
                    long l = (long)this.nameLength + (long)this.valueLength;
                    if (this.exceedsMaxHeaderSize(l)) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                        if (l + 32L > (long)this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                    }
                    if (this.valueLength == 0) {
                        this.insertHeader(headerListener, this.name, EMPTY, this.indexType);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        continue block14;
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH: {
                    this.valueLength = Decoder.decodeULE128(inputStream);
                    if (this.valueLength == -1) {
                        return;
                    }
                    if (this.valueLength > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.valueLength += this.index;
                    long l = (long)this.nameLength + (long)this.valueLength;
                    if (l + this.headerSize > (long)this.maxHeaderSize) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                        if (l + 32L > (long)this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE: {
                    if (inputStream.available() < this.valueLength) {
                        return;
                    }
                    String string2 = this.readStringLiteral(inputStream, this.valueLength);
                    this.insertHeader(headerListener, this.name, string2, this.indexType);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case SKIP_LITERAL_HEADER_VALUE: {
                    this.valueLength = (int)((long)this.valueLength - inputStream.skip(this.valueLength));
                    if (this.valueLength != 0) continue block14;
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
            }
            throw new IllegalStateException("should not reach here");
        }
    }

    public boolean endHeaderBlock() {
        boolean bl = this.headerSize > (long)this.maxHeaderSize;
        this.reset();
        return bl;
    }

    public void setMaxHeaderTableSize(int n) {
        this.maxDynamicTableSize = n;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.dynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    public int getMaxHeaderTableSize() {
        return this.dynamicTable.capacity();
    }

    int length() {
        return this.dynamicTable.length();
    }

    int size() {
        return this.dynamicTable.size();
    }

    HeaderField getHeaderField(int n) {
        return this.dynamicTable.getEntry(n + 1);
    }

    private void setDynamicTableSize(int n) throws IOException {
        if (n > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = n;
        this.maxDynamicTableSizeChangeRequired = false;
        this.dynamicTable.setCapacity(n);
    }

    private void readName(int n) throws IOException {
        if (n <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(n);
            this.name = headerField.name;
        } else if (n - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(n - StaticTable.length);
            this.name = headerField.name;
        } else {
            throw ILLEGAL_INDEX_VALUE;
        }
    }

    private void indexHeader(int n, HeaderListener headerListener) throws IOException {
        if (n <= StaticTable.length) {
            Object object;
            HeaderField headerField = StaticTable.getEntry(n);
            headerField.parsedValue = object = this.addHeader(headerListener, headerField.name, headerField.value, headerField.parsedValue, false);
        } else if (n - StaticTable.length <= this.dynamicTable.length()) {
            Object object;
            HeaderField headerField = this.dynamicTable.getEntry(n - StaticTable.length);
            headerField.parsedValue = object = this.addHeader(headerListener, headerField.name, headerField.value, headerField.parsedValue, false);
        } else {
            throw ILLEGAL_INDEX_VALUE;
        }
    }

    private void insertHeader(HeaderListener headerListener, String string2, String string3, HpackUtil.IndexType indexType) {
        Object object = this.addHeader(headerListener, string2, string3, null, indexType == HpackUtil.IndexType.NEVER);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.dynamicTable.add(new HeaderField(string2, string3, object));
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here");
            }
        }
    }

    private Object addHeader(HeaderListener headerListener, String string2, String string3, Object object, boolean bl) {
        if (string2.isEmpty()) {
            throw new AssertionError((Object)"name is empty");
        }
        long l = this.headerSize + (long)string2.length() + (long)string3.length();
        if (l <= (long)this.maxHeaderSize) {
            object = headerListener.addHeader(string2, string3, object, bl);
            this.headerSize = (int)l;
        } else {
            this.headerSize = this.maxHeaderSize + 1;
        }
        return object;
    }

    private boolean exceedsMaxHeaderSize(long l) {
        if (l + this.headerSize <= (long)this.maxHeaderSize) {
            return false;
        }
        this.headerSize = this.maxHeaderSize + 1;
        return true;
    }

    private String readStringLiteral(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        if (inputStream.read(byArray) != n) {
            throw DECOMPRESSION_EXCEPTION;
        }
        byte[] byArray2 = this.huffmanEncoded ? Huffman.DECODER.decode(byArray) : byArray;
        return StringTools.asciiStringFromBytes(byArray2);
    }

    private static int decodeULE128(InputStream inputStream) throws IOException {
        inputStream.mark(5);
        int n = 0;
        for (int i = 0; i < 32; i += 7) {
            if (inputStream.available() == 0) {
                inputStream.reset();
                return -1;
            }
            byte by = (byte)inputStream.read();
            if (i == 28 && (by & 0xF8) != 0) break;
            n |= (by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return n;
        }
        inputStream.reset();
        throw DECOMPRESSION_EXCEPTION;
    }

    private static enum State {
        READ_HEADER_REPRESENTATION,
        READ_MAX_DYNAMIC_TABLE_SIZE,
        READ_INDEXED_HEADER,
        READ_INDEXED_HEADER_NAME,
        READ_LITERAL_HEADER_NAME_LENGTH_PREFIX,
        READ_LITERAL_HEADER_NAME_LENGTH,
        READ_LITERAL_HEADER_NAME,
        SKIP_LITERAL_HEADER_NAME,
        READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX,
        READ_LITERAL_HEADER_VALUE_LENGTH,
        READ_LITERAL_HEADER_VALUE,
        SKIP_LITERAL_HEADER_VALUE;

    }
}

